/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.render;

import com.mojang.blaze3d.shaders.FogShape;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FogRenderer.class})
public abstract class MixinBackgroundRenderer {
    @Unique
    private static boolean wasLava;

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;Lorg/joml/Vector4f;FZF)Lnet/minecraft/client/renderer/FogParameters;"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/effect/MobEffects;FIRE_RESISTANCE:Lnet/minecraft/core/Holder;"), to=@At(value="FIELD", target="Lnet/minecraft/world/level/material/FogType;POWDER_SNOW:Lnet/minecraft/world/level/material/FogType;"))}, constant={@Constant(floatValue=0.25f)}, require=0)
    private static float reduceLavaFogStart(float original) {
        wasLava = true;
        if (FeatureToggle.TWEAK_LAVA_VISIBILITY.getBooleanValue()) {
            return 0.0f;
        }
        return original;
    }

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;Lorg/joml/Vector4f;FZF)Lnet/minecraft/client/renderer/FogParameters;"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/effect/MobEffects;FIRE_RESISTANCE:Lnet/minecraft/core/Holder;"), to=@At(value="FIELD", target="Lnet/minecraft/world/level/material/FogType;POWDER_SNOW:Lnet/minecraft/world/level/material/FogType;"))}, constant={@Constant(floatValue=1.0f), @Constant(floatValue=5.0f)}, require=0)
    private static float reduceLavaFogEnd(float original) {
        wasLava = true;
        if (FeatureToggle.TWEAK_LAVA_VISIBILITY.getBooleanValue()) {
            return RenderUtils.getLavaFogDistance(Minecraft.getInstance().getCameraEntity(), original);
        }
        return original;
    }

    @Redirect(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)Lorg/joml/Vector4f;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel$ClientLevelData;getClearColorScale()F"))
    private static float tweakeroo_disableSkyDarkness(ClientLevel.ClientLevelData props) {
        return Configs.Disable.DISABLE_SKY_DARKNESS.getBooleanValue() ? 1.0f : props.getClearColorScale();
    }

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;Lorg/joml/Vector4f;FZF)Lnet/minecraft/client/renderer/FogParameters;"}, require=0, at={@At(value="RETURN", remap=false)}, cancellable=true)
    private static void disableRenderDistanceFog(Camera camera, FogRenderer.FogMode fogType, Vector4f v, float viewDistance, boolean thickFog, float tickDelta, CallbackInfoReturnable<FogParameters> cir) {
        if (Configs.Disable.DISABLE_RENDER_DISTANCE_FOG.getBooleanValue()) {
            if (!thickFog && !wasLava) {
                float distance = Math.max(512.0f, Minecraft.getInstance().gameRenderer.getRenderDistance());
                cir.setReturnValue((Object)new FogParameters(distance * 1.6f, distance * 2.0f, FogShape.CYLINDER, v.x, v.y, v.z, v.w));
            }
            wasLava = false;
        }
    }
}

