/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.tweaks;

import com.mojang.blaze3d.platform.InputConstants;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.MessageOutputType;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.EntityRestriction;
import fi.dy.masa.tweakeroo.util.IMinecraftClientInvoker;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import fi.dy.masa.tweakeroo.util.PotionRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import org.jetbrains.annotations.NotNull;

public class MiscTweaks {
    public static final EntityRestriction ENTITY_TYPE_ATTACK_RESTRICTION = new EntityRestriction();
    public static final PotionRestriction POTION_RESTRICTION = new PotionRestriction();
    private static final KeybindState KEY_STATE_ATTACK = new KeybindState(Minecraft.getInstance().options.keyAttack, mc -> ((IMinecraftClientInvoker)mc).tweakeroo_invokeDoAttack());
    private static final KeybindState KEY_STATE_USE = new KeybindState(Minecraft.getInstance().options.keyUse, mc -> ((IMinecraftClientInvoker)mc).tweakeroo_invokeDoItemUse());
    private static int potionWarningTimer;

    public static void onTick(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        MiscTweaks.doPeriodicClicks(mc);
        MiscTweaks.doPotionWarnings((Player)player);
        if (FeatureToggle.TWEAK_REPAIR_MODE.getBooleanValue()) {
            InventoryUtils.repairModeSwapItems((Player)player);
        }
        CameraEntity.movementTick();
    }

    public static void onGameLoop(Minecraft mc) {
        PlacementTweaks.onTick(mc);
        RenderTweaks.onTick();
        Tweakeroo.renderCountItems = 0;
        Tweakeroo.renderCountXPOrbs = 0;
    }

    private static void doPeriodicClicks(Minecraft mc) {
        if (GuiUtils.getCurrentScreen() == null) {
            MiscTweaks.handlePeriodicClicks(KEY_STATE_ATTACK, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_HOLD_ATTACK, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_ATTACK, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_ATTACK_INTERVAL, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_ATTACK_DURATION, (IConfigInteger)Configs.Generic.PERIODIC_ATTACK_INTERVAL, mc);
            MiscTweaks.handlePeriodicClicks(KEY_STATE_USE, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_HOLD_USE, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_USE, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_USE_INTERVAL, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_USE_DURATION, (IConfigInteger)Configs.Generic.PERIODIC_USE_INTERVAL, mc);
        } else {
            KEY_STATE_ATTACK.reset();
            KEY_STATE_USE.reset();
        }
    }

    private static void handlePeriodicClicks(KeybindState keyState, IConfigBoolean cfgPeriodicHold, IConfigBoolean cfgPeriodicClick, IConfigInteger cfgHoldClickInterval, IConfigInteger cfgHoldDuration, IConfigInteger cfgClickInterval, Minecraft mc) {
        if (cfgPeriodicHold.getBooleanValue()) {
            int interval = cfgHoldClickInterval.getIntegerValue();
            int holdDuration = cfgHoldDuration.getIntegerValue();
            keyState.handlePeriodicHold(interval, holdDuration, mc);
        } else if (cfgPeriodicClick.getBooleanValue()) {
            int interval = cfgClickInterval.getIntegerValue();
            keyState.handlePeriodicClick(interval, mc);
        } else {
            keyState.reset();
        }
    }

    private static void doPotionWarnings(Player player) {
        if (FeatureToggle.TWEAK_POTION_WARNING.getBooleanValue() && ++potionWarningTimer >= 100) {
            potionWarningTimer = 0;
            Collection effects = player.getActiveEffects();
            if (!effects.isEmpty()) {
                int minDuration = -1;
                int count = 0;
                for (MobEffectInstance effectInstance : effects) {
                    if (!MiscTweaks.potionWarningShouldInclude(effectInstance)) continue;
                    ++count;
                    if (effectInstance.getDuration() >= minDuration && minDuration >= 0) continue;
                    minDuration = effectInstance.getDuration();
                }
                if (count > 0) {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.potion_effects_running_out", (Object[])new Object[]{count, minDuration / 20});
                }
            }
        }
    }

    public static boolean isEntityAllowedByAttackingRestriction(EntityType<?> type) {
        if (!ENTITY_TYPE_ATTACK_RESTRICTION.isAllowed(type)) {
            MessageOutputType messageOutputType = (MessageOutputType)Configs.Generic.ENTITY_TYPE_ATTACK_RESTRICTION_WARN.getOptionListValue();
            if (messageOutputType == MessageOutputType.MESSAGE) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakeroo.message.warning.entity_type_attack_restriction", (Object[])new Object[0]);
            } else if (messageOutputType == MessageOutputType.ACTIONBAR) {
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.warning.entity_type_attack_restriction", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean potionWarningShouldInclude(MobEffectInstance effect) {
        return !effect.isAmbient() && (((MobEffect)effect.getEffect().value()).isBeneficial() || !Configs.Generic.POTION_WARNING_BENEFICIAL_ONLY.getBooleanValue()) && effect.getDuration() <= Configs.Generic.POTION_WARNING_THRESHOLD.getIntegerValue() && effect.getDuration() >= 0 && POTION_RESTRICTION.isAllowed((MobEffect)effect.getEffect().value());
    }

    @NotNull
    public static List<FlatLayerInfo> parseBlockString(String blockString) {
        List<Object> list = new ArrayList<FlatLayerInfo>();
        String[] strings = blockString.split(",");
        int count = strings.length;
        int thicknessSum = 0;
        for (int i = 0; i < count; ++i) {
            String str = strings[i];
            FlatLayerInfo layer = MiscTweaks.parseLayerString(str, thicknessSum);
            if (layer == null) {
                list = Collections.emptyList();
                break;
            }
            list.add(layer);
            thicknessSum += layer.getHeight();
        }
        return list;
    }

    @Nullable
    private static FlatLayerInfo parseLayerString(String string, int startY) {
        Block block;
        int thickness;
        String[] strings = string.split("\\*", 2);
        if (strings.length == 2) {
            try {
                thickness = Math.max(Integer.parseInt(strings[0]), 0);
            }
            catch (NumberFormatException e) {
                Tweakeroo.LOGGER.error("Error while parsing flat world string => {}", (Object)e.getMessage());
                return null;
            }
        } else {
            thickness = 1;
        }
        int endY = Math.min(startY + thickness, 256);
        int finalThickness = endY - startY;
        try {
            block = MiscTweaks.getBlockFromName(strings[strings.length - 1]);
        }
        catch (Exception e) {
            Tweakeroo.LOGGER.error("Error while parsing flat world string => {}", (Object)e.getMessage());
            return null;
        }
        if (block == null) {
            Tweakeroo.LOGGER.error("Error while parsing flat world string => Unknown block, {}", (Object)strings[strings.length - 1]);
            return null;
        }
        return new FlatLayerInfo(finalThickness, block);
    }

    @Nullable
    private static Block getBlockFromName(String name) {
        try {
            Optional opt = BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)name));
            if (opt.isPresent()) {
                return (Block)((Holder.Reference)opt.get()).value();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class KeybindState {
        private final KeyMapping keybind;
        private final Consumer<Minecraft> clickFunc;
        private boolean state;
        private int durationCounter;
        private int intervalCounter;

        public KeybindState(KeyMapping keybind, Consumer<Minecraft> clickFunc) {
            this.keybind = keybind;
            this.clickFunc = clickFunc;
        }

        public void reset() {
            this.state = false;
            this.intervalCounter = 0;
            this.durationCounter = 0;
        }

        public void handlePeriodicHold(int interval, int holdDuration, Minecraft mc) {
            if (this.state) {
                if (++this.durationCounter >= holdDuration) {
                    this.setKeyState(false, mc);
                    this.durationCounter = 0;
                }
            } else if (++this.intervalCounter >= interval) {
                this.setKeyState(true, mc);
                this.intervalCounter = 0;
                this.durationCounter = 0;
            }
        }

        public void handlePeriodicClick(int interval, Minecraft mc) {
            if (++this.intervalCounter >= interval) {
                this.clickFunc.accept(mc);
                this.intervalCounter = 0;
                this.durationCounter = 0;
            }
        }

        private void setKeyState(boolean state, Minecraft mc) {
            this.state = state;
            InputConstants.Key key = InputConstants.getKey((String)this.keybind.saveString());
            KeyMapping.set((InputConstants.Key)key, (boolean)state);
            if (state) {
                this.clickFunc.accept(mc);
                KeyMapping.click((InputConstants.Key)key);
            }
        }
    }
}

