/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.time.TimeFormat;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.mixin.block.IMixinCommandBlockExecutor;
import fi.dy.masa.tweakeroo.mixin.item.IMixinAxeItem;
import fi.dy.masa.tweakeroo.mixin.item.IMixinShovelItem;
import fi.dy.masa.tweakeroo.mixin.screen.IMixinCustomizeFlatLevelScreen;
import fi.dy.masa.tweakeroo.mixin.world.IMixinClientWorld;
import fi.dy.masa.tweakeroo.tweaks.MiscTweaks;
import fi.dy.masa.tweakeroo.util.IGuiEditSign;
import fi.dy.masa.tweakeroo.util.ISignTextAccess;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.CreateFlatWorldScreen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MiscUtils {
    public static final Pattern PATTERN_WORLD_PRESET = Pattern.compile("^(?<name>[a-zA-Z0-9_/&*#!=()\\[\\]{} -]+);(?<blocks>[a-z0-9_:.*,-]+);(?<biome>[a-z0-9_:.-]+);(?<options>[a-z0-9_, ()=]*);(?<icon>[a-z0-9_:.-]+)$");
    private static SignText previousSignText;
    private static String previousChatText;
    private static final Date DATE;
    private static double mouseSensitivity;
    private static boolean zoomActive;
    private static PostKeyAction lastZoomValue;

    public static void handlePlayerDeceleration() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientInput input = player.input;
        if (input.keyPresses.jump() || input.keyPresses.shift() || player.zza != 0.0f || player.xxa != 0.0f || !player.getAbilities().flying) {
            return;
        }
        double factor = Configs.Generic.FLY_DECELERATION_FACTOR.getDoubleValue();
        player.setDeltaMovement(player.getDeltaMovement().scale(factor));
    }

    public static Vec3 calculatePlayerMotionWithDeceleration(Vec3 lastMotion, double rampAmount, double decelerationFactor) {
        Options options = Minecraft.getInstance().options;
        int forward = 0;
        int vertical = 0;
        int strafe = 0;
        if (options.keyUp.isDown()) {
            ++forward;
        }
        if (options.keyDown.isDown()) {
            --forward;
        }
        if (options.keyLeft.isDown()) {
            ++strafe;
        }
        if (options.keyRight.isDown()) {
            --strafe;
        }
        if (options.keyJump.isDown()) {
            ++vertical;
        }
        if (options.keyShift.isDown()) {
            --vertical;
        }
        double speed = forward != 0 && strafe != 0 ? 1.2 : 1.0;
        double forwardRamped = MiscUtils.getRampedMotion(lastMotion.x, forward, rampAmount, decelerationFactor) / speed;
        double verticalRamped = MiscUtils.getRampedMotion(lastMotion.y, vertical, rampAmount, decelerationFactor);
        double strafeRamped = MiscUtils.getRampedMotion(lastMotion.z, strafe, rampAmount, decelerationFactor) / speed;
        return new Vec3(forwardRamped, verticalRamped, strafeRamped);
    }

    public static double getRampedMotion(double current, int input, double rampAmount, double decelerationFactor) {
        if (input != 0) {
            if (input < 0) {
                rampAmount *= -1.0;
            }
            if (input < 0 != current < 0.0) {
                current = 0.0;
            }
            current = Mth.clamp((double)(current + rampAmount), (double)-1.0, (double)1.0);
        } else {
            current *= decelerationFactor;
        }
        return current;
    }

    public static boolean isZoomActive() {
        return FeatureToggle.TWEAK_ZOOM.getBooleanValue() && Hotkeys.ZOOM_ACTIVATE.getKeybind().isKeybindHeld();
    }

    public static void checkZoomStatus() {
        if (zoomActive && !MiscUtils.isZoomActive()) {
            MiscUtils.onZoomDeactivated();
        }
    }

    public static void onZoomActivated() {
        if (Configs.Generic.ZOOM_ADJUST_MOUSE_SENSITIVITY.getBooleanValue()) {
            MiscUtils.setMouseSensitivityForZoom();
            lastZoomValue = new PostKeyAction(Configs.Generic.ZOOM_FOV.getDoubleValue());
        }
        zoomActive = true;
    }

    public static void onZoomDeactivated() {
        if (zoomActive) {
            MiscUtils.resetMouseSensitivityForZoom();
            if (lastZoomValue != null && lastZoomValue.isActive()) {
                if (lastZoomValue.getLastDoubleValue() != Configs.Generic.ZOOM_FOV.getDoubleValue() && Configs.Generic.ZOOM_RESET_FOV_ON_ACTIVATE.getBooleanValue()) {
                    Configs.Generic.ZOOM_FOV.setDoubleValue(lastZoomValue.getLastDoubleValue());
                }
                lastZoomValue.setActionHandled();
            }
            Minecraft.getInstance().levelRenderer.needsUpdate();
            zoomActive = false;
        }
    }

    public static void setMouseSensitivityForZoom() {
        double origFov;
        Minecraft mc = Minecraft.getInstance();
        double fov = Configs.Generic.ZOOM_FOV.getDoubleValue();
        if (fov < (origFov = (double)((Integer)mc.options.fov().get()).intValue())) {
            if (mouseSensitivity <= 0.0 || mouseSensitivity > 1.0) {
                mouseSensitivity = (Double)mc.options.sensitivity().get();
            }
            double min = 0.04;
            double sens = min + (0.5 - min) * (1.0 - (origFov - fov) / origFov);
            mc.options.sensitivity().set((Object)Math.min(mouseSensitivity, sens));
        }
    }

    public static void resetMouseSensitivityForZoom() {
        if (mouseSensitivity > 0.0) {
            Minecraft.getInstance().options.sensitivity().set((Object)mouseSensitivity);
            mouseSensitivity = -1.0;
        }
    }

    public static boolean isStrippableLog(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return IMixinAxeItem.tweakeroo_getStrippedBlocks().containsKey(state.getBlock());
    }

    public static boolean isShovelPathConvertableBlock(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return IMixinShovelItem.tweakeroo_getPathStates().containsKey(state.getBlock());
    }

    public static boolean getUpdateExec(CommandBlockEntity te) {
        return ((IMixinCommandBlockExecutor)te.getCommandBlock()).getUpdateLastExecution();
    }

    public static void setUpdateExec(CommandBlockEntity te, boolean value) {
        ((IMixinCommandBlockExecutor)te.getCommandBlock()).setUpdateLastExecution(value);
    }

    public static void printDeathCoordinates(Minecraft mc) {
        BlockPos pos = PositionUtils.getEntityBlockPos((Entity)mc.player);
        String dim = mc.player.getCommandSenderWorld().dimension().location().toString();
        String str = StringUtils.translate((String)"tweakeroo.message.death_coordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), dim});
        MutableComponent message = Component.literal((String)str);
        Style style = message.getStyle();
        String coords = pos.getX() + " " + pos.getY() + " " + pos.getZ();
        style = style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, coords));
        style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)coords)));
        message.setStyle(style);
        mc.gui.getChat().addMessage((Component)message);
        Tweakeroo.LOGGER.info(str);
    }

    public static String getChatTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.CHAT_TIME_FORMAT.getStringValue());
        DATE.setTime(System.currentTimeMillis());
        return sdf.format(DATE);
    }

    public static void setLastChatText(String text) {
        previousChatText = text;
    }

    public static String getLastChatText() {
        return previousChatText;
    }

    public static int getChatBackgroundColor(int colorOrig) {
        int newColor = Configs.Generic.CHAT_BACKGROUND_COLOR.getIntegerValue();
        return newColor & 0xFFFFFF | (int)((double)(newColor >>> 24) / 255.0 * ((double)(colorOrig >>> 24) / 255.0) / 0.5 * 255.0) << 24;
    }

    public static void copyTextFromSign(SignBlockEntity te, boolean front) {
        previousSignText = ((ISignTextAccess)te).tweakeroo$getText(front);
    }

    public static void applyPreviousTextToSign(SignBlockEntity te, @Nullable AbstractSignEditScreen guiLines, boolean front) {
        if (previousSignText != null) {
            te.setText(previousSignText, front);
            if (guiLines != null) {
                ((IGuiEditSign)guiLines).tweakeroo$applyText(previousSignText);
            }
        }
    }

    public static boolean commandNearbyPets(boolean sitDown) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        LocalPlayer player = mc.player;
        if (world != null && player != null) {
            UUID uuid = player.getUUID();
            double centerX = player.getX();
            double centerY = player.getY();
            double centerZ = player.getZ();
            double range = 6.0;
            AABB box = new AABB(centerX - range, centerY - range, centerZ - range, centerX + range, centerY + range, centerZ + range);
            Predicate<Entity> filter = e -> MiscUtils.isTameableOwnedBy(e, uuid);
            for (Entity entity : world.getEntities(null, box, filter)) {
                if (((TamableAnimal)entity).isInSittingPose() == sitDown) continue;
                MiscUtils.rightClickEntity(entity, mc, (Player)player);
            }
        }
        return true;
    }

    public static boolean isTameableOwnedBy(Entity entity, UUID ownerUuid) {
        return entity instanceof TamableAnimal && ownerUuid.equals(((TamableAnimal)entity).getOwnerUUID()) && ((TamableAnimal)entity).isTame();
    }

    public static void rightClickEntity(Entity entity, Minecraft mc, Player player) {
        InteractionResult.Success success;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        InteractionResult actionResult = mc.gameMode.interactAt(player, entity, new EntityHitResult(entity), hand);
        if (!actionResult.consumesAction()) {
            actionResult = mc.gameMode.interact(player, entity, hand);
        }
        if (actionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)actionResult).swingSource() == InteractionResult.SwingSource.CLIENT) {
            player.swing(hand);
        }
    }

    public static void setEntityRotations(Entity entity, float yaw, float pitch) {
        entity.setYRot(yaw);
        entity.setXRot(pitch);
        entity.yRotO = yaw;
        entity.xRotO = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.yHeadRot = yaw;
            living.yHeadRotO = yaw;
        }
    }

    public static Vec3 getEyesPos(Player player) {
        return new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(player.getPose()), player.getZ());
    }

    public static BlockPos getPlayerHeadPos(Player player) {
        return player.getPose() == Pose.STANDING ? player.blockPosition().relative(Direction.UP) : player.blockPosition();
    }

    public static boolean isInReach(BlockPos pos, Player player, double reach) {
        double d2;
        double d1;
        Vec3 playerpos = MiscUtils.getEyesPos(player);
        double d = playerpos.x() - ((double)pos.getX() + 0.5);
        return d * d + (d1 = playerpos.y() - ((double)pos.getY() + 0.5)) * d1 + (d2 = playerpos.z() - ((double)pos.getZ() + 0.5)) * d2 <= reach * reach;
    }

    public static boolean writeAllMapsAsImages() {
        Path dir;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return true;
        }
        Map<MapId, MapItemSavedData> data = ((IMixinClientWorld)mc.level).tweakeroo_getMapStates();
        String worldName = StringUtils.getWorldOrServerName();
        if (worldName == null) {
            worldName = TimeFormat.REGULAR.formatNow();
        }
        if (!Files.exists(dir = FileUtils.getConfigDirectoryAsPath().resolve("tweakeroo").resolve("map_images").resolve(worldName), new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing((Path)dir);
        }
        if (Files.isDirectory(dir, new LinkOption[0])) {
            int count = 0;
            for (Map.Entry<MapId, MapItemSavedData> entry : data.entrySet()) {
                Path file = dir.resolve(entry.getKey().key() + ".png");
                MiscUtils.writeMapAsImage(file, entry.getValue());
                ++count;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.INFO, (String)String.format("Wrote %d maps to image files", count), (Object[])new Object[0]);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to create directory: " + String.valueOf(dir.toAbsolutePath())), (Object[])new Object[0]);
        }
        return true;
    }

    private static void writeMapAsImage(Path fileOut, MapItemSavedData state) {
        BufferedImage image = new BufferedImage(128, 128, 2);
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                int index = x + y * 128;
                int color = MapColor.getColorFromPackedId((int)state.colors[index]);
                image.setRGB(x, y, color);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", fileOut.toFile());
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to write image to file: " + String.valueOf(fileOut.toAbsolutePath())), (Object[])new Object[0]);
        }
    }

    public static boolean isShulkerBox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock;
    }

    public static boolean hasCustomMaxStackSize(ItemStack stack) {
        int currentStackSize;
        int defaultStackSize = (Integer)stack.getPrototype().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
        return defaultStackSize != (currentStackSize = ((Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1)).intValue());
    }

    public static boolean registerPresetFromString(CreateFlatWorldScreen screen, String str) {
        Matcher matcher = PATTERN_WORLD_PRESET.matcher(str);
        if (matcher.matches()) {
            Holder.Reference referenceEntry;
            WorldCreationContext generatorOptionsHolder = ((IMixinCustomizeFlatLevelScreen)screen).tweakeroo_getCreateWorldParent().getUiState().getSettings();
            RegistryAccess.Frozen registryManager = generatorOptionsHolder.worldgenLoadContext();
            FeatureFlagSet featureSet = generatorOptionsHolder.dataConfiguration().enabledFeatures();
            Registry biomeLookup = registryManager.lookupOrThrow(Registries.BIOME);
            Registry structureLookup = registryManager.lookupOrThrow(Registries.STRUCTURE_SET);
            Registry featuresLookup = registryManager.lookupOrThrow(Registries.PLACED_FEATURE);
            HolderLookup.RegistryLookup blockLookup = registryManager.lookupOrThrow(Registries.BLOCK).filterFeatures(featureSet);
            FlatLevelGeneratorSettings defaultConfig = FlatLevelGeneratorSettings.getDefault((HolderGetter)biomeLookup, (HolderGetter)structureLookup, (HolderGetter)featuresLookup);
            FlatLevelGeneratorSettings currentConfig = screen.settings();
            Holder.Reference biomeEntry = referenceEntry = biomeLookup.getOrThrow(Biomes.PLAINS);
            String name = matcher.group("name");
            String blocksString = matcher.group("blocks");
            String biomeName = matcher.group("biome");
            String iconItemName = matcher.group("icon");
            try {
                Optional<ResourceKey> optBiome = Optional.ofNullable(ResourceLocation.tryParse((String)biomeName)).map(biomeId -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeId));
                biomeEntry = optBiome.flatMap(arg_0 -> ((HolderGetter)biomeLookup).get(arg_0)).orElse(referenceEntry);
            }
            catch (Exception optBiome) {
                // empty catch block
            }
            if (biomeEntry == null) {
                Tweakeroo.LOGGER.error("Invalid biome while parsing flat world string: '{}'", (Object)biomeName);
                return false;
            }
            Item item = null;
            try {
                Optional opt = BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)iconItemName));
                if (opt.isPresent()) {
                    item = (Item)((Holder.Reference)opt.get()).value();
                }
            }
            catch (Exception opt) {
                // empty catch block
            }
            if (item == null) {
                Tweakeroo.LOGGER.error("Invalid item for icon while parsing flat world string: '{}'", (Object)iconItemName);
                return false;
            }
            List<FlatLayerInfo> layers = MiscTweaks.parseBlockString(blocksString);
            if (layers == null) {
                Tweakeroo.LOGGER.error("Failed to get the layers for the flat world preset");
                return false;
            }
            FlatLevelGeneratorSettings newConfig = defaultConfig.withBiomeAndLayers(layers, defaultConfig.structureOverrides(), (Holder)biomeEntry);
            screen.setConfig(newConfig);
            return true;
        }
        Tweakeroo.LOGGER.error("Flat world preset string did not match the regex");
        return false;
    }

    static {
        previousChatText = "";
        DATE = new Date();
        mouseSensitivity = -1.0;
    }

    public static class PostKeyAction {
        private int lastIntValue;
        private double lastDoubleValue;
        private long lastActive;
        private boolean active = false;

        public PostKeyAction(int lastIntValue) {
            this.lastIntValue = lastIntValue;
            this.lastDoubleValue = -1.0;
            this.lastActive = Util.getNanos();
            this.active = true;
        }

        public PostKeyAction(double lastDoubleValue) {
            this.lastDoubleValue = lastDoubleValue;
            this.lastIntValue = -1;
            this.lastActive = Util.getNanos();
            this.active = true;
        }

        public boolean isActive() {
            return this.active;
        }

        public int getLastIntValue() {
            return this.lastIntValue;
        }

        public double getLastDoubleValue() {
            return this.lastDoubleValue;
        }

        public long getLastActive() {
            return this.lastActive;
        }

        public void setActionHandled() {
            this.lastIntValue = -1;
            this.lastDoubleValue = -1.0;
            this.lastActive = Util.getNanos();
            this.active = false;
        }
    }
}

