/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.world;

import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.world.FakeChunk;
import fi.dy.masa.tweakeroo.world.FakeChunkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class FakeWorld
extends Level {
    private static final ResourceKey<Level> REGISTRY_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tweakeroo", (String)"selective_world"));
    private static final ClientLevel.ClientLevelData LEVEL_INFO = new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, true);
    private static final Holder<DimensionType> DIMENSION_TYPE = (Holder)RenderTweaks.getDynamicRegistryManager().get(BuiltinDimensionTypes.OVERWORLD).orElseThrow();
    private final Minecraft mc = Minecraft.getInstance();
    private final FakeChunkManager chunkManager;
    private final Supplier<ProfilerFiller> profiler;
    private RegistryAccess registryManager;

    public FakeWorld(RegistryAccess registryManager, WritableLevelData properties, Holder<DimensionType> dimension, Supplier<ProfilerFiller> profiler, int loadDistance) {
        super(properties, REGISTRY_KEY, registryManager, dimension, true, true, 0L, 0);
        this.registryManager = registryManager;
        this.chunkManager = new FakeChunkManager(this, loadDistance);
        this.profiler = profiler;
    }

    public FakeWorld(RegistryAccess registryManager, int loadDistance) {
        this(registryManager, (WritableLevelData)LEVEL_INFO, DIMENSION_TYPE, Profiler::get, loadDistance);
    }

    public ProfilerFiller getProfiler() {
        return this.profiler.get();
    }

    public FakeChunkManager getChunkProvider() {
        return this.chunkManager;
    }

    public FakeChunkManager getChunkManager() {
        return this.chunkManager;
    }

    public void levelEvent(@Nullable Player player, int eventId, BlockPos pos, int data) {
    }

    public void gameEvent(Holder<GameEvent> event, Vec3 emitterPos, GameEvent.Context emitter) {
    }

    public LevelChunk getChunkAt(BlockPos pos) {
        return this.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
    }

    public FakeChunk getChunk(int chunkX, int chunkZ) {
        return this.chunkManager.getChunk(chunkX, chunkZ);
    }

    public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus status, boolean required) {
        return this.getChunk(chunkX, chunkZ);
    }

    public boolean setBlock(BlockPos pos, BlockState newState, int flags) {
        if (pos.getY() < this.getMinY() || pos.getY() >= this.getMaxY()) {
            return false;
        }
        return this.getChunk(pos.getX() >> 4, pos.getZ() >> 4).setBlockState(pos, newState, false) != null;
    }

    public List<FakeChunk> getChunksWithinBox(AABB box) {
        int minX = Mth.floor((double)(box.minX / 16.0));
        int minZ = Mth.floor((double)(box.minZ / 16.0));
        int maxX = Mth.floor((double)(box.maxX / 16.0));
        int maxZ = Mth.floor((double)(box.maxZ / 16.0));
        ArrayList<FakeChunk> chunks = new ArrayList<FakeChunk>();
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                FakeChunk chunk = this.chunkManager.getChunkIfExists(cx, cz);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public int getMinY() {
        return this.mc.level != null ? this.mc.level.getMinY() : -64;
    }

    public int getHeight() {
        return this.mc.level != null ? this.mc.level.getHeight() : 384;
    }

    public int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public int getMinSectionY() {
        return this.getMinY() >> 4;
    }

    public int getMaxSectionY() {
        return this.getMaxY() >> 4;
    }

    public int getSectionsCount() {
        return this.getMaxSectionY() - this.getMinSectionY();
    }

    public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.isOutsideBuildHeight(pos.getY());
    }

    public boolean isOutsideBuildHeight(int y) {
        return y < this.getMinY() || y >= this.getMaxY();
    }

    public int getSectionIndex(int y) {
        return (y >> 4) - (this.getMinY() >> 4);
    }

    public int getSectionIndexFromSectionY(int coord) {
        return coord - (this.getMinY() >> 4);
    }

    public int getSectionYFromSectionIndex(int index) {
        return index + (this.getMinY() >> 4);
    }

    public String gatherChunkSourceStats() {
        return "Chunks[FAKE] W: " + this.getChunkManager().gatherStats();
    }

    public RegistryAccess registryAccess() {
        if (this.registryManager == null) {
            this.registryManager = RenderTweaks.getDynamicRegistryManager();
        }
        return this.registryManager;
    }

    public PotionBrewing potionBrewing() {
        return null;
    }

    public FuelValues fuelValues() {
        return null;
    }

    public void setDayTimeFraction(float f) {
    }

    public float getDayTimeFraction() {
        return 0.0f;
    }

    public float getDayTimePerTick() {
        return 0.0f;
    }

    public void setDayTimePerTick(float f) {
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return null;
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return null;
    }

    public List<? extends Player> players() {
        return null;
    }

    public Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3) {
        return null;
    }

    public int getSeaLevel() {
        return 0;
    }

    public FeatureFlagSet enabledFeatures() {
        return null;
    }

    public float getShade(Direction var1, boolean var2) {
        return 0.0f;
    }

    public void sendBlockUpdated(BlockPos var1, BlockState var2, BlockState var3, int var4) {
    }

    public void playSeededSound(@Nullable Player source, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@Nullable Player source, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void explode(@Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x, double y, double z, float power, boolean createFire, Level.ExplosionInteraction explosionSourceType, ParticleOptions smallParticle, ParticleOptions largeParticle, Holder<SoundEvent> soundEvent) {
    }

    public Entity getEntity(int var1) {
        return null;
    }

    public Collection<PartEntity<?>> dragonParts() {
        return List.of();
    }

    public TickRateManager tickRateManager() {
        return null;
    }

    @Nullable
    public MapItemSavedData getMapData(MapId id) {
        return null;
    }

    public void setMapData(MapId id, MapItemSavedData state) {
    }

    public MapId getFreeMapId() {
        return null;
    }

    public void destroyBlockProgress(int var1, BlockPos var2, int var3) {
    }

    public Scoreboard getScoreboard() {
        return null;
    }

    public RecipeAccess recipeAccess() {
        return null;
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return null;
    }
}

