/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.event;

import fi.dy.masa.malilib.interfaces.IWorldLoadListener;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.DataManager;
import fi.dy.masa.tweakeroo.data.ServerDataSyncer;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;

public class WorldLoadListener
implements IWorldLoadListener {
    public void onWorldLoadImmutable(RegistryAccess.Frozen immutable) {
        RenderTweaks.setDynamicRegistryManager(immutable);
    }

    public void onWorldLoadPre(@Nullable ClientLevel worldBefore, @Nullable ClientLevel worldAfter, Minecraft mc) {
        FeatureToggle.TWEAK_FREE_CAMERA.setBooleanValue(false);
        if (worldAfter != null) {
            ServerDataSyncer.getInstance().onWorldPre();
        }
    }

    public void onWorldLoadPost(@Nullable ClientLevel worldBefore, @Nullable ClientLevel worldAfter, Minecraft mc) {
        DataManager.getInstance().reset(worldAfter == null);
        ServerDataSyncer.getInstance().reset(worldAfter == null);
        if (worldBefore == null) {
            if (FeatureToggle.TWEAK_GAMMA_OVERRIDE.getBooleanValue()) {
                FeatureToggle.TWEAK_GAMMA_OVERRIDE.setBooleanValue(false);
                FeatureToggle.TWEAK_GAMMA_OVERRIDE.setBooleanValue(true);
            }
            if (FeatureToggle.TWEAK_DARKNESS_VISIBILITY.getBooleanValue() && ((Double)mc.options.darknessEffectScale().get()).doubleValue() != Configs.Generic.DARKNESS_SCALE_OVERRIDE_VALUE.getDoubleValue()) {
                Configs.Internal.DARKNESS_SCALE_VALUE_ORIGINAL.setDoubleValue(((Double)mc.options.darknessEffectScale().get()).doubleValue());
                mc.options.darknessEffectScale().set((Object)Configs.Generic.DARKNESS_SCALE_OVERRIDE_VALUE.getDoubleValue());
            }
            InventoryUtils.clearCache();
        }
        if (worldAfter != null) {
            ServerDataSyncer.getInstance().onWorldJoin();
            InventoryUtils.startCache();
        } else {
            Configs.Internal.SHULKER_MAX_STACK_SIZE.resetToDefault();
        }
    }
}

