/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.entity;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class}, priority=1001)
public abstract class MixinClientPlayerEntity
extends AbstractClientPlayer {
    @Shadow
    public ClientInput input;
    @Shadow
    protected int sprintTriggerTime;
    @Shadow
    public float oPortalEffectIntensity;
    @Shadow
    public float portalEffectIntensity;
    @Shadow
    private boolean wasFallFlying;
    @Unique
    private float realNauseaIntensity;
    @Unique
    private ItemStack autoSwitchElytraChestplate = ItemStack.EMPTY;

    private MixinClientPlayerEntity(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Redirect(method={"handlePortalTransitionEffect(Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;isPauseScreen()Z"))
    private boolean tweakeroo_onDoesGuiPauseGame(Screen gui) {
        if (Configs.Disable.DISABLE_PORTAL_GUI_CLOSING.getBooleanValue()) {
            return true;
        }
        return gui.isPauseScreen();
    }

    @Inject(method={"handlePortalTransitionEffect(Z)V"}, at={@At(value="HEAD")})
    private void tweakeroo_disableNauseaEffectPre(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_NAUSEA_EFFECT.getBooleanValue()) {
            this.portalEffectIntensity = this.realNauseaIntensity;
        }
    }

    @Inject(method={"handlePortalTransitionEffect(Z)V"}, at={@At(value="TAIL")})
    private void tweakeroo_disableNauseaEffectPost(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_NAUSEA_EFFECT.getBooleanValue()) {
            this.realNauseaIntensity = this.portalEffectIntensity;
            this.oPortalEffectIntensity = 0.0f;
            this.portalEffectIntensity = 0.0f;
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;wasFallFlying:Z")})
    private void tweakeroo_overrideSprint(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_PERMANENT_SPRINT.getBooleanValue() && !this.isSprinting() && !this.isUsingItem() && this.input.hasForwardImpulse() && ((float)this.getFoodData().getFoodLevel() > 6.0f || this.getAbilities().mayfly) && !this.hasEffect(MobEffects.BLINDNESS) && !this.isInWater()) {
            this.setSprinting(true);
        }
    }

    @Redirect(method={"shouldStopRunSprinting()Z"}, at=@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;horizontalCollision:Z"))
    private boolean tweakeroo_overrideCollidedHorizontally(LocalPlayer player) {
        if (Configs.Disable.DISABLE_WALL_UNSPRINT.getBooleanValue()) {
            return false;
        }
        return player.horizontalCollision;
    }

    @Inject(method={"aiStep()V"}, at={@At(value="FIELD", opcode=181, ordinal=2, shift=At.Shift.AFTER, target="Lnet/minecraft/client/player/LocalPlayer;sprintTriggerTime:I")})
    private void tweakeroo_disableDoubleTapSprint(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_DOUBLE_TAP_SPRINT.getBooleanValue()) {
            this.sprintTriggerTime = 0;
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/player/LocalPlayer;tryToStartFallFlying()Z")})
    private void tweakeroo_onFallFlyingCheckChestSlot(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_AUTO_SWITCH_ELYTRA.getBooleanValue()) {
            if (!(this.onGround() || this.isPassenger() || this.fallFlyTicks != 0 || this.isInLiquid() || this.onClimbable() || this.hasEffect(MobEffects.LEVITATION) || this.getItemBySlot(EquipmentSlot.CHEST).is(Items.ELYTRA) && this.getItemBySlot(EquipmentSlot.CHEST).getDamageValue() <= this.getItemBySlot(EquipmentSlot.CHEST).getMaxDamage() - 10)) {
                InventoryUtils.equipBestElytra((Player)this);
            }
        } else {
            this.autoSwitchElytraChestplate = ItemStack.EMPTY;
        }
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_onStopFlying(EntityDataAccessor<?> data, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_AUTO_SWITCH_ELYTRA.getBooleanValue() && DATA_SHARED_FLAGS_ID.equals(data) && this.wasFallFlying && !this.isFallFlying() && this.getItemBySlot(EquipmentSlot.CHEST).is(Items.ELYTRA)) {
            if (!this.autoSwitchElytraChestplate.isEmpty() && !this.autoSwitchElytraChestplate.is(Items.ELYTRA)) {
                int targetSlot;
                if (this.inventoryMenu.getCarried().isEmpty() && (targetSlot = InventoryUtils.findSlotWithItem((AbstractContainerMenu)this.inventoryMenu, this.autoSwitchElytraChestplate, true, false)) >= 0) {
                    InventoryUtils.swapItemToEquipmentSlot((Player)this, EquipmentSlot.CHEST, targetSlot);
                    this.autoSwitchElytraChestplate = ItemStack.EMPTY;
                }
            } else {
                InventoryUtils.swapElytraAndChestPlate((Player)this);
            }
        }
    }
}

