/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.freecam;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=1005)
public abstract class MixinWorldRenderer_freeCam {
    @Shadow
    private int lastCameraSectionX;
    @Shadow
    private int lastCameraSectionZ;
    @Unique
    private int lastUpdatePosX;
    @Unique
    private int lastUpdatePosZ;

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=terrain_setup"})})
    private void preSetupTerrain(GraphicsResourceAllocator allocator, DeltaTracker tickCounter, boolean renderBlockOutline, Camera camera, Matrix4f positionMatrix, Matrix4f projectionMatrix, GpuBufferSlice fog, Vector4f fogColor, boolean shouldRenderSky, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            CameraUtils.setFreeCameraSpectator(true);
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=compile_sections"})})
    private void postSetupTerrain(GraphicsResourceAllocator allocator, DeltaTracker tickCounter, boolean renderBlockOutline, Camera camera, Matrix4f positionMatrix, Matrix4f projectionMatrix, GpuBufferSlice fog, Vector4f fogColor, boolean shouldRenderSky, CallbackInfo ci) {
        CameraUtils.setFreeCameraSpectator(false);
    }

    @Redirect(method={"collectVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Ljava/util/List;)Z"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;getEntity()Lnet/minecraft/world/entity/Entity;", ordinal=3))
    private Entity allowRenderingClientPlayerInFreeCameraMode(Camera camera) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            return Minecraft.getInstance().player;
        }
        return camera.getEntity();
    }

    @Inject(method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, require=0, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/renderer/LevelRenderer;prevCamX:D")})
    private void rebuildChunksAroundCamera1(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            this.lastUpdatePosX = this.lastCameraSectionX;
            this.lastUpdatePosZ = this.lastCameraSectionZ;
        }
    }

    @Inject(method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, require=0, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/renderer/ViewArea;repositionCamera(Lnet/minecraft/core/SectionPos;)V")})
    private void rebuildChunksAroundCamera2(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            int x = Mth.floor((double)camera.getPosition().x) >> 4;
            int z = Mth.floor((double)camera.getPosition().z) >> 4;
            CameraUtils.markChunksForRebuild(x, z, this.lastUpdatePosX, this.lastUpdatePosZ);
        }
    }
}

