/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.tweaks;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.restrictions.UsageRestriction;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.mixin.block.IMixinPistonBlock;
import fi.dy.masa.tweakeroo.world.FakeChunk;
import fi.dy.masa.tweakeroo.world.FakeWorld;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderTweaks {
    private static final ConcurrentHashMap<Long, ListMapEntry> SELECTIVE_BLACKLIST = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, ListMapEntry> SELECTIVE_WHITELIST = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, ListMapEntry> CACHED_LIST = new ConcurrentHashMap();
    public static final int PASSTHROUGH = 1024;
    private static final Color4f colorPos1 = new Color4f(1.0f, 0.0625f, 0.0625f);
    private static final Color4f colorPos2 = new Color4f(0.0625f, 0.0625f, 1.0f);
    private static final Color4f sideColor = Color4f.fromColor((int)0x30FFFFFF);
    private static final Color4f colorOverlapping = new Color4f(1.0f, 0.0625f, 1.0f);
    private static final Color4f colorX = new Color4f(1.0f, 0.25f, 0.25f);
    private static final Color4f colorY = new Color4f(0.25f, 1.0f, 0.25f);
    private static final Color4f colorZ = new Color4f(0.25f, 0.25f, 1.0f);
    private static final Color4f colorLooking = new Color4f(1.0f, 1.0f, 1.0f, 0.6f);
    private static final Color4f colorWhitelist = new Color4f(0.1f, 0.7f, 0.1f, 0.25f);
    private static final Color4f colorBlacklist = new Color4f(0.7f, 0.1f, 0.1f, 0.25f);
    private static Color4f colorSearch = new Color4f(0.9f, 0.0f, 0.7f, 0.25f);
    public static Selection AREA_SELECTION = new Selection();
    public static BlockPos posLookingAt = null;
    public static long LAST_CHECK = 0L;
    private static UsageRestriction.ListType previousType = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
    private static boolean previousSelectiveToggle = FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue();
    private static RegistryAccess.Frozen dynamicRegistryManager;
    private static FakeWorld fakeWorld;

    public static void setDynamicRegistryManager(@Nullable RegistryAccess.Frozen immutable) {
        if (immutable == null) {
            return;
        }
        dynamicRegistryManager = immutable;
    }

    public static RegistryAccess.Frozen getDynamicRegistryManager() {
        return dynamicRegistryManager;
    }

    public static void resetWorld(int loadDistance) {
        fakeWorld = new FakeWorld((RegistryAccess)dynamicRegistryManager, loadDistance);
    }

    public static void reloadRegistryManager(Level world) {
        dynamicRegistryManager = world.registryAccess().freeze();
    }

    public static FakeWorld getFakeWorld() {
        return fakeWorld;
    }

    public static void onTick() {
        Minecraft mc = Minecraft.getInstance();
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
            if (mc.options.keyAttack.isDown()) {
                RenderTweaks.select(false);
            }
            if (mc.options.keyUse.isDown()) {
                RenderTweaks.select(true);
            }
        }
    }

    public static void render(Matrix4f posMatrix, Matrix4f projMatrix, ProfilerFiller profiler) {
        Minecraft mc = Minecraft.getInstance();
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue() || FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE.getBooleanValue()) {
            if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
                RenderTweaks.updateLookingAt();
            }
            profiler.push("tweakeroo_render_tweaks");
            Matrix4fStack globalStack = RenderSystem.getModelViewStack();
            globalStack.pushMatrix();
            if (FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE.getBooleanValue()) {
                RenderTweaks.renderLists(posMatrix, projMatrix, profiler);
            }
            if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
                if (posLookingAt != null) {
                    RenderUtils.renderBlockOutline((BlockPos)posLookingAt, (float)expand, (float)lineWidthBlockBox, (Color4f)colorLooking, (boolean)false);
                }
                RenderTweaks.renderSelection(posMatrix, projMatrix, profiler, AREA_SELECTION);
            }
            globalStack.popMatrix();
            profiler.pop();
        }
    }

    private static void renderLists(Matrix4f posMatrix, Matrix4f projMatrix, ProfilerFiller profiler) {
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        Minecraft mc = Minecraft.getInstance();
        profiler.push("lists");
        for (ListMapEntry entry : SELECTIVE_BLACKLIST.values()) {
            RenderUtils.renderBlockOutline((BlockPos)entry.currentPosition, (float)expand, (float)lineWidthBlockBox, (Color4f)colorBlacklist, (boolean)false);
        }
        for (ListMapEntry entry : SELECTIVE_WHITELIST.values()) {
            RenderUtils.renderBlockOutline((BlockPos)entry.currentPosition, (float)expand, (float)lineWidthBlockBox, (Color4f)colorWhitelist, (boolean)false);
        }
        profiler.pop();
    }

    public static void updateLookingAt() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.hitResult != null && mc.hitResult instanceof BlockHitResult) {
            posLookingAt = ((BlockHitResult)mc.hitResult).getBlockPos();
            if (Hotkeys.AREA_SELECTION_OFFSET.getKeybind().isKeybindHeld()) {
                posLookingAt = posLookingAt.relative(((BlockHitResult)mc.hitResult).getDirection());
            }
        } else {
            posLookingAt = null;
        }
    }

    public static void select(boolean pos2) {
        if (posLookingAt == null) {
            return;
        }
        if (pos2) {
            RenderTweaks.AREA_SELECTION.pos2 = posLookingAt;
        } else {
            RenderTweaks.AREA_SELECTION.pos1 = posLookingAt;
        }
    }

    public static boolean isInSelection(BlockPos pos) {
        int minX = Math.min(RenderTweaks.AREA_SELECTION.pos1.getX(), RenderTweaks.AREA_SELECTION.pos2.getX());
        int minY = Math.min(RenderTweaks.AREA_SELECTION.pos1.getY(), RenderTweaks.AREA_SELECTION.pos2.getY());
        int minZ = Math.min(RenderTweaks.AREA_SELECTION.pos1.getZ(), RenderTweaks.AREA_SELECTION.pos2.getZ());
        int maxX = Math.max(RenderTweaks.AREA_SELECTION.pos1.getX(), RenderTweaks.AREA_SELECTION.pos2.getX());
        int maxY = Math.max(RenderTweaks.AREA_SELECTION.pos1.getY(), RenderTweaks.AREA_SELECTION.pos2.getY());
        int maxZ = Math.max(RenderTweaks.AREA_SELECTION.pos1.getZ(), RenderTweaks.AREA_SELECTION.pos2.getZ());
        return pos.getX() >= minX && pos.getX() <= maxX && pos.getY() >= minY && pos.getY() <= maxY && pos.getZ() >= minZ && pos.getZ() <= maxZ;
    }

    public static void addSelectionToList() {
        ConcurrentHashMap<Long, ListMapEntry> list;
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null) {
            return;
        }
        if (RenderTweaks.AREA_SELECTION.pos1 == null || RenderTweaks.AREA_SELECTION.pos2 == null) {
            InfoUtils.printActionbarMessage((String)"Please set an area first", (Object[])new Object[0]);
            return;
        }
        UsageRestriction.ListType type = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
        if (type == UsageRestriction.ListType.NONE) {
            InfoUtils.printActionbarMessage((String)"No list selected", (Object[])new Object[0]);
            return;
        }
        Iterator iterator = BlockPos.betweenClosed((BlockPos)RenderTweaks.AREA_SELECTION.pos1, (BlockPos)RenderTweaks.AREA_SELECTION.pos2).iterator();
        int count = 0;
        ConcurrentHashMap<Long, ListMapEntry> concurrentHashMap = list = type == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
        while (iterator.hasNext()) {
            BlockPos pos = ((BlockPos)iterator.next()).immutable();
            if (!Configs.Generic.AREA_SELECTION_USE_ALL.getBooleanValue() && mc.level.getBlockState(pos).isAir() || list.containsKey(pos.asLong())) continue;
            list.put(pos.asLong(), new ListMapEntry(pos));
            ++count;
        }
        RenderTweaks.rebuildStrings();
        InfoUtils.printActionbarMessage((String)("Added " + count + " blocks"), (Object[])new Object[0]);
    }

    public static void removeSelectionFromList() {
        ConcurrentHashMap<Long, ListMapEntry> list;
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null) {
            return;
        }
        if (RenderTweaks.AREA_SELECTION.pos1 == null || RenderTweaks.AREA_SELECTION.pos2 == null) {
            InfoUtils.printActionbarMessage((String)"Please set an area first", (Object[])new Object[0]);
            return;
        }
        UsageRestriction.ListType type = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
        if (type == UsageRestriction.ListType.NONE) {
            InfoUtils.printActionbarMessage((String)"No list selected", (Object[])new Object[0]);
            return;
        }
        Iterator iterator = BlockPos.betweenClosed((BlockPos)RenderTweaks.AREA_SELECTION.pos1, (BlockPos)RenderTweaks.AREA_SELECTION.pos2).iterator();
        int count = 0;
        ConcurrentHashMap<Long, ListMapEntry> concurrentHashMap = list = type == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            if (!list.containsKey(pos.asLong())) continue;
            list.remove(pos.asLong());
            ++count;
        }
        RenderTweaks.rebuildStrings();
        InfoUtils.printActionbarMessage((String)("Removed " + count + " blocks"), (Object[])new Object[0]);
    }

    public static void renderSelection(Matrix4f posMatrix, Matrix4f projMatrix, ProfilerFiller profiler, Selection selection) {
        BlockPos pos1 = selection.pos1;
        BlockPos pos2 = selection.pos2;
        if (pos1 == null && pos2 == null) {
            return;
        }
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        float lineWidthArea = 1.5f;
        Minecraft mc = Minecraft.getInstance();
        profiler.push("selection");
        if (pos1 != null && pos2 != null) {
            if (!pos1.equals((Object)pos2)) {
                RenderUtils.renderAreaOutlineNoCorners((BlockPos)pos1, (BlockPos)pos2, (float)lineWidthArea, (Color4f)colorX, (Color4f)colorY, (Color4f)colorZ);
                RenderUtils.renderAreaSides((BlockPos)pos1, (BlockPos)pos2, (Color4f)sideColor, (Matrix4f)posMatrix, (boolean)false);
                RenderUtils.renderBlockOutline((BlockPos)pos1, (float)expand, (float)lineWidthBlockBox, (Color4f)colorPos1, (boolean)false);
                RenderUtils.renderBlockOutline((BlockPos)pos2, (float)expand, (float)lineWidthBlockBox, (Color4f)colorPos2, (boolean)false);
            } else {
                RenderUtils.renderBlockOutlineOverlapping((BlockPos)pos1, (float)expand, (float)lineWidthBlockBox, (Color4f)colorPos1, (Color4f)colorPos2, (Color4f)colorOverlapping, (Matrix4f)posMatrix, (boolean)false);
            }
        } else {
            if (pos1 != null) {
                RenderUtils.renderBlockOutline((BlockPos)pos1, (float)expand, (float)lineWidthBlockBox, (Color4f)colorPos1, (boolean)false);
            }
            if (pos2 != null) {
                RenderUtils.renderBlockOutline((BlockPos)pos2, (float)expand, (float)lineWidthBlockBox, (Color4f)colorPos2, (boolean)false);
            }
        }
        profiler.pop();
    }

    public static void onPistonEvent(BlockState state, Level world, BlockPos pos, int type, int data) {
        if (!Configs.Generic.SELECTIVE_BLOCKS_TRACK_PISTONS.getBooleanValue() || !FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue() && !FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDER_OUTLINE.getBooleanValue() || SELECTIVE_WHITELIST.size() == 0 && SELECTIVE_BLACKLIST.size() == 0) {
            return;
        }
        if (type == 2) {
            return;
        }
        Direction pushDirection = Direction.from3DDataValue((int)(data & 7));
        PistonStructureResolver pistonHandler = new PistonStructureResolver(world, pos, pushDirection, type == 0);
        BlockState state2 = null;
        BlockEntity entity = null;
        BlockEntity entity2 = null;
        if (type != 0 && !((IMixinPistonBlock)state.getBlock()).getSticky()) {
            return;
        }
        if (type != 0) {
            state2 = world.getBlockState(pos.relative(pushDirection));
            entity = world.getBlockEntity(pos);
            entity2 = world.getBlockEntity(pos.relative(pushDirection));
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 16);
            world.setBlock(pos.relative(pushDirection), Blocks.AIR.defaultBlockState(), 16);
        }
        boolean moveSuccess = pistonHandler.resolve();
        if (type != 0) {
            world.setBlock(pos, state, 16);
            world.setBlock(pos.relative(pushDirection), state2, 16);
            if (entity != null) {
                world.setBlockEntity(entity);
            }
            if (entity2 != null) {
                world.setBlockEntity(entity2);
            }
        }
        boolean attatchedWhitelist = SELECTIVE_WHITELIST.containsKey(pos.relative(pushDirection, type == 0 ? 1 : 2).asLong());
        boolean attatchedBlacklist = SELECTIVE_BLACKLIST.containsKey(pos.relative(pushDirection, type == 0 ? 1 : 2).asLong());
        boolean whitelisted = SELECTIVE_WHITELIST.containsKey(pos.asLong());
        boolean blacklisted = SELECTIVE_BLACKLIST.containsKey(pos.asLong());
        if (type == 0) {
            if (whitelisted) {
                if (attatchedWhitelist) {
                    RenderTweaks.SELECTIVE_WHITELIST.get((Object)Long.valueOf((long)pos.relative((Direction)pushDirection).asLong())).preserve = true;
                } else {
                    SELECTIVE_WHITELIST.put(pos.relative(pushDirection, 1).asLong(), new ListMapEntry(pos.relative(pushDirection, 1)));
                }
            }
            if (blacklisted) {
                if (attatchedBlacklist) {
                    RenderTweaks.SELECTIVE_BLACKLIST.get((Object)Long.valueOf((long)pos.relative((Direction)pushDirection).asLong())).preserve = true;
                } else {
                    SELECTIVE_BLACKLIST.put(pos.relative(pushDirection, 1).asLong(), new ListMapEntry(pos.relative(pushDirection, 1)));
                }
            }
        }
        if (moveSuccess) {
            List movedBlocks = pistonHandler.getToPush();
            ArrayList<ListMapEntry> toMoveWhitelist = new ArrayList<ListMapEntry>();
            ArrayList<ListMapEntry> toMoveBlacklist = new ArrayList<ListMapEntry>();
            ArrayList<ListMapEntry> toAddWhitelist = new ArrayList<ListMapEntry>();
            ArrayList<ListMapEntry> toAddBlacklist = new ArrayList<ListMapEntry>();
            for (BlockPos blockPos : movedBlocks) {
                ListMapEntry entry;
                long key = blockPos.asLong();
                if (SELECTIVE_WHITELIST.containsKey(key)) {
                    entry = SELECTIVE_WHITELIST.get(key);
                    toMoveWhitelist.add(entry);
                    SELECTIVE_WHITELIST.remove(key);
                    if (entry.preserve) {
                        entry.preserve = false;
                        toAddWhitelist.add(new ListMapEntry(blockPos));
                    }
                }
                if (!SELECTIVE_BLACKLIST.containsKey(key)) continue;
                entry = SELECTIVE_BLACKLIST.get(key);
                toMoveBlacklist.add(entry);
                SELECTIVE_BLACKLIST.remove(key);
                if (!entry.preserve) continue;
                entry.preserve = false;
                toAddBlacklist.add(new ListMapEntry(blockPos));
            }
            for (ListMapEntry listMapEntry : toMoveWhitelist) {
                listMapEntry.currentPosition = listMapEntry.currentPosition.relative(pushDirection, type == 0 ? 1 : -1);
                if (SELECTIVE_WHITELIST.containsKey(listMapEntry.currentPosition.asLong())) {
                    listMapEntry.preserve = true;
                }
                SELECTIVE_WHITELIST.put(listMapEntry.currentPosition.asLong(), listMapEntry);
            }
            for (ListMapEntry listMapEntry : toMoveBlacklist) {
                listMapEntry.currentPosition = listMapEntry.currentPosition.relative(pushDirection, type == 0 ? 1 : -1);
                if (SELECTIVE_BLACKLIST.containsKey(listMapEntry.currentPosition.asLong())) {
                    listMapEntry.preserve = true;
                }
                SELECTIVE_BLACKLIST.put(listMapEntry.currentPosition.asLong(), listMapEntry);
            }
            for (ListMapEntry listMapEntry : toAddWhitelist) {
                SELECTIVE_WHITELIST.put(listMapEntry.currentPosition.asLong(), listMapEntry);
            }
            for (ListMapEntry listMapEntry : toAddBlacklist) {
                SELECTIVE_BLACKLIST.put(listMapEntry.currentPosition.asLong(), listMapEntry);
            }
        }
        RenderTweaks.reloadSelective();
    }

    public static boolean isPositionValidForRendering(BlockPos pos) {
        return RenderTweaks.isPositionValidForRendering(pos.asLong());
    }

    public static boolean isPositionValidForRendering(long key) {
        if (!FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue()) {
            return true;
        }
        switch ((UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue()) {
            case NONE: {
                return true;
            }
            case WHITELIST: {
                return SELECTIVE_WHITELIST.containsKey(key);
            }
            case BLACKLIST: {
                return !SELECTIVE_BLACKLIST.containsKey(key);
            }
        }
        return false;
    }

    public static void rebuildLists() {
        SELECTIVE_BLACKLIST.clear();
        SELECTIVE_WHITELIST.clear();
        RenderTweaks.putMapFromString(SELECTIVE_BLACKLIST, Configs.Lists.SELECTIVE_BLOCKS_BLACKLIST.getStringValue());
        RenderTweaks.putMapFromString(SELECTIVE_WHITELIST, Configs.Lists.SELECTIVE_BLOCKS_WHITELIST.getStringValue());
        RenderTweaks.reloadSelective();
    }

    public static void updateSelectiveAtPos(BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        BlockState state = mc.level.getBlockState(pos);
        if (RenderTweaks.isPositionValidForRendering(pos)) {
            BlockState originalState;
            if (state.isAir() && !(originalState = fakeWorld.getBlockState(pos)).isAir()) {
                BlockEntity be = fakeWorld.getBlockEntity(pos);
                fakeWorld.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                mc.level.setBlock(pos, originalState, 1043);
                if (be != null) {
                    mc.level.setBlockEntity(be);
                }
            }
        } else if (!state.isAir()) {
            BlockEntity be = mc.level.getBlockEntity(pos);
            mc.level.setBlock(pos, Blocks.AIR.defaultBlockState(), 1043);
            RenderTweaks.setFakeBlockState((Level)mc.level, pos, state, be);
        }
    }

    public static void reloadSelective() {
        Minecraft.getInstance().execute(RenderTweaks::reloadSelectiveInternal);
    }

    public static void reloadSelectiveInternal() {
        Minecraft mc = Minecraft.getInstance();
        UsageRestriction.ListType listtype = (UsageRestriction.ListType)Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.getOptionListValue();
        boolean toggle = FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue();
        if (mc.level == null) {
            CACHED_LIST.clear();
            if (listtype != UsageRestriction.ListType.NONE) {
                ConcurrentHashMap<Long, ListMapEntry> list = listtype == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
                for (ListMapEntry entry : list.values()) {
                    CACHED_LIST.put(entry.currentPosition.asLong(), entry);
                }
            }
            previousSelectiveToggle = toggle;
            previousType = listtype;
            return;
        }
        if (listtype != previousType || toggle != previousSelectiveToggle) {
            ChunkPos center = fakeWorld.getChunkManager().getChunkMapCenter();
            int radius = fakeWorld.getChunkManager().getRadius();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int cx = center.x - radius; cx <= center.x + radius; ++cx) {
                for (int cz = center.z - radius; cz <= center.z + radius; ++cz) {
                    LevelChunk chunk = mc.level.getChunkSource().getChunk(cx, cz, ChunkStatus.FULL, false);
                    FakeChunk fakeChunk = fakeWorld.getChunkManager().getChunkIfExists(cx, cz);
                    if (chunk == null || fakeChunk == null) continue;
                    ChunkPos cpos = chunk.getPos();
                    LevelChunkSection[] sections = chunk.getSections();
                    LevelChunkSection[] fakeSections = fakeChunk.getSections();
                    for (int i = 0; i < sections.length; ++i) {
                        LevelChunkSection section = sections[i];
                        if (section.hasOnlyAir() && fakeSections[i].hasOnlyAir()) continue;
                        for (int x = 0; x < 16; ++x) {
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    pos.set(x + cpos.getMinBlockX(), y + fakeWorld.getSectionYFromSectionIndex(i), z + cpos.getMinBlockZ());
                                    RenderTweaks.updateSelectiveAtPos((BlockPos)pos);
                                }
                            }
                        }
                    }
                }
            }
            CACHED_LIST.clear();
            if (listtype != UsageRestriction.ListType.NONE) {
                ConcurrentHashMap<Long, ListMapEntry> list = listtype == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
                for (ListMapEntry entry : list.values()) {
                    CACHED_LIST.put(entry.currentPosition.asLong(), entry);
                }
            }
        } else if (listtype != UsageRestriction.ListType.NONE) {
            ConcurrentHashMap<Long, ListMapEntry> list = listtype == UsageRestriction.ListType.WHITELIST ? SELECTIVE_WHITELIST : SELECTIVE_BLACKLIST;
            Iterator<ListMapEntry> iterator = CACHED_LIST.values().iterator();
            while (iterator.hasNext()) {
                ListMapEntry entry = iterator.next();
                if (list.containsKey(entry.currentPosition.asLong())) continue;
                RenderTweaks.updateSelectiveAtPos(entry.currentPosition);
                iterator.remove();
            }
            for (ListMapEntry entry : list.values()) {
                if (CACHED_LIST.containsKey(entry.currentPosition.asLong())) continue;
                RenderTweaks.updateSelectiveAtPos(entry.currentPosition);
                CACHED_LIST.put(entry.currentPosition.asLong(), entry);
            }
        }
        previousSelectiveToggle = toggle;
        previousType = listtype;
    }

    public static void onLightUpdateEvent(int chunkX, int chunkZ, CallbackInfo ci) {
    }

    public static void rebuildStrings() {
        String whitelist = RenderTweaks.getStringFromMap(SELECTIVE_WHITELIST);
        String blacklist = RenderTweaks.getStringFromMap(SELECTIVE_BLACKLIST);
        Configs.Lists.SELECTIVE_BLOCKS_WHITELIST.setValueFromString(whitelist);
        Configs.Lists.SELECTIVE_BLOCKS_BLACKLIST.setValueFromString(blacklist);
    }

    public static void putMapFromString(ConcurrentHashMap<Long, ListMapEntry> map, String str) {
        String[] parts;
        for (String part : parts = str.split("\\|")) {
            String[] nums = part.split(",");
            if (nums.length < 3) continue;
            try {
                int x = Integer.parseInt(nums[0]);
                int y = Integer.parseInt(nums[1]);
                int z = Integer.parseInt(nums[2]);
                BlockPos pos = new BlockPos(x, y, z);
                map.put(pos.asLong(), new ListMapEntry(pos, true));
            }
            catch (NumberFormatException e) {
                Tweakeroo.LOGGER.warn("Error while parsing int: {}", (Object)e.toString());
            }
        }
    }

    public static String getStringFromMap(ConcurrentHashMap<Long, ListMapEntry> map) {
        Iterator<ListMapEntry> iterator = map.values().iterator();
        ArrayList<CallSite> entries = new ArrayList<CallSite>();
        while (iterator.hasNext()) {
            ListMapEntry entry = iterator.next();
            entries.add((CallSite)((Object)(entry.originalPosition.getX() + "," + entry.originalPosition.getY() + "," + entry.originalPosition.getZ())));
        }
        return String.join((CharSequence)"|", entries);
    }

    public static Color4f getColorSearch() {
        return colorSearch;
    }

    public static void setColorSearch(Color4f colorSearch) {
        RenderTweaks.colorSearch = colorSearch;
    }

    public static boolean onOpenScreen(Component name, MenuType<?> screenHandlerType, int syncId) {
        LAST_CHECK = System.currentTimeMillis();
        return true;
    }

    public static void loadFakeChunk(int x, int z) {
        fakeWorld.getChunkManager().loadChunk(x, z);
    }

    public static void setFakeBlockState(Level realWorld, BlockPos pos, BlockState state, BlockEntity be) {
        fakeWorld.setBlock(pos, state, 0);
        if (be != null) {
            fakeWorld.setBlockEntity(be);
            be.setLevel(realWorld);
        }
    }

    public static void unloadFakeChunk(int x, int z) {
        fakeWorld.getChunkManager().unloadChunk(x, z);
    }

    static {
        fakeWorld = null;
    }

    public static class Selection {
        public BlockPos pos1 = null;
        public BlockPos pos2 = null;
    }

    public static class ListMapEntry {
        public final BlockPos originalPosition;
        public BlockPos currentPosition;
        public boolean preserve = false;

        ListMapEntry(BlockPos pos) {
            this.originalPosition = pos;
            this.currentPosition = pos;
        }

        ListMapEntry(BlockPos pos, boolean preserve) {
            this(pos);
            this.preserve = preserve;
        }
    }
}

