/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class CameraUtils {
    private static float cameraYaw;
    private static float cameraPitch;
    private static boolean freeCameraSpectator;

    public static void setFreeCameraSpectator(boolean isSpectator) {
        freeCameraSpectator = isSpectator;
    }

    public static boolean getFreeCameraSpectator() {
        return freeCameraSpectator;
    }

    public static boolean shouldPreventPlayerInputs() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_INPUTS.getBooleanValue();
    }

    public static boolean shouldPreventPlayerMovement() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue();
    }

    public static float getCameraYaw() {
        return Mth.wrapDegrees((float)cameraYaw);
    }

    public static float getCameraPitch() {
        return Mth.wrapDegrees((float)cameraPitch);
    }

    public static void setCameraYaw(float yaw) {
        cameraYaw = yaw;
    }

    public static void setCameraPitch(float pitch) {
        cameraPitch = pitch;
    }

    public static void setCameraRotations(float yaw, float pitch) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.setCameraRotations(yaw, pitch);
        }
    }

    public static void updateCameraRotations(float yawChange, float pitchChange) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.updateCameraRotations(yawChange, pitchChange);
        }
    }

    public static void markChunksForRebuild(int chunkX, int chunkZ, int lastChunkX, int lastChunkZ) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || chunkX == lastChunkX && chunkZ == lastChunkZ) {
            return;
        }
        int viewDistance = (Integer)mc.options.renderDistance().get();
        if (chunkX != lastChunkX) {
            int minCX = chunkX > lastChunkX ? lastChunkX + viewDistance : chunkX - viewDistance;
            int maxCX = chunkX > lastChunkX ? chunkX + viewDistance : lastChunkX - viewDistance;
            for (int cx = minCX; cx <= maxCX; ++cx) {
                for (int cz = chunkZ - viewDistance; cz <= chunkZ + viewDistance; ++cz) {
                    if (!CameraUtils.isClientChunkLoaded(mc.level, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.levelRenderer, cx, cz);
                }
            }
        }
        if (chunkZ != lastChunkZ) {
            int minCZ = chunkZ > lastChunkZ ? lastChunkZ + viewDistance : chunkZ - viewDistance;
            int maxCZ = chunkZ > lastChunkZ ? chunkZ + viewDistance : lastChunkZ - viewDistance;
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = chunkX - viewDistance; cx <= chunkX + viewDistance; ++cx) {
                    if (!CameraUtils.isClientChunkLoaded(mc.level, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.levelRenderer, cx, cz);
                }
            }
        }
    }

    public static void markChunksForRebuildOnDeactivation(int lastChunkX, int lastChunkZ) {
        Minecraft mc = Minecraft.getInstance();
        int viewDistance = (Integer)mc.options.renderDistance().get();
        Entity entity = EntityUtils.getCameraEntity();
        if (mc.level == null || entity == null) {
            return;
        }
        int chunkX = Mth.floor((double)(entity.getX() / 16.0)) >> 4;
        int chunkZ = Mth.floor((double)(entity.getZ() / 16.0)) >> 4;
        int minCameraCX = lastChunkX - viewDistance;
        int maxCameraCX = lastChunkX + viewDistance;
        int minCameraCZ = lastChunkZ - viewDistance;
        int maxCameraCZ = lastChunkZ + viewDistance;
        int minCX = chunkX - viewDistance;
        int maxCX = chunkX + viewDistance;
        int minCZ = chunkZ - viewDistance;
        int maxCZ = chunkZ + viewDistance;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                if (cx >= minCameraCX && cx <= maxCameraCX && cz >= minCameraCZ && cz <= maxCameraCZ || !CameraUtils.isClientChunkLoaded(mc.level, cx, cz)) continue;
                CameraUtils.markChunkForReRender(mc.levelRenderer, cx, cz);
            }
        }
    }

    public static void markChunkForReRender(LevelRenderer renderer, int chunkX, int chunkZ) {
        for (int cy = 0; cy < 16; ++cy) {
            renderer.setSectionDirty(chunkX, cy, chunkZ);
        }
    }

    public static boolean isClientChunkLoaded(ClientLevel world, int chunkX, int chunkZ) {
        return world.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) != null;
    }
}

