/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@Deprecated(forRemoval=true)
public class RayTraceUtils {
    @Nonnull
    public static HitResult getRayTraceFromEntity(Level worldIn, Entity entityIn, boolean useLiquids) {
        double d;
        if (entityIn instanceof Player) {
            Player pe = (Player)entityIn;
            d = pe.blockInteractionRange() + 1.0;
        } else {
            d = 5.0;
        }
        double reach = d;
        return RayTraceUtils.getRayTraceFromEntity(worldIn, entityIn, useLiquids, reach);
    }

    @Nonnull
    public static HitResult getRayTraceFromEntity(Level worldIn, Entity entityIn, boolean useLiquids, double range) {
        ClipContext.Fluid fluidMode;
        Vec3 rangedLookRot;
        Vec3 lookVec;
        Vec3 eyesVec = new Vec3(entityIn.getX(), entityIn.getY() + (double)entityIn.getEyeHeight(), entityIn.getZ());
        ClipContext context = new ClipContext(eyesVec, lookVec = eyesVec.add(rangedLookRot = entityIn.getViewVector(1.0f).scale(range)), ClipContext.Block.COLLIDER, fluidMode = useLiquids ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE, entityIn);
        BlockHitResult result = worldIn.clip(context);
        if (result == null) {
            result = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.UP, (BlockPos)BlockPos.ZERO);
        }
        AABB bb = entityIn.getBoundingBox().inflate(rangedLookRot.x, rangedLookRot.y, rangedLookRot.z).inflate(1.0, 1.0, 1.0);
        List list = worldIn.getEntities(entityIn, bb);
        double closest = result.getType() == HitResult.Type.BLOCK ? eyesVec.distanceTo(result.getLocation()) : Double.MAX_VALUE;
        Optional entityTrace = Optional.empty();
        Entity targetEntity = null;
        for (Entity entity : list) {
            double distance;
            bb = entity.getBoundingBox();
            Optional traceTmp = bb.clip(lookVec, eyesVec);
            if (!traceTmp.isPresent() || !((distance = eyesVec.distanceTo((Vec3)traceTmp.get())) <= closest)) continue;
            targetEntity = entity;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new EntityHitResult(targetEntity, (Vec3)entityTrace.get());
        }
        return result;
    }
}

