/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.event;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeyCallbackAdjustable;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.Input;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private static final InputHandler INSTANCE = new InputHandler();
    private LeftRight lastSidewaysInput = LeftRight.NONE;
    private ForwardBack lastForwardInput = ForwardBack.NONE;

    private InputHandler() {
    }

    public static InputHandler getInstance() {
        return INSTANCE;
    }

    public void addKeysToMap(IKeybindManager manager) {
        for (FeatureToggle toggle : FeatureToggle.values()) {
            manager.addKeybindToMap(toggle.getKeybind());
        }
        for (IHotkey iHotkey : Hotkeys.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
        for (IHotkey iHotkey : Configs.Generic.HOTKEYS) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
        for (IHotkey iHotkey : Configs.Disable.OPTIONS) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.disable_toggle_hotkeys", Configs.Disable.OPTIONS);
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.generic_hotkeys", Hotkeys.HOTKEY_LIST);
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.generic_config_hotkeys", Configs.Generic.HOTKEYS);
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.tweak_toggle_hotkeys", (List)ImmutableList.copyOf((Object[])FeatureToggle.values()));
    }

    public boolean onKeyInput(int keyCode, int scanCode, int modifiers, boolean eventKeyState) {
        Minecraft mc = Minecraft.getInstance();
        if (GuiUtils.getCurrentScreen() == null && eventKeyState) {
            this.storeLastMovementDirection(keyCode, scanCode, mc);
        }
        MiscUtils.checkZoomStatus();
        return false;
    }

    public boolean onMouseClick(int mouseX, int mouseY, int eventButton, boolean eventButtonState) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null || mc.gameMode == null || mc.hitResult == null || GuiUtils.getCurrentScreen() != null) {
            return false;
        }
        if (mc.player.isCreative() && FeatureToggle.TWEAK_ANGEL_BLOCK.getBooleanValue() && eventButtonState && mc.options.keyUse.matchesMouse(eventButton) && mc.hitResult.getType() == HitResult.Type.MISS) {
            Vec3 eyePos = mc.player.getEyePosition();
            Vec3 rotVec = mc.player.getViewVector(1.0f);
            Vec3 vec3d = eyePos.add(rotVec.scale(Configs.Generic.ANGEL_BLOCK_PLACEMENT_DISTANCE.getDoubleValue()));
            BlockHitResult context = mc.level.clip(new ClipContext(eyePos, vec3d, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)mc.player));
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = mc.player.getItemInHand(hand);
                if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) continue;
                mc.gameMode.useItemOn(mc.player, hand, context);
                mc.player.swing(hand);
                return true;
            }
        }
        return false;
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double dWheel) {
        if (GuiUtils.getCurrentScreen() == null && dWheel != 0.0) {
            String preGreen = GuiBase.TXT_GREEN;
            String rst = GuiBase.TXT_RST;
            if (FeatureToggle.TWEAK_HOTBAR_SCROLL.getBooleanValue() && Hotkeys.HOTBAR_SCROLL.getKeybind().isKeybindHeld()) {
                int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
                int newRow = currentRow + (dWheel < 0.0 ? 1 : -1);
                int max = 2;
                if (newRow < 0) {
                    newRow = max;
                } else if (newRow > max) {
                    newRow = 0;
                }
                Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.setIntegerValue(newRow);
                return true;
            }
            if (FeatureToggle.TWEAK_FLY_SPEED.getKeybind().isKeybindHeld()) {
                ConfigDouble config = Configs.getActiveFlySpeedConfig();
                double newValue = config.getDoubleValue() + (dWheel > 0.0 ? 0.005 : -0.005);
                config.setDoubleValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strIndex = preGreen + (Configs.Internal.FLY_SPEED_PRESET.getIntegerValue() + 1) + rst;
                String strValue = preGreen + String.format("%.3f", config.getDoubleValue()) + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_fly_speed_to", (Object[])new Object[]{strIndex, strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_AFTER_CLICKER.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.AFTER_CLICKER_CLICK_COUNT.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_after_clicker_count_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_PLACEMENT_LIMIT.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.PLACEMENT_LIMIT.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.PLACEMENT_LIMIT.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.PLACEMENT_LIMIT.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_placement_limit_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_hotbar_slot_cycle_max_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_hotbar_slot_randomizer_max_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_BREAKING_GRID.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.BREAKING_GRID_SIZE.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.BREAKING_GRID_SIZE.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.BREAKING_GRID_SIZE.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_breaking_grid_size_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_PLACEMENT_GRID.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.PLACEMENT_GRID_SIZE.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.PLACEMENT_GRID_SIZE.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.PLACEMENT_GRID_SIZE.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_placement_grid_size_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_SNAP_AIM.getKeybind().isKeybindHeld()) {
                SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
                ConfigDouble config = mode == SnapAimMode.PITCH ? Configs.Generic.SNAP_AIM_PITCH_STEP : Configs.Generic.SNAP_AIM_YAW_STEP;
                double newValue = config.getDoubleValue() * (dWheel > 0.0 ? 2.0 : 0.5);
                config.setDoubleValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String val = preGreen + String.valueOf(config.getDoubleValue()) + rst;
                String key = mode == SnapAimMode.PITCH ? "tweakeroo.message.set_snap_aim_pitch_step_to" : "tweakeroo.message.set_snap_aim_yaw_step_to";
                InfoUtils.printActionbarMessage((String)key, (Object[])new Object[]{val});
                return true;
            }
            if (FeatureToggle.TWEAK_ZOOM.getKeybind().isKeybindHeld() || FeatureToggle.TWEAK_ZOOM.getBooleanValue() && Hotkeys.ZOOM_ACTIVATE.getKeybind().isKeybindHeld()) {
                double diff = GuiBase.isCtrlDown() ? 5.0 : 1.0;
                double newValue = Configs.Generic.ZOOM_FOV.getDoubleValue() + (dWheel < 0.0 ? diff : -diff);
                Configs.Generic.ZOOM_FOV.setDoubleValue(newValue);
                if (FeatureToggle.TWEAK_ZOOM.getKeybind().isKeybindHeld()) {
                    KeyCallbackAdjustable.setValueChanged();
                }
                String strValue = String.format("%s%.1f%s", preGreen, Configs.Generic.ZOOM_FOV.getDoubleValue(), rst);
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_zoom_fov_to", (Object[])new Object[]{strValue});
                return true;
            }
        }
        return false;
    }

    public LeftRight getLastSidewaysInput() {
        return this.lastSidewaysInput;
    }

    public ForwardBack getLastForwardInput() {
        return this.lastForwardInput;
    }

    private void storeLastMovementDirection(int eventKey, int scanCode, Minecraft mc) {
        if (mc.options.keyUp.matches(eventKey, scanCode)) {
            this.lastForwardInput = ForwardBack.FORWARD;
        } else if (mc.options.keyDown.matches(eventKey, scanCode)) {
            this.lastForwardInput = ForwardBack.BACK;
        } else if (mc.options.keyLeft.matches(eventKey, scanCode)) {
            this.lastSidewaysInput = LeftRight.LEFT;
        } else if (mc.options.keyRight.matches(eventKey, scanCode)) {
            this.lastSidewaysInput = LeftRight.RIGHT;
        }
    }

    public void handleMovementKeys(Input movement) {
        Options settings = Minecraft.getInstance().options;
        if (settings.keyLeft.isDown() && settings.keyRight.isDown()) {
            if (this.lastSidewaysInput == LeftRight.LEFT) {
                movement.leftImpulse = 1.0f;
                movement.left = true;
                movement.right = false;
            } else if (this.lastSidewaysInput == LeftRight.RIGHT) {
                movement.leftImpulse = -1.0f;
                movement.left = false;
                movement.right = true;
            }
        }
        if (settings.keyDown.isDown() && settings.keyUp.isDown()) {
            if (this.lastForwardInput == ForwardBack.FORWARD) {
                movement.forwardImpulse = 1.0f;
                movement.up = true;
                movement.down = false;
            } else if (this.lastForwardInput == ForwardBack.BACK) {
                movement.forwardImpulse = -1.0f;
                movement.up = false;
                movement.down = true;
            }
        }
    }

    public static enum LeftRight {
        NONE,
        LEFT,
        RIGHT;

    }

    public static enum ForwardBack {
        NONE,
        FORWARD,
        BACK;

    }
}

