/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.entity;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import fi.dy.masa.tweakeroo.util.SnapAimUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Shadow
    private float yRot;
    @Shadow
    private float xRot;
    @Shadow
    public float yRotO;
    @Shadow
    public float xRotO;
    @Unique
    private double lastFreePitch;
    @Unique
    private double lastFreeYaw;
    @Unique
    private double cameraPitch;
    @Unique
    private double cameraYaw;

    @Shadow
    public abstract Vec3 getDeltaMovement();

    @Shadow
    public abstract void setDeltaMovement(Vec3 var1);

    @Inject(method={"isInvisibleTo(Lnet/minecraft/world/entity/player/Player;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideIsInvisibleToPlayer(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_RENDER_INVISIBLE_ENTITIES.getBooleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"moveRelative(FLnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void moreAccurateMoveRelative(float speedIn, Vec3 motion, CallbackInfo ci) {
        if (this instanceof LocalPlayer && (FeatureToggle.TWEAK_SNAP_AIM.getBooleanValue() || FeatureToggle.TWEAK_AIM_LOCK.getBooleanValue())) {
            SnapAimUtils.onUpdateVelocity((Entity)this, this.yRot, speedIn, motion, ci);
        }
    }

    @Inject(method={"turn(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideYaw(double yawChange, double pitchChange, CallbackInfo ci) {
        if (this instanceof LocalPlayer) {
            if (CameraUtils.shouldPreventPlayerMovement()) {
                CameraUtils.updateCameraRotations((float)yawChange, (float)pitchChange);
            }
            if (FeatureToggle.TWEAK_ELYTRA_CAMERA.getBooleanValue() && Hotkeys.ELYTRA_CAMERA.getKeybind().isKeybindHeld()) {
                int pitchLimit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
                this.cameraYaw += yawChange * 0.15;
                this.cameraPitch = Mth.clamp((double)(this.cameraPitch + pitchChange * 0.15), (double)(-pitchLimit), (double)pitchLimit);
                CameraUtils.setCameraYaw((float)this.cameraYaw);
                CameraUtils.setCameraPitch((float)this.cameraPitch);
                this.yRot = this.yRotO;
                this.xRot = this.xRotO;
                ci.cancel();
                return;
            }
            if (FeatureToggle.TWEAK_AIM_LOCK.getBooleanValue()) {
                if (FeatureToggle.TWEAK_SNAP_AIM.getBooleanValue()) {
                    this.yRot = SnapAimUtils.getSnappedYaw(this.lastFreeYaw);
                    this.xRot = SnapAimUtils.getSnappedPitch(this.lastFreePitch);
                } else {
                    this.yRot = (float)this.lastFreeYaw;
                    this.xRot = (float)this.lastFreePitch;
                }
                this.yRotO = this.yRot;
                this.xRotO = this.xRot;
                ci.cancel();
                return;
            }
            if (FeatureToggle.TWEAK_SNAP_AIM.getBooleanValue()) {
                int pitchLimit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
                SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
                boolean snapAimLock = FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue();
                boolean updateYaw = !snapAimLock || mode == SnapAimMode.PITCH;
                boolean updatePitch = !snapAimLock || mode == SnapAimMode.YAW;
                this.updateCustomPlayerRotations(yawChange, pitchChange, updateYaw, updatePitch, pitchLimit);
                this.yRot = SnapAimUtils.getSnappedYaw(this.lastFreeYaw);
                this.xRot = SnapAimUtils.getSnappedPitch(this.lastFreePitch);
                this.yRotO = this.yRot;
                this.xRotO = this.xRot;
                ci.cancel();
                return;
            }
            if (CameraUtils.shouldPreventPlayerMovement()) {
                ci.cancel();
                return;
            }
            this.lastFreeYaw = this.yRot;
            this.lastFreePitch = this.xRot;
            this.cameraYaw = this.yRot;
            this.cameraPitch = this.xRot;
        }
    }

    @Unique
    private void updateCustomPlayerRotations(double yawChange, double pitchChange, boolean updateYaw, boolean updatePitch, float pitchLimit) {
        if (updateYaw) {
            this.lastFreeYaw += yawChange * 0.15;
        }
        if (updatePitch) {
            this.lastFreePitch = Mth.clamp((double)(this.lastFreePitch + pitchChange * 0.15), (double)(-pitchLimit), (double)pitchLimit);
        }
    }
}

