/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.input;

import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientSuggestionProvider.class})
public abstract class MixinClientCommandSource {
    @Inject(method={"getRelevantCoordinates()Ljava/util/Collection;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockPositionSuggestions(CallbackInfoReturnable<Collection<SharedSuggestionProvider.TextCoordinates>> cir) {
        Minecraft mc = Minecraft.getInstance();
        if (FeatureToggle.TWEAK_TAB_COMPLETE_COORDINATE.getBooleanValue() && mc.player != null && (mc.hitResult == null || mc.hitResult.getType() == HitResult.Type.MISS)) {
            BlockPos pos = PositionUtils.getEntityBlockPos((Entity)mc.player);
            cir.setReturnValue(Collections.singleton(new SharedSuggestionProvider.TextCoordinates(MixinClientCommandSource.formatInt(pos.getX()), MixinClientCommandSource.formatInt(pos.getY()), MixinClientCommandSource.formatInt(pos.getZ()))));
        }
    }

    @Inject(method={"getAbsoluteCoordinates()Ljava/util/Collection;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetPositionSuggestions(CallbackInfoReturnable<Collection<SharedSuggestionProvider.TextCoordinates>> cir) {
        Minecraft mc = Minecraft.getInstance();
        if (FeatureToggle.TWEAK_TAB_COMPLETE_COORDINATE.getBooleanValue() && mc.player != null && (mc.hitResult == null || mc.hitResult.getType() == HitResult.Type.MISS)) {
            cir.setReturnValue(Collections.singleton(new SharedSuggestionProvider.TextCoordinates(MixinClientCommandSource.formatDouble(mc.player.getX()), MixinClientCommandSource.formatDouble(mc.player.getY()), MixinClientCommandSource.formatDouble(mc.player.getZ()))));
        }
    }

    private static String formatDouble(double val) {
        return String.format(Locale.ROOT, "%.2f", val);
    }

    private static String formatInt(int val) {
        return Integer.toString(val);
    }
}

