/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.network;

import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.DataManager;
import fi.dy.masa.tweakeroo.data.ServerDataSyncer;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPlayNetworkHandler
extends ClientCommonPacketListenerImpl {
    @Shadow
    private ClientLevel level;
    @Shadow
    private int serverSimulationDistance;

    protected MixinClientPlayNetworkHandler(Minecraft client, Connection connection, CommonListenerCookie connectionState) {
        super(client, connection, connectionState);
    }

    @Inject(method={"handleOpenScreen(Lnet/minecraft/network/protocol/game/ClientboundOpenScreenPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_onOpenScreenListener(ClientboundOpenScreenPacket packet, CallbackInfo ci) {
        if (!RenderTweaks.onOpenScreen(packet.getTitle(), packet.getType(), packet.getContainerId())) {
            ci.cancel();
        }
    }

    @Inject(method={"handleContainerSetSlot(Lnet/minecraft/network/protocol/game/ClientboundContainerSetSlotPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;setItem(IILnet/minecraft/world/item/ItemStack;)V")}, cancellable=true)
    private void tweakeroo_onHandleSetSlot(ClientboundContainerSetSlotPacket packet, CallbackInfo ci) {
        if (PlacementTweaks.shouldSkipSlotSync(packet.getSlot(), packet.getItem())) {
            ci.cancel();
        }
    }

    @Inject(method={"handlePlayerCombatKill(Lnet/minecraft/network/protocol/game/ClientboundPlayerCombatKillPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V")})
    private void tweakeroo_onPlayerDeath(ClientboundPlayerCombatKillPacket packetIn, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (FeatureToggle.TWEAK_PRINT_DEATH_COORDINATES.getBooleanValue() && mc.player != null) {
            MiscUtils.printDeathCoordinates(mc);
        }
    }

    @Inject(method={"handleCustomPayload(Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V"}, at={@At(value="HEAD")})
    private void tweakeroo_onCustomPayload(CustomPacketPayload payload, CallbackInfo ci) {
        if (payload.type().id().equals((Object)DataManager.CARPET_HELLO)) {
            DataManager.getInstance().setHasCarpetServer(true);
        } else if (payload.type().id().equals((Object)DataManager.SERVUX_ENTITY_DATA)) {
            DataManager.getInstance().setHasServuxServer(true);
        }
    }

    @Inject(method={"handleCommands(Lnet/minecraft/network/protocol/game/ClientboundCommandsPacket;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_onCommandTree(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) {
            ServerDataSyncer.getInstance().resetOpCheck();
        }
    }

    @Inject(method={"handleEntityEvent(Lnet/minecraft/network/protocol/game/ClientboundEntityEventPacket;)V"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/client/multiplayer/ClientPacketListener;findTotem(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;")})
    private void tweakeroo_onPlayerUseTotemOfUndying(ClientboundEntityEventPacket packet, CallbackInfo ci) {
        if (this.minecraft.player == null) {
            return;
        }
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue()) {
            for (InteractionHand hand : InteractionHand.values()) {
                if (!this.minecraft.player.getItemInHand(hand).is(Items.TOTEM_OF_UNDYING)) continue;
                PlacementTweaks.cacheStackInHand(hand);
                this.minecraft.player.setItemInHand(hand, ItemStack.EMPTY);
                PlacementTweaks.onProcessRightClickPost((Player)this.minecraft.player, hand);
            }
        }
    }

    @Inject(method={"handleRespawn(Lnet/minecraft/network/protocol/game/ClientboundRespawnPacket;)V"}, at={@At(value="NEW", target="Lnet/minecraft/client/multiplayer/ClientLevel;")})
    private void tweakeroo_onPlayerRespawnInject(ClientboundRespawnPacket packet, CallbackInfo ci) {
        RenderTweaks.resetWorld(this.serverSimulationDistance);
    }

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="NEW", target="Lnet/minecraft/client/multiplayer/ClientLevel;")})
    private void tweakeroo_onGameJoinInject(ClientboundLoginPacket packet, CallbackInfo ci) {
        RenderTweaks.resetWorld(this.serverSimulationDistance);
    }

    @Inject(method={"handleLevelChunkWithLight(Lnet/minecraft/network/protocol/game/ClientboundLevelChunkWithLightPacket;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_onChunkDataInject(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        int cx = packet.getX();
        int cz = packet.getZ();
        RenderTweaks.loadFakeChunk(cx, cz);
        if (!FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.getBooleanValue()) {
            return;
        }
        LevelChunk worldChunk = this.level.getChunkSource().getChunkNow(cx, cz);
        if (worldChunk != null) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            LevelChunkSection[] sections = worldChunk.getSections();
            for (int i = 0; i < sections.length; ++i) {
                LevelChunkSection section = sections[i];
                if (section == null || section.hasOnlyAir()) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            pos.set(x + worldChunk.getPos().getMinBlockX(), y + this.level.getSectionYFromSectionIndex(i), z + worldChunk.getPos().getMinBlockZ());
                            if (RenderTweaks.isPositionValidForRendering((BlockPos)pos)) continue;
                            BlockEntity be = worldChunk.getBlockEntity((BlockPos)pos);
                            BlockState state = section.getBlockState(x, y, z);
                            worldChunk.setBlockState((BlockPos)pos, Blocks.AIR.defaultBlockState(), false);
                            RenderTweaks.setFakeBlockState((Level)this.level, (BlockPos)pos, state, be);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"handleForgetLevelChunk(Lnet/minecraft/network/protocol/game/ClientboundForgetLevelChunkPacket;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_onUnloadChunkInject(ClientboundForgetLevelChunkPacket packet, CallbackInfo ci) {
        int i = packet.pos().x;
        int j = packet.pos().z;
        RenderTweaks.unloadFakeChunk(i, j);
    }

    @Inject(method={"handleSetChunkCacheRadius(Lnet/minecraft/network/protocol/game/ClientboundSetChunkCacheRadiusPacket;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_onChunkLoadDistanceInject(ClientboundSetChunkCacheRadiusPacket packet, CallbackInfo ci) {
        RenderTweaks.getFakeWorld().getChunkManager().updateLoadDistance(packet.getRadius());
    }

    @Inject(method={"handleSetChunkCacheCenter(Lnet/minecraft/network/protocol/game/ClientboundSetChunkCacheCenterPacket;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_onChunkRenderDistanceCenterInject(ClientboundSetChunkCacheCenterPacket packet, CallbackInfo ci) {
        RenderTweaks.getFakeWorld().getChunkManager().setChunkMapCenter(packet.getX(), packet.getZ());
    }
}

