/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.screen;

import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractCommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandBlockEditScreen.class})
public abstract class MixinCommandBlockScreen
extends AbstractCommandBlockEditScreen {
    @Shadow
    @Final
    private CommandBlockEntity autoCommandBlock;
    @Shadow
    private CycleButton<CommandBlockEntity.Mode> modeButton;
    @Shadow
    private CycleButton<Boolean> conditionalButton;
    @Shadow
    private CycleButton<Boolean> autoexecButton;
    @Unique
    private EditBox textFieldName;
    @Unique
    private CycleButton<Boolean> buttonUpdateExec;
    @Unique
    private boolean updateExecValue;
    @Unique
    private String lastName = "";

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void addExtraFields(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_COMMAND_BLOCK_EXTRA_FIELDS.getBooleanValue()) {
            int x1 = this.width / 2 - 152;
            int x2 = x1 + 204;
            int y = 158;
            int width = 200;
            this.modeButton.setY(y);
            this.conditionalButton.setY(y);
            this.autoexecButton.setY(y);
            this.doneButton.setY(y += 46);
            this.cancelButton.setY(y);
            MutableComponent str = Component.translatable((String)"tweakeroo.gui.button.misc.command_block.set_name");
            int widthBtn = this.font.width((FormattedText)str) + 10;
            y = 181;
            this.textFieldName = new EditBox(this.font, x1, y, width, 20, Component.nullToEmpty((String)""));
            this.textFieldName.setValue(this.autoCommandBlock.getCommandBlock().getName().getString());
            this.addWidget((GuiEventListener)this.textFieldName);
            EditBox tf = this.textFieldName;
            BlockPos pos = this.autoCommandBlock.getBlockPos();
            Button.Builder builder = Button.builder((Component)str, button -> {
                String name = tf.getValue();
                name = String.format("{\"CustomName\":\"{\\\"text\\\":\\\"%s\\\"}\"}", name);
                this.minecraft.player.connection.sendUnsignedCommand(String.format("data merge block %d %d %d %s", pos.getX(), pos.getY(), pos.getZ(), name));
            });
            builder.pos(x2, y).size(widthBtn, 20);
            this.addRenderableWidget((GuiEventListener)builder.build());
            this.updateExecValue = MiscUtils.getUpdateExec(this.autoCommandBlock);
            MutableComponent strOn = Component.translatable((String)"tweakeroo.gui.button.misc.command_block.update_execution.on");
            MutableComponent strOff = Component.translatable((String)"tweakeroo.gui.button.misc.command_block.update_execution.off");
            MutableComponent strLooping = Component.translatable((String)"tweakeroo.gui.button.misc.command_block.update_execution.looping");
            width = this.font.width((FormattedText)strOff) + 10;
            this.buttonUpdateExec = CycleButton.booleanBuilder((Component)strOn, (Component)strOff).displayOnlyValue().withInitialValue((Object)this.updateExecValue).create(x2 + widthBtn + 4, y, width, 20, (Component)strLooping, (button, val) -> {
                this.updateExecValue = val;
                MiscUtils.setUpdateExec(this.autoCommandBlock, this.updateExecValue);
                String cmd = String.format("data merge block %d %d %d {\"UpdateLastExecution\":%s}", pos.getX(), pos.getY(), pos.getZ(), this.updateExecValue ? "1b" : "0b");
                this.minecraft.player.connection.sendUnsignedCommand(cmd);
            });
            this.addRenderableWidget((GuiEventListener)this.buttonUpdateExec);
        }
    }

    public void tick() {
        boolean updateExec;
        String currentName;
        super.tick();
        if (this.textFieldName != null && !(currentName = this.autoCommandBlock.getCommandBlock().getName().getString()).equals(this.lastName)) {
            this.textFieldName.setValue(currentName);
            this.lastName = currentName;
        }
        if (this.buttonUpdateExec != null && this.updateExecValue != (updateExec = MiscUtils.getUpdateExec(this.autoCommandBlock))) {
            this.updateExecValue = updateExec;
            Component str = MixinCommandBlockScreen.getDisplayStringForCurrentStatus(this.updateExecValue);
            this.buttonUpdateExec.setMessage(str);
            this.buttonUpdateExec.setWidth(this.font.width((FormattedText)str) + 10);
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        super.render(drawContext, mouseX, mouseY, partialTicks);
        if (this.textFieldName != null) {
            this.textFieldName.render(drawContext, mouseX, mouseY, partialTicks);
        }
        if (this.buttonUpdateExec != null && this.buttonUpdateExec.isHovered()) {
            String hover = "tweakeroo.gui.button.misc.command_block.hover.update_execution";
            RenderUtils.drawHoverText((int)mouseX, (int)mouseY, Arrays.asList(StringUtils.translate((String)hover, (Object[])new Object[0])), (GuiGraphics)drawContext);
        }
    }

    private static Component getDisplayStringForCurrentStatus(boolean updateExecValue) {
        String translationKey = "tweakeroo.gui.button.misc.command_block.update_execution";
        boolean isCurrentlyOn = !updateExecValue;
        String strStatus = "malilib.gui.label_colored." + (isCurrentlyOn ? "on" : "off");
        return Component.translatable((String)translationKey, (Object[])new Object[]{StringUtils.translate((String)strStatus, (Object[])new Object[0])});
    }
}

