/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.data.ServerDataSyncer;
import fi.dy.masa.tweakeroo.network.ServuxTweaksPacket;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ServuxTweaksHandler<T extends CustomPacketPayload>
implements IPluginClientPlayHandler<T> {
    private static final ServuxTweaksHandler<ServuxTweaksPacket.Payload> INSTANCE = new ServuxTweaksHandler<ServuxTweaksPacket.Payload>(){

        public void receive(ServuxTweaksPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final ResourceLocation CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"servux", (String)"tweaks");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;
    private long readingSessionKey = -1L;

    public static ServuxTweaksHandler<ServuxTweaksPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public ResourceLocation getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public <P extends IClientPayloadData> void decodeClientData(ResourceLocation channel, P data) {
        ServuxTweaksPacket packet = (ServuxTweaksPacket)data;
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_S2C_METADATA: {
                if (!ServerDataSyncer.getInstance().receiveServuxMetadata(packet.getCompound())) break;
                this.servuxRegistered = true;
                break;
            }
            case PACKET_S2C_BLOCK_NBT_RESPONSE_SIMPLE: {
                ServerDataSyncer.getInstance().handleBlockEntityData(packet.getPos(), packet.getCompound(), null);
                break;
            }
            case PACKET_S2C_ENTITY_NBT_RESPONSE_SIMPLE: {
                ServerDataSyncer.getInstance().handleEntityData(packet.getEntityId(), packet.getCompound());
                break;
            }
            case PACKET_S2C_NBT_RESPONSE_DATA: {
                FriendlyByteBuf fullPacket;
                if (this.readingSessionKey == -1L) {
                    this.readingSessionKey = RandomSource.create((long)Util.getMillis()).nextLong();
                }
                if ((fullPacket = PacketSplitter.receive((IPluginClientPlayHandler)this, (long)this.readingSessionKey, (FriendlyByteBuf)packet.getBuffer())) == null) break;
                try {
                    this.readingSessionKey = -1L;
                    ServerDataSyncer.getInstance().handleBulkEntityData(fullPacket.readVarInt(), (CompoundTag)fullPacket.readNbt(NbtAccounter.unlimitedHeap()));
                }
                catch (Exception e) {
                    Tweakeroo.LOGGER.error("ServuxTweaksHandler#decodeClientData(): Tweaks Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Tweakeroo.LOGGER.warn("ServuxTweaksHandler#decodeClientData(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
            }
        }
    }

    public void reset(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
            this.readingSessionKey = -1L;
        }
    }

    public void resetFailures(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.type().id().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeClientData(CHANNEL_ID, ((ServuxTweaksPacket.Payload)payload).data());
        }
    }

    public void encodeWithSplitter(FriendlyByteBuf buffer, ClientPacketListener handler) {
        INSTANCE.sendPlayPayload(new ServuxTweaksPacket.Payload(ServuxTweaksPacket.ResponseS2CData(buffer)));
    }

    public <P extends IClientPayloadData> void encodeClientData(P data) {
        ServuxTweaksPacket packet = (ServuxTweaksPacket)data;
        if (packet.getType().equals((Object)ServuxTweaksPacket.Type.PACKET_C2S_NBT_RESPONSE_START)) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeVarInt(packet.getTransactionId());
            buffer.writeNbt((Tag)packet.getCompound());
            PacketSplitter.send((IPluginClientPlayHandler)this, (FriendlyByteBuf)buffer, (ClientPacketListener)Minecraft.getInstance().getConnection());
        } else if (!INSTANCE.sendPlayPayload(new ServuxTweaksPacket.Payload(packet))) {
            if (this.failures > 4) {
                Tweakeroo.debugLog("ServuxTweaksHandler#encodeClientData(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", 4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                ServerDataSyncer.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

