/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.config;

import com.mojang.blaze3d.platform.InputConstants;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeyCallbackAdjustable;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.render.InventoryOverlayScreen;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.data.CachedTagManager;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.gui.GuiCameraPresetEditor;
import fi.dy.masa.tweakeroo.gui.GuiConfigs;
import fi.dy.masa.tweakeroo.mixin.block.IMixinAbstractBlock;
import fi.dy.masa.tweakeroo.mixin.option.IMixinSimpleOption;
import fi.dy.masa.tweakeroo.renderer.InventoryOverlayHandler;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import fi.dy.masa.tweakeroo.util.PlacementRestrictionMode;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.gui.components.debug.DebugScreenEntryList;
import net.minecraft.client.gui.components.debug.DebugScreenEntryStatus;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class Callbacks {
    public static boolean skipWorldRendering;

    public static void init(Minecraft mc) {
        FeatureToggle.TWEAK_F3_CURSOR.setValueChangeCallback(new FeatureCallbackF3Toggle(FeatureToggle.TWEAK_F3_CURSOR, mc));
        FeatureToggle.TWEAK_GAMMA_OVERRIDE.setValueChangeCallback(new FeatureCallbackGamma(FeatureToggle.TWEAK_GAMMA_OVERRIDE, mc));
        FeatureToggle.TWEAK_DARKNESS_VISIBILITY.setValueChangeCallback(new FeatureCallbackDarkness(FeatureToggle.TWEAK_DARKNESS_VISIBILITY, mc));
        Configs.Disable.DISABLE_SLIME_BLOCK_SLOWDOWN.setValueChangeCallback((IValueChangeCallback)new FeatureCallbackSlime((ConfigBoolean)Configs.Disable.DISABLE_SLIME_BLOCK_SLOWDOWN));
        FeatureToggle.TWEAK_FAST_BLOCK_PLACEMENT.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleFastMode(FeatureToggle.TWEAK_FAST_BLOCK_PLACEMENT));
        FeatureToggle.TWEAK_FAST_BLOCK_PLACEMENT.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)cfg -> {
            if (Configs.Generic.PLACEMENT_RESTRICTION_TIED_TO_FAST.getBooleanValue()) {
                FeatureToggle.TWEAK_PLACEMENT_RESTRICTION.setBooleanValue(cfg.getBooleanValue());
            }
        }));
        FeatureToggle.TWEAK_FREE_CAMERA.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)cfg -> CameraEntity.setCameraState(cfg.getBooleanValue(), null)));
        FeatureToggle.TWEAK_HOLD_ATTACK.setValueChangeCallback(new FeatureCallbackHold(mc.options.keyAttack));
        FeatureToggle.TWEAK_HOLD_USE.setValueChangeCallback(new FeatureCallbackHold(mc.options.keyUse));
        KeyCallbackHotkeysGeneric callbackGeneric = new KeyCallbackHotkeysGeneric(mc);
        KeyCallbackHotkeyWithMessage callbackMessage = new KeyCallbackHotkeyWithMessage(mc);
        KeyCallbackFreeCameraPresets callbackFreeCamPresets = new KeyCallbackFreeCameraPresets(mc);
        Hotkeys.BREAKING_RESTRICTION_MODE_COLUMN.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.BREAKING_RESTRICTION_MODE_DIAGONAL.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.BREAKING_RESTRICTION_MODE_FACE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.BREAKING_RESTRICTION_MODE_LAYER.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.BREAKING_RESTRICTION_MODE_LINE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.BREAKING_RESTRICTION_MODE_PLANE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.COPY_SIGN_TEXT.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FLY_PRESET_1.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FLY_PRESET_2.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FLY_PRESET_3.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FLY_PRESET_4.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FLY_INCREMENT_1.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FLY_INCREMENT_2.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.FREE_CAMERA_PLAYER_INPUTS.getKeybind().setCallback((action, key) -> {
            ConfigBooleanHotkeyed config = Configs.Generic.FREE_CAMERA_PLAYER_INPUTS;
            config.toggleBooleanValue();
            InfoUtils.printBooleanConfigToggleMessage((String)config.getPrettyName(), (boolean)config.getBooleanValue());
            return true;
        });
        Hotkeys.FREE_CAMERA_PLAYER_MOVEMENT.getKeybind().setCallback((action, key) -> {
            ConfigBooleanHotkeyed config = Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT;
            config.toggleBooleanValue();
            InfoUtils.printBooleanConfigToggleMessage((String)config.getPrettyName(), (boolean)config.getBooleanValue());
            return true;
        });
        Hotkeys.FREE_CAMERA_PRESET_ADD.getKeybind().setCallback((IHotkeyCallback)callbackFreeCamPresets);
        Hotkeys.FREE_CAMERA_PRESET_CYCLE.getKeybind().setCallback((IHotkeyCallback)callbackFreeCamPresets);
        Hotkeys.FREE_CAMERA_PRESET_DELETE.getKeybind().setCallback((IHotkeyCallback)callbackFreeCamPresets);
        Hotkeys.FREE_CAMERA_PRESET_DELETE_ALL.getKeybind().setCallback((IHotkeyCallback)callbackFreeCamPresets);
        Hotkeys.HOTBAR_SWAP_1.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.HOTBAR_SWAP_2.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.HOTBAR_SWAP_3.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.HOTBAR_SCROLL.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.INVENTORY_PREVIEW_TOGGLE_SCREEN.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.OPEN_CONFIG_GUI.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.OPEN_CAMERA_PRESET_EDITOR_GUI.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.PLACEMENT_RESTRICTION_MODE_COLUMN.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.PLACEMENT_RESTRICTION_MODE_DIAGONAL.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.PLACEMENT_RESTRICTION_MODE_FACE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.PLACEMENT_RESTRICTION_MODE_LAYER.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.PLACEMENT_RESTRICTION_MODE_LINE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.PLACEMENT_RESTRICTION_MODE_PLANE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.SIT_DOWN_NEARBY_PETS.getKeybind().setCallback((a, k) -> MiscUtils.commandNearbyPets(true));
        Hotkeys.STAND_UP_NEARBY_PETS.getKeybind().setCallback((a, k) -> MiscUtils.commandNearbyPets(false));
        Hotkeys.SWAP_ELYTRA_CHESTPLATE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.TOGGLE_AP_PROTOCOL.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.ACCURATE_PLACEMENT_PROTOCOL));
        Hotkeys.TOGGLE_GRAB_CURSOR.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.TOOL_PICK.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.WRITE_MAPS_AS_IMAGES.getKeybind().setCallback((a, k) -> MiscUtils.writeAllMapsAsImages());
        Hotkeys.ZOOM_ACTIVATE.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.AREA_SELECTION_ADD_TO_LIST.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.AREA_SELECTION_REMOVE_FROM_LIST.getKeybind().setCallback((IHotkeyCallback)callbackGeneric);
        Hotkeys.SKIP_ALL_RENDERING.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Hotkeys.SKIP_WORLD_RENDERING.getKeybind().setCallback((IHotkeyCallback)callbackMessage);
        Configs.Generic.TOOL_SWITCHABLE_SLOTS.setValueChangeCallback(cfg -> InventoryUtils.setToolSwitchableSlots(cfg.getStringValue()));
        FeatureToggle.TWEAK_AFTER_CLICKER.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_AFTER_CLICKER));
        FeatureToggle.TWEAK_BREAKING_GRID.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_BREAKING_GRID));
        FeatureToggle.TWEAK_FLY_SPEED.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_FLY_SPEED));
        FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE));
        FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER));
        FeatureToggle.TWEAK_PLACEMENT_GRID.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_PLACEMENT_GRID));
        FeatureToggle.TWEAK_PLACEMENT_LIMIT.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_PLACEMENT_LIMIT));
        FeatureToggle.TWEAK_SNAP_AIM.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_SNAP_AIM));
        FeatureToggle.TWEAK_ZOOM.getKeybind().setCallback(KeyCallbackAdjustableFeature.createCallback((IConfigBoolean)FeatureToggle.TWEAK_ZOOM));
        Configs.Lists.SELECTIVE_BLOCKS_BLACKLIST.setValueChangeCallback(cfg -> RenderTweaks.rebuildLists());
        Configs.Lists.SELECTIVE_BLOCKS_WHITELIST.setValueChangeCallback(cfg -> RenderTweaks.rebuildLists());
        Configs.Lists.SELECTIVE_BLOCKS_LIST_TYPE.setValueChangeCallback(cfg -> RenderTweaks.rebuildLists());
        FeatureToggle.TWEAK_SELECTIVE_BLOCKS_RENDERING.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)cfg -> RenderTweaks.rebuildLists()));
        Configs.Disable.DISABLE_RENDERING_SCAFFOLDING.setValueChangeCallback(cfg -> mc.levelRenderer.allChanged());
        Configs.Generic.TOOL_SWAP_SILK_TOUCH_OVERRIDE.setValueChangeCallback(cfg -> CachedTagManager.parseSilkTouchOverride(Configs.Lists.SILK_TOUCH_OVERRIDE.getStrings()));
    }

    public static class FeatureCallbackF3Toggle
    implements IValueChangeCallback<IConfigBoolean> {
        private final Minecraft mc;

        public FeatureCallbackF3Toggle(FeatureToggle feature, Minecraft mc) {
            this.mc = mc;
            this.applyValue(mc.debugEntries, feature.getBooleanValue());
        }

        public void onValueChanged(IConfigBoolean config) {
            this.applyValue(this.mc.debugEntries, config.getBooleanValue());
        }

        private void applyValue(DebugScreenEntryList profile, boolean enable) {
            if (enable && profile.getStatus(DebugScreenEntries.THREE_DIMENSIONAL_CROSSHAIR) != DebugScreenEntryStatus.ALWAYS_ON) {
                profile.setStatus(DebugScreenEntries.THREE_DIMENSIONAL_CROSSHAIR, DebugScreenEntryStatus.ALWAYS_ON);
            } else if (!enable && profile.getStatus(DebugScreenEntries.THREE_DIMENSIONAL_CROSSHAIR) != DebugScreenEntryStatus.IN_F3) {
                profile.setStatus(DebugScreenEntries.THREE_DIMENSIONAL_CROSSHAIR, DebugScreenEntryStatus.IN_F3);
            }
        }
    }

    public static class FeatureCallbackGamma
    implements IValueChangeCallback<IConfigBoolean> {
        private final Minecraft mc;

        public FeatureCallbackGamma(FeatureToggle feature, Minecraft mc) {
            this.mc = mc;
            double gamma = (Double)this.mc.options.gamma().get();
            if (gamma <= 1.0) {
                Configs.Internal.GAMMA_VALUE_ORIGINAL.setDoubleValue(gamma);
            }
            if (feature.getBooleanValue()) {
                this.applyValue(Configs.Generic.GAMMA_OVERRIDE_VALUE.getDoubleValue());
            }
        }

        public void onValueChanged(IConfigBoolean config) {
            double gamma;
            if (config.getBooleanValue()) {
                Configs.Internal.GAMMA_VALUE_ORIGINAL.setDoubleValue(((Double)this.mc.options.gamma().get()).doubleValue());
                gamma = Configs.Generic.GAMMA_OVERRIDE_VALUE.getDoubleValue();
            } else {
                gamma = Configs.Internal.GAMMA_VALUE_ORIGINAL.getDoubleValue();
            }
            this.applyValue(gamma);
        }

        private void applyValue(double gamma) {
            IMixinSimpleOption opt = (IMixinSimpleOption)this.mc.options.gamma();
            if (opt != null) {
                opt.tweakeroo_setValueWithoutCheck(gamma);
            }
        }
    }

    public static class FeatureCallbackDarkness
    implements IValueChangeCallback<IConfigBoolean> {
        private final Minecraft mc;

        public FeatureCallbackDarkness(FeatureToggle feature, Minecraft mc) {
            this.mc = mc;
            double darkness = (Double)this.mc.options.darknessEffectScale().get();
            if (darkness <= 1.0) {
                Configs.Internal.DARKNESS_SCALE_VALUE_ORIGINAL.setDoubleValue(darkness);
            }
            if (feature.getBooleanValue()) {
                this.applyValue(Configs.Generic.DARKNESS_SCALE_OVERRIDE_VALUE.getDoubleValue());
            }
        }

        public void onValueChanged(IConfigBoolean config) {
            double darkness;
            if (config.getBooleanValue()) {
                Configs.Internal.DARKNESS_SCALE_VALUE_ORIGINAL.setDoubleValue(((Double)this.mc.options.darknessEffectScale().get()).doubleValue());
                darkness = Configs.Generic.DARKNESS_SCALE_OVERRIDE_VALUE.getDoubleValue();
            } else {
                darkness = Configs.Internal.DARKNESS_SCALE_VALUE_ORIGINAL.getDoubleValue();
            }
            this.applyValue(darkness);
        }

        private void applyValue(double darkness) {
            IMixinSimpleOption opt = (IMixinSimpleOption)this.mc.options.darknessEffectScale();
            if (opt != null) {
                opt.tweakeroo_setValueWithoutCheck(darkness);
            }
        }
    }

    public static class FeatureCallbackSlime
    implements IValueChangeCallback<ConfigBoolean> {
        public FeatureCallbackSlime(ConfigBoolean feature) {
            Configs.Internal.SLIME_BLOCK_SLIPPERINESS_ORIGINAL.setDoubleValue((double)Blocks.SLIME_BLOCK.getFriction());
            if (feature.getBooleanValue()) {
                ((IMixinAbstractBlock)Blocks.SLIME_BLOCK).setFriction(Blocks.STONE.getFriction());
            }
        }

        public void onValueChanged(ConfigBoolean config) {
            if (config.getBooleanValue()) {
                ((IMixinAbstractBlock)Blocks.SLIME_BLOCK).setFriction(Blocks.STONE.getFriction());
            } else {
                ((IMixinAbstractBlock)Blocks.SLIME_BLOCK).setFriction((float)Configs.Internal.SLIME_BLOCK_SLIPPERINESS_ORIGINAL.getDoubleValue());
            }
        }
    }

    private static class KeyCallbackToggleFastMode
    implements IHotkeyCallback {
        private final FeatureToggle feature;

        private KeyCallbackToggleFastMode(FeatureToggle feature) {
            this.feature = feature;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            this.feature.toggleBooleanValue();
            boolean enabled = this.feature.getBooleanValue();
            Object strStatus = StringUtils.translate((String)("tweakeroo.message.value." + (enabled ? "on" : "off")), (Object[])new Object[0]);
            String preGreen = GuiBase.TXT_GREEN;
            String preRed = GuiBase.TXT_RED;
            String rst = GuiBase.TXT_RST;
            strStatus = (enabled ? preGreen : preRed) + (String)strStatus + rst;
            if (enabled) {
                String strMode = ((PlacementRestrictionMode)Configs.Generic.PLACEMENT_RESTRICTION_MODE.getOptionListValue()).name();
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_fast_placement_mode_on", (Object[])new Object[]{strStatus, preGreen + strMode + rst});
            } else {
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{this.feature.getPrettyName(), strStatus});
            }
            return true;
        }
    }

    public static class FeatureCallbackHold
    implements IValueChangeCallback<IConfigBoolean> {
        private final KeyMapping keyBind;

        public FeatureCallbackHold(KeyMapping keyBind) {
            this.keyBind = keyBind;
        }

        public void onValueChanged(IConfigBoolean config) {
            if (config.getBooleanValue()) {
                KeyMapping.set((InputConstants.Key)InputConstants.getKey((String)this.keyBind.saveString()), (boolean)true);
                KeyMapping.click((InputConstants.Key)InputConstants.getKey((String)this.keyBind.saveString()));
            } else {
                KeyMapping.set((InputConstants.Key)InputConstants.getKey((String)this.keyBind.saveString()), (boolean)false);
            }
        }
    }

    private static class KeyCallbackHotkeysGeneric
    implements IHotkeyCallback {
        private final Minecraft mc;

        public KeyCallbackHotkeysGeneric(Minecraft mc) {
            this.mc = mc;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            if (key == Hotkeys.AREA_SELECTION_ADD_TO_LIST.getKeybind()) {
                RenderTweaks.addSelectionToList();
                return true;
            }
            if (key == Hotkeys.AREA_SELECTION_REMOVE_FROM_LIST.getKeybind()) {
                RenderTweaks.removeSelectionFromList();
                return true;
            }
            if (key == Hotkeys.TOOL_PICK.getKeybind()) {
                if (this.mc.hitResult != null && this.mc.hitResult.getType() == HitResult.Type.BLOCK) {
                    InventoryUtils.trySwitchToEffectiveTool(((BlockHitResult)this.mc.hitResult).getBlockPos());
                    return true;
                }
            } else {
                if (key == Hotkeys.COPY_SIGN_TEXT.getKeybind()) {
                    BlockPos pos;
                    BlockEntity te;
                    HitResult trace = this.mc.hitResult;
                    if (trace != null && trace.getType() == HitResult.Type.BLOCK && this.mc.level != null && (te = this.mc.level.getBlockEntity(pos = ((BlockHitResult)trace).getBlockPos())) instanceof SignBlockEntity) {
                        MiscUtils.copyTextFromSign((SignBlockEntity)te, ((SignBlockEntity)te).isFacingFrontText((Player)this.mc.player));
                        InfoUtils.printActionbarMessage((String)"tweakeroo.message.sign_text_copied", (Object[])new Object[0]);
                    }
                    return true;
                }
                if (key == Hotkeys.HOTBAR_SWAP_1.getKeybind()) {
                    if (FeatureToggle.TWEAK_HOTBAR_SWAP.getBooleanValue() && this.mc.player != null) {
                        InventoryUtils.swapHotbarWithInventoryRow((Player)this.mc.player, 0);
                        return true;
                    }
                } else if (key == Hotkeys.HOTBAR_SWAP_2.getKeybind()) {
                    if (FeatureToggle.TWEAK_HOTBAR_SWAP.getBooleanValue() && this.mc.player != null) {
                        InventoryUtils.swapHotbarWithInventoryRow((Player)this.mc.player, 1);
                        return true;
                    }
                } else if (key == Hotkeys.HOTBAR_SWAP_3.getKeybind()) {
                    if (FeatureToggle.TWEAK_HOTBAR_SWAP.getBooleanValue() && this.mc.player != null) {
                        InventoryUtils.swapHotbarWithInventoryRow((Player)this.mc.player, 2);
                        return true;
                    }
                } else {
                    if (key == Hotkeys.FLY_PRESET_1.getKeybind()) {
                        this.setFlySpeedPreset(0);
                        return true;
                    }
                    if (key == Hotkeys.FLY_PRESET_2.getKeybind()) {
                        this.setFlySpeedPreset(1);
                        return true;
                    }
                    if (key == Hotkeys.FLY_PRESET_3.getKeybind()) {
                        this.setFlySpeedPreset(2);
                        return true;
                    }
                    if (key == Hotkeys.FLY_PRESET_4.getKeybind()) {
                        this.setFlySpeedPreset(3);
                        return true;
                    }
                    if (key == Hotkeys.FLY_INCREMENT_1.getKeybind()) {
                        ConfigDouble config = Configs.getActiveFlySpeedConfig();
                        double newValue = config.getDoubleValue() + Configs.Generic.FLY_SPEED_INCREMENT_1.getDoubleValue();
                        config.setDoubleValue(newValue);
                        String strIndex = GuiBase.TXT_GREEN + (Configs.Internal.FLY_SPEED_PRESET.getIntegerValue() + 1) + GuiBase.TXT_RST;
                        String strValue = GuiBase.TXT_GREEN + String.format("%.3f", config.getDoubleValue()) + GuiBase.TXT_RST;
                        InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_fly_speed_to", (Object[])new Object[]{strIndex, strValue});
                        return true;
                    }
                    if (key == Hotkeys.FLY_INCREMENT_2.getKeybind()) {
                        ConfigDouble config = Configs.getActiveFlySpeedConfig();
                        double newValue = config.getDoubleValue() + Configs.Generic.FLY_SPEED_INCREMENT_2.getDoubleValue();
                        config.setDoubleValue(newValue);
                        String strIndex = GuiBase.TXT_GREEN + (Configs.Internal.FLY_SPEED_PRESET.getIntegerValue() + 1) + GuiBase.TXT_RST;
                        String strValue = GuiBase.TXT_GREEN + String.format("%.3f", config.getDoubleValue()) + GuiBase.TXT_RST;
                        InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_fly_speed_to", (Object[])new Object[]{strIndex, strValue});
                        return true;
                    }
                    if (key == Hotkeys.HOTBAR_SCROLL.getKeybind()) {
                        if (FeatureToggle.TWEAK_HOTBAR_SCROLL.getBooleanValue() && this.mc.player != null) {
                            int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
                            InventoryUtils.swapHotbarWithInventoryRow((Player)this.mc.player, currentRow);
                            return true;
                        }
                    } else {
                        if (key == Hotkeys.BREAKING_RESTRICTION_MODE_COLUMN.getKeybind()) {
                            this.setBreakingRestrictionMode(PlacementRestrictionMode.COLUMN);
                            return true;
                        }
                        if (key == Hotkeys.BREAKING_RESTRICTION_MODE_DIAGONAL.getKeybind()) {
                            this.setBreakingRestrictionMode(PlacementRestrictionMode.DIAGONAL);
                            return true;
                        }
                        if (key == Hotkeys.BREAKING_RESTRICTION_MODE_FACE.getKeybind()) {
                            this.setBreakingRestrictionMode(PlacementRestrictionMode.FACE);
                            return true;
                        }
                        if (key == Hotkeys.BREAKING_RESTRICTION_MODE_LAYER.getKeybind()) {
                            this.setBreakingRestrictionMode(PlacementRestrictionMode.LAYER);
                            return true;
                        }
                        if (key == Hotkeys.BREAKING_RESTRICTION_MODE_LINE.getKeybind()) {
                            this.setBreakingRestrictionMode(PlacementRestrictionMode.LINE);
                            return true;
                        }
                        if (key == Hotkeys.BREAKING_RESTRICTION_MODE_PLANE.getKeybind()) {
                            this.setBreakingRestrictionMode(PlacementRestrictionMode.PLANE);
                            return true;
                        }
                        if (key == Hotkeys.PLACEMENT_RESTRICTION_MODE_COLUMN.getKeybind()) {
                            this.setPlacementRestrictionMode(PlacementRestrictionMode.COLUMN);
                            return true;
                        }
                        if (key == Hotkeys.PLACEMENT_RESTRICTION_MODE_DIAGONAL.getKeybind()) {
                            this.setPlacementRestrictionMode(PlacementRestrictionMode.DIAGONAL);
                            return true;
                        }
                        if (key == Hotkeys.PLACEMENT_RESTRICTION_MODE_FACE.getKeybind()) {
                            this.setPlacementRestrictionMode(PlacementRestrictionMode.FACE);
                            return true;
                        }
                        if (key == Hotkeys.PLACEMENT_RESTRICTION_MODE_LAYER.getKeybind()) {
                            this.setPlacementRestrictionMode(PlacementRestrictionMode.LAYER);
                            return true;
                        }
                        if (key == Hotkeys.PLACEMENT_RESTRICTION_MODE_LINE.getKeybind()) {
                            this.setPlacementRestrictionMode(PlacementRestrictionMode.LINE);
                            return true;
                        }
                        if (key == Hotkeys.PLACEMENT_RESTRICTION_MODE_PLANE.getKeybind()) {
                            this.setPlacementRestrictionMode(PlacementRestrictionMode.PLANE);
                            return true;
                        }
                        if (key == Hotkeys.OPEN_CONFIG_GUI.getKeybind()) {
                            GuiBase.openGui((Screen)new GuiConfigs());
                            return true;
                        }
                        if (key == Hotkeys.OPEN_CAMERA_PRESET_EDITOR_GUI.getKeybind()) {
                            GuiBase.openGui((Screen)new GuiCameraPresetEditor());
                            return true;
                        }
                        if (key == Hotkeys.SWAP_ELYTRA_CHESTPLATE.getKeybind()) {
                            InventoryUtils.swapElytraAndChestPlate((Player)this.mc.player);
                            return true;
                        }
                        if (key == Hotkeys.TOGGLE_GRAB_CURSOR.getKeybind()) {
                            if (this.mc.isWindowActive()) {
                                if (this.mc.mouseHandler.isMouseGrabbed()) {
                                    this.mc.mouseHandler.releaseMouse();
                                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.unfocusing_game", (Object[])new Object[0]);
                                } else {
                                    this.mc.mouseHandler.grabMouse();
                                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.focusing_game", (Object[])new Object[0]);
                                }
                            }
                        } else if (key == Hotkeys.ZOOM_ACTIVATE.getKeybind()) {
                            if (action == KeyAction.PRESS) {
                                MiscUtils.onZoomActivated();
                            } else {
                                MiscUtils.onZoomDeactivated();
                            }
                        } else if (key == Hotkeys.INVENTORY_PREVIEW_TOGGLE_SCREEN.getKeybind()) {
                            if (this.mc.screen instanceof InventoryOverlayScreen) {
                                this.mc.setScreen(null);
                            } else if (FeatureToggle.TWEAK_INVENTORY_PREVIEW.getBooleanValue() && Hotkeys.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
                                InventoryOverlayHandler.getInstance().refreshInventoryOverlay(this.mc, Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
                            }
                        }
                    }
                }
            }
            return false;
        }

        private void setFlySpeedPreset(int preset) {
            Configs.Internal.FLY_SPEED_PRESET.setIntegerValue(preset);
            float speed = (float)Configs.getActiveFlySpeedConfig().getDoubleValue();
            String strPreset = GuiBase.TXT_GREEN + (preset + 1) + GuiBase.TXT_RST;
            String strSpeed = String.format("%s%.3f%s", GuiBase.TXT_GREEN, Float.valueOf(speed), GuiBase.TXT_RST);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_fly_speed_preset_to", (Object[])new Object[]{strPreset, strSpeed});
        }

        private void setBreakingRestrictionMode(PlacementRestrictionMode mode) {
            Configs.Generic.BREAKING_RESTRICTION_MODE.setOptionListValue((IConfigOptionListEntry)mode);
            String str = GuiBase.TXT_GREEN + mode.name() + GuiBase.TXT_RST;
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_breaking_restriction_mode_to", (Object[])new Object[]{str});
        }

        private void setPlacementRestrictionMode(PlacementRestrictionMode mode) {
            Configs.Generic.PLACEMENT_RESTRICTION_MODE.setOptionListValue((IConfigOptionListEntry)mode);
            String str = GuiBase.TXT_GREEN + mode.name() + GuiBase.TXT_RST;
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_placement_restriction_mode_to", (Object[])new Object[]{str});
        }
    }

    public static class KeyCallbackHotkeyWithMessage
    implements IHotkeyCallback {
        private final Minecraft mc;

        public KeyCallbackHotkeyWithMessage(Minecraft mc) {
            this.mc = mc;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            if (key == Hotkeys.SKIP_ALL_RENDERING.getKeybind()) {
                this.mc.noRender = !this.mc.noRender;
                String pre = this.mc.noRender ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                String status = StringUtils.translate((String)("tweakeroo.message.value." + (this.mc.noRender ? "on" : "off")), (Object[])new Object[0]);
                String message = StringUtils.translate((String)"tweakeroo.message.toggled", (Object[])new Object[]{"Skip All Rendering", pre + status + GuiBase.TXT_RST});
                InfoUtils.printActionbarMessage((String)message, (Object[])new Object[0]);
            } else if (key == Hotkeys.SKIP_WORLD_RENDERING.getKeybind()) {
                boolean enabled = skipWorldRendering = !skipWorldRendering;
                String pre = enabled ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                String status = StringUtils.translate((String)("tweakeroo.message.value." + (enabled ? "on" : "off")), (Object[])new Object[0]);
                String message = StringUtils.translate((String)"tweakeroo.message.toggled", (Object[])new Object[]{"Skip World Rendering", pre + status + GuiBase.TXT_RST});
                InfoUtils.printActionbarMessage((String)message, (Object[])new Object[0]);
            }
            return true;
        }
    }

    private static class KeyCallbackFreeCameraPresets
    implements IHotkeyCallback {
        private final String PREFIX = "tweakeroo.message.free_cam.preset";
        private final Minecraft mc;

        public KeyCallbackFreeCameraPresets(Minecraft mc) {
            this.mc = mc;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            if (this.mc.player == null || this.mc.level == null || this.mc.getCameraEntity() == null) {
                return false;
            }
            ResourceKey dimKey = this.mc.level.dimension();
            Entity camera = this.mc.getCameraEntity();
            if (key == Hotkeys.FREE_CAMERA_PRESET_ADD.getKeybind()) {
                String name;
                int id = CameraPresetManager.getInstance().getNextId(-1);
                CameraPreset newPreset = new CameraPreset(id, name = "Preset " + id, dimKey.location(), camera.position(), camera.getYRot(), camera.getXRot());
                if (CameraUtils.addPreset(newPreset)) {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_added", (Object[])new Object[]{newPreset.toShortString()}), (Object[])new Object[0]);
                } else {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_already_in_use", (Object[])new Object[0]), (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.FREE_CAMERA_PRESET_DELETE.getKeybind()) {
                CameraPreset preset = CameraPresetManager.getInstance().getAtPosition(camera);
                if (CameraUtils.deletePreset(preset)) {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_deleted", (Object[])new Object[]{preset.toShortString()}), (Object[])new Object[0]);
                } else {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_not_found", (Object[])new Object[]{String.format("%02d", 0)}), (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.FREE_CAMERA_PRESET_DELETE_ALL.getKeybind()) {
                if (CameraUtils.deleteAllPresets((ResourceKey<Level>)dimKey)) {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_deleted_all_dim", (Object[])new Object[]{dimKey.location().toString()}), (Object[])new Object[0]);
                }
                return true;
            }
            if (key == Hotkeys.FREE_CAMERA_PRESET_CYCLE.getKeybind()) {
                CameraPreset preset = CameraPresetManager.getInstance().cycle((ResourceKey<Level>)dimKey);
                if (preset != null && this.mc.level != null) {
                    if (this.mc.level.dimension().location().equals((Object)preset.getDim())) {
                        if (CameraUtils.recallPreset(preset, this.mc)) {
                            InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_recalled", (Object[])new Object[]{FeatureToggle.TWEAK_FREE_CAMERA.getPrettyName(), String.format("%02d", preset.getId()), preset.getName()}), (Object[])new Object[0]);
                        } else {
                            InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_matches_camera", (Object[])new Object[]{String.format("%02d", preset.getId())}), (Object[])new Object[0]);
                        }
                    } else {
                        InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_wrong_dimension", (Object[])new Object[]{String.format("%02d", preset.getId()), preset.getName()}), (Object[])new Object[0]);
                    }
                } else {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_cycle_not_found", (Object[])new Object[0]), (Object[])new Object[0]);
                }
                return true;
            }
            return false;
        }
    }

    private static class KeyCallbackAdjustableFeature
    implements IHotkeyCallback {
        private final IConfigBoolean config;

        private static IHotkeyCallback createCallback(IConfigBoolean config) {
            return new KeyCallbackAdjustable(config, (IHotkeyCallback)new KeyCallbackAdjustableFeature(config));
        }

        private KeyCallbackAdjustableFeature(IConfigBoolean config) {
            this.config = config;
        }

        public boolean onKeyAction(KeyAction action, IKeybind key) {
            this.config.toggleBooleanValue();
            boolean enabled = this.config.getBooleanValue();
            Object strStatus = StringUtils.translate((String)("tweakeroo.message.value." + (enabled ? "on" : "off")), (Object[])new Object[0]);
            String preGreen = GuiBase.TXT_GREEN;
            String preRed = GuiBase.TXT_RED;
            String rst = GuiBase.TXT_RST;
            String prettyName = this.config.getPrettyName();
            strStatus = (enabled ? preGreen : preRed) + (String)strStatus + rst;
            if (key == FeatureToggle.TWEAK_AFTER_CLICKER.getKeybind()) {
                if (enabled) {
                    String strValue = Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getStringValue();
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_after_clicker_on", (Object[])new Object[]{strStatus, preGreen + strValue + rst});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_FLY_SPEED.getKeybind()) {
                if (enabled) {
                    String strPreset = preGreen + (Configs.Internal.FLY_SPEED_PRESET.getIntegerValue() + 1) + rst;
                    String strSpeed = String.format("%s%.3f%s", preGreen, Configs.getActiveFlySpeedConfig().getDoubleValue(), rst);
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_fly_speed_on", (Object[])new Object[]{strStatus, strPreset, strSpeed});
                } else {
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player != null) {
                        player.getAbilities().setFlyingSpeed(0.05f);
                    }
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_PLACEMENT_LIMIT.getKeybind()) {
                if (enabled) {
                    String strValue = Configs.Generic.PLACEMENT_LIMIT.getStringValue();
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_placement_limit_on", (Object[])new Object[]{strStatus, preGreen + strValue + rst});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getKeybind()) {
                if (enabled) {
                    String strValue = Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.getStringValue();
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_slot_cycle_on", (Object[])new Object[]{strStatus, preGreen + strValue + rst});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getKeybind()) {
                if (enabled) {
                    String strValue = Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.getStringValue();
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_slot_randomizer_on", (Object[])new Object[]{strStatus, preGreen + strValue + rst});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_PLACEMENT_GRID.getKeybind()) {
                if (enabled) {
                    String strValue = Configs.Generic.PLACEMENT_GRID_SIZE.getStringValue();
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_placement_grid_on", (Object[])new Object[]{strStatus, preGreen + strValue + rst});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_BREAKING_GRID.getKeybind()) {
                if (enabled) {
                    String strValue = Configs.Generic.BREAKING_GRID_SIZE.getStringValue();
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_breaking_grid_on", (Object[])new Object[]{strStatus, preGreen + strValue + rst});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_SNAP_AIM.getKeybind()) {
                if (enabled) {
                    SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
                    if (mode == SnapAimMode.YAW) {
                        String yaw = String.valueOf(Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue());
                        InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_snap_aim_on_yaw", (Object[])new Object[]{strStatus, preGreen + yaw + rst});
                    } else if (mode == SnapAimMode.PITCH) {
                        String pitch = String.valueOf(Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue());
                        InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_snap_aim_on_pitch", (Object[])new Object[]{strStatus, preGreen + pitch + rst});
                    } else {
                        String yaw = String.valueOf(Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue());
                        String pitch = String.valueOf(Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue());
                        InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_snap_aim_on_both", (Object[])new Object[]{strStatus, preGreen + yaw + rst, preGreen + pitch + rst});
                    }
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            } else if (key == FeatureToggle.TWEAK_ZOOM.getKeybind()) {
                if (enabled) {
                    String strValue = String.format("%s%.1f%s", preGreen, Configs.Generic.ZOOM_FOV.getDoubleValue(), rst);
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled_zoom_on", (Object[])new Object[]{strStatus, strValue});
                } else {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.toggled", (Object[])new Object[]{prettyName, strStatus});
                }
            }
            return true;
        }
    }
}

