/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextInputFeedback;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.gui.widgets.WidgetCameraPresetList;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.world.entity.Entity;

public class WidgetCameraPresetEntry
extends WidgetListEntryBase<CameraPreset> {
    private final WidgetCameraPresetList parent;
    private final CameraPreset preset;
    private final List<String> hoverLines;
    private final boolean isOdd;
    private final int buttonsStartX;

    public WidgetCameraPresetEntry(int x, int y, int width, int height, boolean isOdd, CameraPreset preset, int listIndex, WidgetCameraPresetList parent) {
        super(x, y, width, height, (Object)preset, listIndex);
        this.isOdd = isOdd;
        this.preset = preset;
        this.hoverLines = preset.getWidgetHoverLines();
        this.parent = parent;
        int posX = x + width - 2;
        posX -= this.addButton(posX, y += 8, ButtonListener.Type.REMOVE);
        posX -= this.addButton(posX, y, ButtonListener.Type.SET_HERE);
        posX -= this.addButton(posX, y, ButtonListener.Type.RENAME);
        posX -= this.addButton(posX, y, ButtonListener.Type.RECALL);
        this.buttonsStartX = posX;
    }

    protected int addButton(int x, int y, ButtonListener.Type type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, true, type.getDisplayName(new Object[0]), new Object[0]);
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 2;
    }

    public boolean canSelectAt(MouseButtonEvent click) {
        return super.canSelectAt(click) && click.x() < (double)this.buttonsStartX;
    }

    public boolean onKeyTyped(KeyEvent input) {
        if (input.key() == 256) {
            this.parent.setParent(null);
            GuiBase.openGui(null);
        }
        return super.onKeyTyped(input);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, boolean selected) {
        boolean presetSelected = CameraPresetManager.getInstance().getSelectedPreset() == this.entry;
        int y = this.y + 7;
        if (selected || presetSelected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((GuiGraphics)context, (int)this.x, (int)y, (int)this.width, (int)this.height, (int)0x70FFFFFF);
        } else if (this.isOdd) {
            RenderUtils.drawRect((GuiGraphics)context, (int)this.x, (int)y, (int)this.width, (int)this.height, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((GuiGraphics)context, (int)this.x, (int)y, (int)this.width, (int)this.height, (int)0x50FFFFFF);
        }
        if (presetSelected) {
            RenderUtils.drawOutline((GuiGraphics)context, (int)this.x, (int)y, (int)this.width, (int)this.height, (int)-2039584);
        }
        String line = this.preset.toShortStringStyled();
        this.drawString(context, this.x + 4, y + 7, -1, line);
        super.render(context, mouseX, mouseY, selected);
    }

    public void postRenderHovered(GuiGraphics context, int mouseX, int mouseY, boolean selected) {
        super.postRenderHovered(context, mouseX, mouseY, selected);
        if (mouseX >= this.x && mouseX < this.buttonsStartX && mouseY >= this.y && mouseY <= this.y + this.height) {
            RenderUtils.drawHoverText((GuiGraphics)context, (int)mouseX, (int)mouseY, this.hoverLines);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final Type type;
        private final WidgetCameraPresetEntry widget;

        public ButtonListener(Type type, WidgetCameraPresetEntry widget) {
            this.type = type;
            this.widget = widget;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.widget.preset == null) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (this.type == Type.RECALL) {
                CameraPreset preset = this.widget.preset;
                if (mc.level != null && mc.level.dimension().location().equals((Object)preset.getDim())) {
                    if (CameraUtils.recallPreset(preset, mc)) {
                        InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.INFO, (int)2500, (String)"tweakeroo.message.free_cam.preset_recalled", (Object[])new Object[]{FeatureToggle.TWEAK_FREE_CAMERA.getPrettyName(), String.format("%02d", preset.getId()), preset.getName()});
                    } else {
                        InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakeroo.message.free_cam.preset_matches_camera", (Object[])new Object[]{String.format("%02d", preset.getId())});
                    }
                } else {
                    InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"tweakeroo.message.free_cam.preset_wrong_dimension", (Object[])new Object[]{String.format("%02d", preset.getId()), preset.getName()});
                }
            } else if (this.type == Type.RENAME) {
                String title = "tweakeroo.gui.title.camera_preset_rename";
                String name = this.widget.preset.getName();
                PresetRenamer renamer = new PresetRenamer(this.widget.preset, this.widget);
                GuiBase.openGui((Screen)new GuiTextInputFeedback(60, title, name, (Screen)this.widget.parent.getPresetEditorGui(), (IStringConsumerFeedback)renamer));
            } else if (this.type == Type.SET_HERE) {
                if (mc.getCameraEntity() != null) {
                    Entity camera = mc.getCameraEntity();
                    this.widget.preset.setPos(camera.position(), camera.getYRot(), camera.getXRot());
                    CameraPresetManager.getInstance().update(this.widget.preset);
                    this.widget.parent.refreshEntries();
                }
            } else if (this.type == Type.REMOVE) {
                CameraPresetManager.getInstance().remove(this.widget.preset.getId());
                this.widget.parent.refreshEntries();
            }
        }

        public static enum Type {
            RECALL("tweakeroo.gui.button.preset_entry.recall"),
            RENAME("tweakeroo.gui.button.preset_entry.rename"),
            SET_HERE("tweakeroo.gui.button.preset_entry.set_here"),
            REMOVE("tweakeroo.gui.button.preset_entry.remove");

            private final String translationKey;

            private Type(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getTranslationKey() {
                return this.translationKey;
            }

            public String getDisplayName(Object ... args) {
                return StringUtils.translate((String)this.translationKey, (Object[])args);
            }
        }
    }

    private static class PresetRenamer
    implements IStringConsumerFeedback {
        private final WidgetCameraPresetEntry widget;
        private final CameraPreset preset;

        public PresetRenamer(CameraPreset preset, WidgetCameraPresetEntry widget) {
            this.widget = widget;
            this.preset = preset;
        }

        public boolean setString(String string) {
            boolean result = this.preset.renamePreset(string, (IMessageConsumer)this.widget.parent);
            CameraPresetManager.getInstance().update(this.preset);
            this.widget.parent.refreshEntries();
            return result;
        }
    }
}

