/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraPreset {
    public static final Codec<CameraPreset> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("id").forGetter(get -> get.id), (App)PrimitiveCodec.STRING.fieldOf("name").forGetter(get -> get.name), (App)ResourceLocation.CODEC.fieldOf("dim").forGetter(get -> get.dim), (App)Vec3.CODEC.fieldOf("pos").forGetter(get -> get.pos), (App)PrimitiveCodec.FLOAT.fieldOf("yaw").forGetter(get -> Float.valueOf(get.yaw)), (App)PrimitiveCodec.FLOAT.fieldOf("pitch").forGetter(get -> Float.valueOf(get.pitch))).apply((Applicative)inst, CameraPreset::new));
    public static final CameraPreset EMPTY = new CameraPreset(-1, "EMPTY", Level.OVERWORLD.location(), Vec3.ZERO, 0.0f, 0.0f);
    private final int id;
    private String name;
    private final ResourceLocation dim;
    private Vec3 pos;
    private float yaw;
    private float pitch;

    public CameraPreset(int id, String name, ResourceLocation dim, Vec3 pos, float yaw, float pitch) {
        this.id = id;
        this.name = name;
        this.dim = dim;
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getDim() {
        return this.dim;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPos(Vec3 pos, float yaw, float pitch) {
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public boolean renamePreset(String newName, @Nullable IMessageConsumer feedback) {
        String oldName = this.name;
        this.setName(newName);
        if (feedback != null) {
            feedback.addMessage(Message.MessageType.SUCCESS, "tweakeroo.message.free_cam.preset_renamed", new Object[]{oldName, newName});
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "CameraPreset[{id=\"" + this.id + "\"},{name=\"" + this.name + "\"},{dim=\"" + this.dim.toString() + "\"},{pos=\"" + this.pos.toString() + "\"},{yaw=\"" + this.yaw + "\"},{pitch=\"" + this.pitch + "\"}]";
    }

    public boolean equals(Object o) {
        if (o instanceof CameraPreset) {
            CameraPreset other = (CameraPreset)o;
            return this.dim.equals((Object)other.dim) && this.pos.equals((Object)other.pos) && this.yaw == other.yaw && this.pitch == other.pitch;
        }
        if (o instanceof Entity) {
            Entity camera = (Entity)o;
            return this.dim.equals((Object)camera.level().dimension().location()) && (this.pos.closerThan(camera.getEyePosition(), 0.75, 0.75) || this.pos.closerThan(camera.position(), 0.75, 0.75)) && Math.abs(this.yaw - camera.getYRot()) < 35.0f && Math.abs(this.pitch - camera.getXRot()) < 35.0f;
        }
        return false;
    }

    public String toIdName() {
        return String.format("%02d", this.id) + ", " + this.name;
    }

    public List<String> getWidgetHoverLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(StringUtils.translate((String)"tweakeroo.gui.hover.camera_preset.id", (Object[])new Object[]{String.format("%02d", this.id)}));
        lines.add(StringUtils.translate((String)"tweakeroo.gui.hover.camera_preset.name", (Object[])new Object[]{this.name}));
        lines.add(StringUtils.translate((String)"tweakeroo.gui.hover.camera_preset.dim", (Object[])new Object[]{this.dim.toString()}));
        lines.add(StringUtils.translate((String)"tweakeroo.gui.hover.camera_preset.pos", (Object[])new Object[]{String.format("%.3f", this.pos.x), String.format("%.3f", this.pos.y), String.format("%.3f", this.pos.z)}));
        lines.add(StringUtils.translate((String)"tweakeroo.gui.hover.camera_preset.yaw_pitch", (Object[])new Object[]{String.format("%.3f", Float.valueOf(this.yaw)), String.format("%.3f", Float.valueOf(this.pitch))}));
        return lines;
    }

    public String toShortString() {
        return "[#" + this.toIdName() + "] " + this.dim.getPath() + ": (" + BlockPos.containing((double)this.pos.x, (double)this.pos.y, (double)this.pos.z).toShortString() + ")";
    }

    public String toShortStringStyled() {
        BlockPos pos = BlockPos.containing((double)this.pos.x, (double)this.pos.y, (double)this.pos.z);
        return "[\u00a7b#" + String.format("%02d", this.id) + "\u00a7r, \u00a7a" + this.name + "\u00a7r] \u00a7e" + this.dim.getPath() + ":\u00a7r (" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ")";
    }
}

