/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.data;

import com.mojang.datafixers.util.Either;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.mixin.network.IMixinDataQueryHandler;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.tweakeroo.Reference;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.DataManager;
import fi.dy.masa.tweakeroo.network.ServuxTweaksHandler;
import fi.dy.masa.tweakeroo.network.ServuxTweaksPacket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ServerDataSyncer
implements IClientTickHandler,
IDataSyncer {
    private static final ServerDataSyncer INSTANCE = new ServerDataSyncer();
    private static final ServuxTweaksHandler<ServuxTweaksPacket.Payload> HANDLER = ServuxTweaksHandler.getInstance();
    private static final Minecraft mc = Minecraft.getInstance();
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion;
    private boolean checkOpStatus = true;
    private boolean hasOpStatus = false;
    private long lastOpCheck = 0L;
    private final ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> blockEntityCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> entityCache = new ConcurrentHashMap();
    private long serverTickTime = 0L;
    private final Set<BlockPos> pendingBlockEntitiesQueue = new LinkedHashSet<BlockPos>();
    private final Set<Integer> pendingEntitiesQueue = new LinkedHashSet<Integer>();
    private final Map<Integer, Either<BlockPos, Integer>> transactionToBlockPosOrEntityId = new HashMap<Integer, Either<BlockPos, Integer>>();
    private ClientLevel clientWorld;

    public static ServerDataSyncer getInstance() {
        return INSTANCE;
    }

    @Nullable
    public Level getWorld() {
        return WorldUtils.getBestWorld((Minecraft)mc);
    }

    public ClientLevel getClientWorld() {
        if (this.clientWorld == null) {
            this.clientWorld = ServerDataSyncer.mc.level;
        }
        return this.clientWorld;
    }

    public void onClientTick(Minecraft mc) {
        long now = System.currentTimeMillis();
        if (now - this.serverTickTime > 50L) {
            if (!FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
                this.serverTickTime = now;
                if (!DataManager.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
                    this.servuxServer = false;
                    HANDLER.unregisterPlayReceiver();
                }
                if (!FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) {
                    if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                        this.pendingBlockEntitiesQueue.clear();
                    }
                    if (!this.pendingEntitiesQueue.isEmpty()) {
                        this.pendingEntitiesQueue.clear();
                    }
                    return;
                }
            } else if (!(DataManager.getInstance().hasIntegratedServer() || this.hasServuxServer() || this.hasInValidServux || this.getWorld() == null)) {
                HANDLER.registerPlayReceiver(ServuxTweaksPacket.Payload.ID, HANDLER::receivePlayPayload);
                this.requestMetadata();
            }
            this.tickCache(now);
            for (int i = 0; i < Configs.Generic.SERVER_NBT_REQUEST_RATE.getIntegerValue(); ++i) {
                Iterator<Object> iter;
                if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                    iter = this.pendingBlockEntitiesQueue.iterator();
                    BlockPos pos = iter.next();
                    iter.remove();
                    if (this.hasServuxServer()) {
                        this.requestServuxBlockEntityData(pos);
                    } else if (this.shouldUseQuery()) {
                        this.requestQueryBlockEntity(pos);
                    }
                }
                if (this.pendingEntitiesQueue.isEmpty()) continue;
                iter = this.pendingEntitiesQueue.iterator();
                int entityId = (Integer)iter.next();
                iter.remove();
                if (this.hasServuxServer()) {
                    this.requestServuxEntityData(entityId);
                    continue;
                }
                if (!this.shouldUseQuery()) continue;
                this.requestQueryEntityData(entityId);
            }
            this.serverTickTime = now;
        }
    }

    public ResourceLocation getNetworkChannel() {
        return ServuxTweaksHandler.CHANNEL_ID;
    }

    private ClientPacketListener getVanillaHandler() {
        if (ServerDataSyncer.mc.player != null) {
            return ServerDataSyncer.mc.player.connection;
        }
        return null;
    }

    public IPluginClientPlayHandler<ServuxTweaksPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            Tweakeroo.debugLog("ServerDataSyncer#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.checkOpStatus = false;
            this.hasOpStatus = false;
            this.lastOpCheck = 0L;
        } else {
            Tweakeroo.debugLog("ServerDataSyncer#reset() - dimension change or log-in", new Object[0]);
            long now = System.currentTimeMillis();
            this.serverTickTime = now - (this.getCacheTimeout() + 5000L);
            this.tickCache(now);
            this.serverTickTime = now;
            this.clientWorld = ServerDataSyncer.mc.level;
            this.checkOpStatus = true;
            this.lastOpCheck = now;
        }
        this.blockEntityCache.clear();
        this.entityCache.clear();
        this.pendingBlockEntitiesQueue.clear();
        this.pendingEntitiesQueue.clear();
    }

    private boolean shouldUseQuery() {
        if (this.hasOpStatus) {
            return true;
        }
        if (this.checkOpStatus) {
            if (System.currentTimeMillis() - this.lastOpCheck < 900000L) {
                return true;
            }
            this.checkOpStatus = false;
        }
        return false;
    }

    public void resetOpCheck() {
        this.hasOpStatus = false;
        this.checkOpStatus = true;
        this.lastOpCheck = System.currentTimeMillis();
    }

    public long getCacheRefresh() {
        long result = (long)(Mth.clamp((float)Configs.Generic.SERVER_DATA_SYNC_CACHE_REFRESH.getFloatValue(), (float)0.05f, (float)1.0f) * 1000.0f);
        long clamp = this.getCacheTimeout() / 2L;
        return Math.min(result, clamp);
    }

    private long getCacheTimeout() {
        int modifier = FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue() ? 5 : 1;
        return (long)(Mth.clamp((float)(Configs.Generic.SERVER_DATA_SYNC_CACHE_TIMEOUT.getFloatValue() * (float)modifier), (float)0.25f, (float)15.0f) * 1000.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickCache(long nowTime) {
        Pair<Long, Pair<BlockEntity, CompoundTag>> pair;
        long timeout = this.getCacheTimeout();
        ConcurrentHashMap<Object, Object> concurrentHashMap = this.blockEntityCache;
        synchronized (concurrentHashMap) {
            for (BlockPos pos : this.blockEntityCache.keySet()) {
                pair = this.blockEntityCache.get(pos);
                if (nowTime - (Long)pair.getLeft() <= timeout && (Long)pair.getLeft() <= nowTime) continue;
                this.blockEntityCache.remove(pos);
            }
        }
        concurrentHashMap = this.entityCache;
        synchronized (concurrentHashMap) {
            for (Integer entityId : this.entityCache.keySet()) {
                pair = this.entityCache.get(entityId);
                if (nowTime - (Long)pair.getLeft() <= timeout && (Long)pair.getLeft() <= nowTime) continue;
                this.entityCache.remove(entityId);
            }
        }
    }

    @Nullable
    public CompoundTag getFromBlockEntityCacheNbt(BlockPos pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (CompoundTag)((Pair)this.blockEntityCache.get(pos).getRight()).getRight();
        }
        return null;
    }

    @Nullable
    public BlockEntity getFromBlockEntityCache(BlockPos pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (BlockEntity)((Pair)this.blockEntityCache.get(pos).getRight()).getLeft();
        }
        return null;
    }

    @Nullable
    public CompoundTag getFromEntityCacheNbt(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (CompoundTag)((Pair)this.entityCache.get(entityId).getRight()).getRight();
        }
        return null;
    }

    @Nullable
    public Entity getFromEntityCache(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (Entity)((Pair)this.entityCache.get(entityId).getRight()).getLeft();
        }
        return null;
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        this.hasInValidServux = false;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public boolean hasBackupStatus() {
        return FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue() && this.hasOpStatus;
    }

    public void setServuxVersion(String ver) {
        if (ver != null && !ver.isEmpty()) {
            this.servuxVersion = ver;
            Tweakeroo.debugLog("tweaksDataChannel: joining Servux version {}", ver);
        } else {
            this.servuxVersion = "unknown";
        }
    }

    public String getServuxVersion() {
        return this.servuxVersion;
    }

    public int getPendingBlockEntitiesCount() {
        return this.pendingBlockEntitiesQueue.size();
    }

    public int getPendingEntitiesCount() {
        return this.pendingEntitiesQueue.size();
    }

    public int getBlockEntityCacheCount() {
        return this.blockEntityCache.size();
    }

    public int getEntityCacheCount() {
        return this.entityCache.size();
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxTweaksPacket.Payload.ID, ServuxTweaksPacket.Payload.CODEC, 6);
    }

    public void onWorldPre() {
        if (!DataManager.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxTweaksPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
    }

    public void requestMetadata() {
        if (!DataManager.getInstance().hasIntegratedServer() && FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxTweaksPacket.MetadataRequest(nbt));
        }
    }

    public boolean receiveServuxMetadata(CompoundTag data) {
        if (!DataManager.getInstance().hasIntegratedServer()) {
            Tweakeroo.debugLog("tweaksDataChannel: received METADATA from Servux", new Object[0]);
            if (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
                if (data.getIntOr("version", -1) != 1) {
                    Tweakeroo.LOGGER.warn("tweaksDataChannel: Mis-matched protocol version!");
                }
                DataManager.getInstance().setHasServuxServer(true);
                this.setServuxVersion(data.getStringOr("servux", ""));
                this.setIsServuxServer();
                return true;
            }
        }
        return false;
    }

    public void onPacketFailure() {
        DataManager.getInstance().setHasServuxServer(false);
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    @Nullable
    public Pair<BlockEntity, CompoundTag> requestBlockEntity(Level world, BlockPos pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            if (!DataManager.getInstance().hasIntegratedServer() && (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue() || FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) && System.currentTimeMillis() - (Long)this.blockEntityCache.get(pos).getLeft() > this.getCacheRefresh()) {
                this.pendingBlockEntitiesQueue.add(pos);
            }
            if (world instanceof ServerLevel) {
                return this.refreshBlockEntityFromWorld(world, pos);
            }
            return (Pair)this.blockEntityCache.get(pos).getRight();
        }
        if (world.getBlockState(pos).getBlock() instanceof EntityBlock) {
            if (!DataManager.getInstance().hasIntegratedServer() && (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue() || FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue())) {
                this.pendingBlockEntitiesQueue.add(pos);
            }
            return this.refreshBlockEntityFromWorld((Level)this.getClientWorld(), pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<BlockEntity, CompoundTag> refreshBlockEntityFromWorld(Level world, BlockPos pos) {
        BlockEntity be;
        if (world != null && world.getBlockState(pos).hasBlockEntity() && (be = world.getChunkAt(pos).getBlockEntity(pos)) != null) {
            CompoundTag nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            Pair pair = Pair.of((Object)be, (Object)nbt);
            ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> concurrentHashMap = this.blockEntityCache;
            synchronized (concurrentHashMap) {
                this.blockEntityCache.put(pos, (Pair<Long, Pair<BlockEntity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)pair));
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public Pair<Entity, CompoundTag> requestEntity(Level world, int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            if (!DataManager.getInstance().hasIntegratedServer() && (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue() || FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) && System.currentTimeMillis() - (Long)this.entityCache.get(entityId).getLeft() > this.getCacheRefresh()) {
                this.pendingEntitiesQueue.add(entityId);
            }
            if (world instanceof ServerLevel) {
                return this.refreshEntityFromWorld(world, entityId);
            }
            return (Pair)this.entityCache.get(entityId).getRight();
        }
        if (!DataManager.getInstance().hasIntegratedServer() && (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue() || FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue())) {
            this.pendingEntitiesQueue.add(entityId);
        }
        return this.refreshEntityFromWorld((Level)this.getClientWorld(), entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<Entity, CompoundTag> refreshEntityFromWorld(Level world, int entityId) {
        if (world != null) {
            Entity entity = world.getEntity(entityId);
            CompoundTag nbt = new CompoundTag();
            if (entity != null && entity.saveAsPassenger(nbt)) {
                Pair pair = Pair.of((Object)entity, (Object)nbt);
                ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.entityCache;
                synchronized (concurrentHashMap) {
                    this.entityCache.put(entityId, (Pair<Long, Pair<Entity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)pair));
                }
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Container getBlockInventory(Level world, BlockPos pos, boolean useNbt) {
        if (this.blockEntityCache.containsKey(pos)) {
            Container inv = null;
            if (useNbt) {
                inv = InventoryUtils.getNbtInventory((CompoundTag)((CompoundTag)((Pair)this.blockEntityCache.get(pos).getRight()).getRight()), (int)-1, (HolderLookup.Provider)world.registryAccess());
            } else {
                BlockEntity be = (BlockEntity)((Pair)this.blockEntityCache.get(pos).getRight()).getLeft();
                BlockState state = world.getBlockState(pos);
                if (state.is(BlockTags.AIR) || !state.hasBlockEntity()) {
                    ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> concurrentHashMap = this.blockEntityCache;
                    synchronized (concurrentHashMap) {
                        this.blockEntityCache.remove(pos);
                    }
                    return null;
                }
                if (be instanceof Container) {
                    Container inv1 = (Container)be;
                    if (be instanceof ChestBlockEntity && state.hasProperty((Property)ChestBlock.TYPE)) {
                        ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
                        if (type != ChestType.SINGLE) {
                            BlockPos posAdj = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
                            if (!world.hasChunkAt(posAdj)) {
                                return null;
                            }
                            BlockState stateAdj = world.getBlockState(posAdj);
                            BlockEntity dataAdj = this.getFromBlockEntityCache(posAdj);
                            if (dataAdj == null) {
                                this.requestBlockEntity(world, posAdj);
                            }
                            if (stateAdj.getBlock() == state.getBlock() && dataAdj instanceof ChestBlockEntity) {
                                ChestBlockEntity inv2 = (ChestBlockEntity)dataAdj;
                                if (stateAdj.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && stateAdj.getValue((Property)ChestBlock.FACING) == state.getValue((Property)ChestBlock.FACING)) {
                                    Container invRight = type == ChestType.RIGHT ? inv1 : inv2;
                                    ChestBlockEntity invLeft = type == ChestType.RIGHT ? inv2 : inv1;
                                    inv = new CompoundContainer(invRight, (Container)invLeft);
                                }
                            }
                        } else {
                            inv = inv1;
                        }
                    } else {
                        inv = inv1;
                    }
                }
            }
            if (inv != null) {
                return inv;
            }
        }
        if (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue() || FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) {
            this.requestBlockEntity(world, pos);
        }
        return null;
    }

    @Nullable
    public Container getEntityInventory(Level world, int entityId, boolean useNbt) {
        if (this.entityCache.containsKey(entityId) && this.getWorld() != null) {
            Container inv = null;
            if (useNbt) {
                inv = InventoryUtils.getNbtInventory((CompoundTag)((CompoundTag)((Pair)this.entityCache.get(entityId).getRight()).getRight()), (int)-1, (HolderLookup.Provider)this.getWorld().registryAccess());
            } else {
                Entity entity = (Entity)((Pair)this.entityCache.get(entityId).getRight()).getLeft();
                if (entity instanceof Container) {
                    inv = (Container)entity;
                } else if (entity instanceof Player) {
                    Player player = (Player)entity;
                    inv = new SimpleContainer((ItemStack[])player.getInventory().getNonEquipmentItems().toArray((Object[])new ItemStack[36]));
                } else if (entity instanceof Villager) {
                    inv = ((Villager)entity).getInventory();
                } else if (entity instanceof AbstractHorse) {
                    inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
                } else if (entity instanceof Piglin) {
                    inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
                }
            }
            if (inv != null) {
                return inv;
            }
        }
        if (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue() || FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) {
            this.requestEntity(world, entityId);
        }
        return null;
    }

    private void requestQueryBlockEntity(BlockPos pos) {
        if (!FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        ClientPacketListener handler = this.getVanillaHandler();
        if (handler != null) {
            handler.getDebugQueryHandler().queryBlockEntityTag(pos, nbtCompound -> this.handleBlockEntityData(pos, (CompoundTag)nbtCompound, null));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.getDebugQueryHandler()).malilib_currentTransactionId(), (Either<BlockPos, Integer>)Either.left((Object)pos));
        }
    }

    private void requestQueryEntityData(int entityId) {
        if (!FeatureToggle.TWEAK_SERVER_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        ClientPacketListener handler = this.getVanillaHandler();
        if (handler != null) {
            handler.getDebugQueryHandler().queryEntityTag(entityId, nbtCompound -> this.handleEntityData(entityId, (CompoundTag)nbtCompound));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.getDebugQueryHandler()).malilib_currentTransactionId(), (Either<BlockPos, Integer>)Either.right((Object)entityId));
        }
    }

    private void requestServuxBlockEntityData(BlockPos pos) {
        if (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
            HANDLER.encodeClientData(ServuxTweaksPacket.BlockEntityRequest(pos));
        }
    }

    private void requestServuxEntityData(int entityId) {
        if (FeatureToggle.TWEAK_SERVER_DATA_SYNC.getBooleanValue()) {
            HANDLER.encodeClientData(ServuxTweaksPacket.EntityRequest(entityId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BlockEntity handleBlockEntityData(BlockPos pos, CompoundTag nbt, @Nullable ResourceLocation type) {
        BlockEntity blockEntity2;
        BlockEntityType beType;
        this.pendingBlockEntitiesQueue.remove(pos);
        if (nbt == null || this.getClientWorld() == null) {
            return null;
        }
        BlockEntity blockEntity = this.getClientWorld().getBlockEntity(pos);
        if (blockEntity != null && (type == null || type.equals((Object)BlockEntityType.getKey((BlockEntityType)blockEntity.getType())))) {
            Object id;
            if (!nbt.contains("id") && (id = BlockEntityType.getKey((BlockEntityType)blockEntity.getType())) != null) {
                nbt.putString("id", id.toString());
            }
            id = this.blockEntityCache;
            synchronized (id) {
                this.blockEntityCache.put(pos, (Pair<Long, Pair<BlockEntity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity, (Object)nbt)));
            }
            blockEntity.loadWithComponents(nbt, (HolderLookup.Provider)this.getClientWorld().registryAccess());
            return blockEntity;
        }
        Optional opt = BuiltInRegistries.BLOCK_ENTITY_TYPE.get(type);
        if (opt.isPresent() && (beType = (BlockEntityType)((Holder.Reference)opt.get()).value()).isValid(this.getClientWorld().getBlockState(pos)) && (blockEntity2 = beType.create(pos, this.getClientWorld().getBlockState(pos))) != null) {
            ResourceLocation id;
            if (!nbt.contains("id") && (id = BlockEntityType.getKey((BlockEntityType)beType)) != null) {
                nbt.putString("id", id.toString());
            }
            ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> concurrentHashMap = this.blockEntityCache;
            synchronized (concurrentHashMap) {
                this.blockEntityCache.put(pos, (Pair<Long, Pair<BlockEntity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity2, (Object)nbt)));
            }
            return blockEntity2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity handleEntityData(int entityId, CompoundTag nbt) {
        this.pendingEntitiesQueue.remove(entityId);
        if (nbt == null || this.getClientWorld() == null) {
            return null;
        }
        Entity entity = this.getClientWorld().getEntity(entityId);
        if (entity != null) {
            ResourceLocation id;
            if (!nbt.contains("id") && (id = EntityType.getKey((EntityType)entity.getType())) != null) {
                nbt.putString("id", id.toString());
            }
            ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.entityCache;
            synchronized (concurrentHashMap) {
                this.entityCache.put(entityId, (Pair<Long, Pair<Entity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)entity, (Object)nbt)));
            }
        }
        return entity;
    }

    public void handleBulkEntityData(int transactionId, CompoundTag nbt) {
    }

    public void handleVanillaQueryNbt(int transactionId, CompoundTag nbt) {
        Either<BlockPos, Integer> either;
        if (this.checkOpStatus) {
            this.hasOpStatus = true;
            this.checkOpStatus = false;
            this.lastOpCheck = System.currentTimeMillis();
        }
        if ((either = this.transactionToBlockPosOrEntityId.remove(transactionId)) != null) {
            either.ifLeft(pos -> this.handleBlockEntityData((BlockPos)pos, nbt, null)).ifRight(entityId -> this.handleEntityData((int)entityId, nbt));
        }
    }
}

