/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.render;

import com.mojang.blaze3d.platform.Window;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Window.class})
public abstract class MixinWindow {
    @Shadow
    public abstract int getScreenWidth();

    @Shadow
    public abstract int getScreenHeight();

    @Inject(method={"getGuiScale()D"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_customGuiScaleGetScale(CallbackInfoReturnable<Double> cir) {
        int scale;
        if (FeatureToggle.TWEAK_CUSTOM_INVENTORY_GUI_SCALE.getBooleanValue() && Minecraft.getInstance().screen instanceof AbstractContainerScreen && (scale = Configs.Generic.CUSTOM_INVENTORY_GUI_SCALE.getIntegerValue()) > 0) {
            cir.setReturnValue((Object)scale);
        }
    }

    @Inject(method={"getGuiScaledWidth()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_customGuiScaleGetWidth(CallbackInfoReturnable<Integer> cir) {
        int scale;
        if (FeatureToggle.TWEAK_CUSTOM_INVENTORY_GUI_SCALE.getBooleanValue() && Minecraft.getInstance().screen instanceof AbstractContainerScreen && (scale = Configs.Generic.CUSTOM_INVENTORY_GUI_SCALE.getIntegerValue()) > 0) {
            cir.setReturnValue((Object)((int)Math.ceil((double)this.getScreenWidth() / (double)scale)));
        }
    }

    @Inject(method={"getGuiScaledHeight()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_customGuiScaleGetHeight(CallbackInfoReturnable<Integer> cir) {
        int scale;
        if (FeatureToggle.TWEAK_CUSTOM_INVENTORY_GUI_SCALE.getBooleanValue() && Minecraft.getInstance().screen instanceof AbstractContainerScreen && (scale = Configs.Generic.CUSTOM_INVENTORY_GUI_SCALE.getIntegerValue()) > 0) {
            cir.setReturnValue((Object)((int)Math.ceil((double)this.getScreenHeight() / (double)scale)));
        }
    }
}

