/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import fi.dy.masa.tweakeroo.util.SnapAimUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderUtils {
    private static long lastRotationChangeTime;

    public static void renderHotbarSwapOverlay(Minecraft mc, GuiGraphics drawContext) {
        LocalPlayer player = mc.player;
        if (player != null && mc.screen == null) {
            int scaledWidth = GuiUtils.getScaledWindowWidth();
            int scaledHeight = GuiUtils.getScaledWindowHeight();
            int offX = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_X.getIntegerValue();
            int offY = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_Y.getIntegerValue();
            int startX = offX;
            int startY = offY;
            HudAlignment align = (HudAlignment)Configs.Generic.HOTBAR_SWAP_OVERLAY_ALIGNMENT.getOptionListValue();
            switch (align) {
                case TOP_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    break;
                }
                case BOTTOM_LEFT: {
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case BOTTOM_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case CENTER: {
                    startX = scaledWidth / 2 - offX - 81;
                    startY = scaledHeight / 2 - offY - 27;
                    break;
                }
            }
            int x = startX;
            int y = startY;
            Font textRenderer = mc.font;
            Matrix4f modelViewMatrix = new Matrix4f();
            modelViewMatrix.set((Matrix4fc)RenderSystem.getModelViewMatrix());
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((ResourceLocation)AbstractContainerScreen.INVENTORY_LOCATION, (int)(x - 1), (int)(y - 1), (int)7, (int)83, (int)162, (int)54, (GuiGraphics)drawContext);
            drawContext.drawString(textRenderer, "1", x - 10, y + 4, 0xFFFFFF);
            drawContext.drawString(textRenderer, "2", x - 10, y + 22, 0xFFFFFF);
            drawContext.drawString(textRenderer, "3", x - 10, y + 40, 0xFFFFFF);
            for (int row = 1; row <= 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    ItemStack stack = player.getInventory().getItem(row * 9 + column);
                    if (!stack.isEmpty()) {
                        InventoryOverlay.renderStackAt((ItemStack)stack, (float)x, (float)y, (float)1.0f, (Minecraft)mc, (GuiGraphics)drawContext);
                    }
                    x += 18;
                }
                y += 18;
                x = startX;
            }
            RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        }
    }

    public static void renderInventoryOverlay(InventoryOverlay.Context context, GuiGraphics drawContext) {
        Minecraft mc = Minecraft.getInstance();
        LivingEntity entityLivingBase = null;
        BlockEntity be = null;
        Container inv = null;
        CompoundTag nbt = new CompoundTag();
        if (context.be() != null) {
            be = context.be();
        } else if (context.entity() != null && context.entity() instanceof LivingEntity) {
            entityLivingBase = context.entity();
        }
        if (context.inv() != null) {
            inv = context.inv();
        }
        if (context.nbt() != null) {
            nbt.merge(context.nbt());
        }
        boolean isWolf = entityLivingBase instanceof Wolf;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.getContainerSize() > 0) {
            Block block;
            boolean isHorse = entityLivingBase instanceof AbstractHorse;
            int totalSlots = isHorse ? inv.getContainerSize() - 1 : inv.getContainerSize();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType((Container)inv, (CompoundTag)nbt, (InventoryOverlay.Context)context);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            Set lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (be != null && type == InventoryOverlay.InventoryRenderType.CRAFTER) {
                if (be instanceof CrafterBlockEntity) {
                    CrafterBlockEntity cbe = (CrafterBlockEntity)be;
                    lockedSlots = BlockUtils.getDisabledSlots((CrafterBlockEntity)cbe);
                } else if (context.nbt() != null) {
                    lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt((CompoundTag)context.nbt());
                }
            }
            if (context.be() != null && (block = context.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)block;
                fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)sbb, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
            if (isHorse) {
                SimpleContainer horseInv = new SimpleContainer(2);
                ItemStack horseArmor = ((AbstractHorse)entityLivingBase).getBodyArmorItem();
                horseInv.setItem(0, horseArmor != null && !horseArmor.isEmpty() ? horseArmor : ItemStack.EMPTY);
                horseInv.setItem(1, inv.getItem(0));
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (Minecraft)mc, (GuiGraphics)drawContext);
                InventoryOverlay.renderInventoryBackgroundSlots((InventoryOverlay.InventoryRenderType)type, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (GuiGraphics)drawContext);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (Minecraft)mc, (GuiGraphics)drawContext);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (Minecraft)mc, (GuiGraphics)drawContext);
                if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots((Container)inv, (int)xInv, (int)yInv, (GuiGraphics)drawContext);
                }
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, lockedSlots, (Minecraft)mc, (GuiGraphics)drawContext);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.HORSE;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            SimpleContainer wolfInv = new SimpleContainer(2);
            ItemStack wolfArmor = ((Wolf)entityLivingBase).getBodyArmorItem();
            wolfInv.setItem(0, wolfArmor != null && !wolfArmor.isEmpty() ? wolfArmor : ItemStack.EMPTY);
            InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (Minecraft)mc, (GuiGraphics)drawContext);
            InventoryOverlay.renderWolfArmorBackgroundSlots((Container)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (GuiGraphics)drawContext);
            InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (Minecraft)mc, (GuiGraphics)drawContext);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (LivingEntity)entityLivingBase, (GuiGraphics)drawContext);
            InventoryOverlay.renderEquipmentStacks((LivingEntity)entityLivingBase, (int)x, (int)y, (Minecraft)mc, (GuiGraphics)drawContext);
        }
    }

    public static void renderPlayerInventoryOverlay(Minecraft mc, GuiGraphics drawContext) {
        if (mc.player == null) {
            return;
        }
        Inventory inv = mc.player.getInventory();
        int x = GuiUtils.getScaledWindowWidth() / 2 - 88;
        int y = GuiUtils.getScaledWindowHeight() / 2 + 10;
        int slotOffsetX = 8;
        int slotOffsetY = 8;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (Minecraft)mc, (GuiGraphics)drawContext);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(x + slotOffsetX), (int)(y + slotOffsetY), (int)9, (int)9, (int)27, (Minecraft)mc, (GuiGraphics)drawContext);
    }

    public static void renderHotbarScrollOverlay(Minecraft mc, GuiGraphics drawContext) {
        if (mc.player == null) {
            return;
        }
        Inventory inv = mc.player.getInventory();
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 88;
        int y = yCenter + 6;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (Minecraft)mc, (GuiGraphics)drawContext);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)(y + 70), (int)9, (int)9, (Minecraft)mc, (GuiGraphics)drawContext);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(x + 8), (int)(y + 8), (int)9, (int)9, (int)27, (Minecraft)mc, (GuiGraphics)drawContext);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(x + 8), (int)(y + 78), (int)9, (int)0, (int)9, (Minecraft)mc, (GuiGraphics)drawContext);
        int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)(x + 5), (int)(y + currentRow * 18 + 5), (int)166, (int)22, (int)2, (int)-57312);
    }

    public static float getLavaFogDistance(Entity entity, float originalFog) {
        LivingEntity living;
        ItemStack head;
        if (entity instanceof LivingEntity && !(head = (living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.HEAD)).isEmpty()) {
            ItemEnchantments enchants = head.getEnchantments();
            float fog = originalFog > 1.0f ? 3.3f : 1.3f;
            int resp = 0;
            int aqua = 0;
            if (!enchants.equals((Object)ItemEnchantments.EMPTY)) {
                Set enchantList = enchants.keySet();
                for (Holder entry : enchantList) {
                    if (entry.is(Enchantments.AQUA_AFFINITY)) {
                        aqua = enchants.getLevel(entry);
                    }
                    if (!entry.is(Enchantments.RESPIRATION)) continue;
                    resp = enchants.getLevel(entry);
                }
            }
            if (aqua > 0) {
                fog *= 1.6f;
            }
            if (resp > 0) {
                fog *= (float)resp * 1.6f;
            }
            return Math.max(fog, originalFog);
        }
        return originalFog;
    }

    public static void renderDirectionsCursor(GuiGraphics drawContext) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        float width = (float)drawContext.guiWidth() / 2.0f;
        float height = (float)drawContext.guiHeight() / 2.0f;
        float pitch = camera.getXRot();
        float yaw = camera.getYRot();
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)drawContext.pose().last().pose());
        matrix4fStack.translate(width, height, 0.0f);
        matrix4fStack.rotateX(fi.dy.masa.malilib.render.RenderUtils.matrix4fRotateFix((float)(-pitch)));
        matrix4fStack.rotateY(fi.dy.masa.malilib.render.RenderUtils.matrix4fRotateFix((float)yaw));
        matrix4fStack.scale(-1.0f, -1.0f, -1.0f);
        mc.getDebugOverlay().render3dCrosshair();
        matrix4fStack.popMatrix();
    }

    public static void notifyRotationChanged() {
        lastRotationChangeTime = System.currentTimeMillis();
    }

    public static void renderSnapAimAngleIndicator(GuiGraphics drawContext) {
        long current = System.currentTimeMillis();
        if (current - lastRotationChangeTime < 750L) {
            Minecraft mc = Minecraft.getInstance();
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
            if (mode != SnapAimMode.PITCH) {
                RenderUtils.renderSnapAimAngleIndicatorYaw(xCenter, yCenter, 80, 12, mc, drawContext);
            }
            if (mode != SnapAimMode.YAW) {
                RenderUtils.renderSnapAimAngleIndicatorPitch(xCenter, yCenter, 12, 50, mc, drawContext);
            }
        }
    }

    private static void renderSnapAimAngleIndicatorYaw(int xCenter, int yCenter, int width, int height, Minecraft mc, GuiGraphics drawContext) {
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double realYaw = Mth.positiveModulo((double)SnapAimUtils.getLastRealYaw(), (double)360.0);
        double snappedYaw = SnapAimUtils.calculateSnappedAngle(realYaw, step);
        double startYaw = snappedYaw - step / 2.0;
        int x = xCenter - width / 2;
        int y = yCenter + 10;
        int lineX = x + (int)(Mth.wrapDegrees((double)(realYaw - startYaw)) / step * (double)width);
        Font textRenderer = mc.font;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        String str = Mth.wrapDegrees((double)snappedYaw) + "\u00b0";
        drawContext.drawString(textRenderer, str, xCenter - textRenderer.width(str) / 2, y + height + 2, -1, false);
        str = "<  " + Mth.wrapDegrees((double)(snappedYaw - step)) + "\u00b0";
        drawContext.drawString(textRenderer, str, x - textRenderer.width(str), y + height + 2, -1, false);
        str = Mth.wrapDegrees((double)(snappedYaw + step)) + "\u00b0  >";
        drawContext.drawString(textRenderer, str, x + width, y + height + 2, -1, false);
        if (Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue();
            int snapThreshOffset = (int)((double)width * threshold / step);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)(snapThreshOffset * 2), (int)height, (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter + snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
            }
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)lineX, (int)y, (int)2, (int)height, (int)-1);
    }

    private static void renderSnapAimAngleIndicatorPitch(int xCenter, int yCenter, int width, int height, Minecraft mc, GuiGraphics drawContext) {
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double realPitch = Mth.wrapDegrees((double)SnapAimUtils.getLastRealPitch());
        double snappedPitch = realPitch < 0.0 ? -SnapAimUtils.calculateSnappedAngle(-realPitch, step) : SnapAimUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = Mth.clamp((double)Mth.wrapDegrees((double)snappedPitch), (double)(-limit), (double)limit);
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        RenderUtils.renderPitchIndicator(x, y, width, height, realPitch, snappedPitch, step, true, mc, drawContext);
    }

    public static void renderPitchLockIndicator(Minecraft mc, GuiGraphics drawContext) {
        if (mc.player == null) {
            return;
        }
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int width = 12;
        int height = 50;
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        double currentPitch = mc.player.getXRot();
        double centerPitch = 0.0;
        double indicatorRange = 180.0;
        RenderUtils.renderPitchIndicator(x, y, width, height, currentPitch, centerPitch, indicatorRange, false, mc, drawContext);
    }

    private static void renderPitchIndicator(int x, int y, int width, int height, double currentPitch, double centerPitch, double indicatorRange, boolean isSnapRange, Minecraft mc, GuiGraphics drawContext) {
        double startPitch = centerPitch - indicatorRange / 2.0;
        double printedRange = isSnapRange ? indicatorRange : indicatorRange / 2.0;
        int lineY = y + (int)((Mth.wrapDegrees((double)currentPitch) - startPitch) / indicatorRange * (double)height);
        double angleUp = centerPitch - printedRange;
        double angleDown = centerPitch + printedRange;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font textRenderer = mc.font;
        if (isSnapRange) {
            String strUp = String.format("%6.1f\u00b0 ^", Mth.wrapDegrees((double)angleUp));
            String strDown = String.format("%6.1f\u00b0 v", Mth.wrapDegrees((double)angleDown));
            drawContext.drawString(textRenderer, strUp, x + width + 4, y - 4, -1, false);
            drawContext.drawString(textRenderer, strDown, x + width + 4, y + height - 4, -1, false);
            String str = String.format("%6.1f\u00b0", Mth.wrapDegrees((double)(isSnapRange ? centerPitch : currentPitch)));
            drawContext.drawString(textRenderer, str, x + width + 4, y + height / 2 - 4, -1, false);
        } else {
            String str = String.format("%4.1f\u00b0", Mth.wrapDegrees((double)(isSnapRange ? centerPitch : currentPitch)));
            drawContext.drawString(textRenderer, str, x + width + 4, lineY - 4, -1, false);
        }
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        int yCenter = y + height / 2 - 1;
        if (isSnapRange && Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue();
            int snapThreshOffset = (int)((double)height * threshold / indicatorRange);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)(snapThreshOffset * 2), (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)2, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter + snapThreshOffset), (int)width, (int)2, (int)-14614752);
            }
        } else if (!isSnapRange) {
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(x + 1), (int)(yCenter - 1), (int)(width - 2), (int)2, (int)-4144960);
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(lineY - 1), (int)width, (int)2, (int)-1);
    }
}

