/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.fog;

import fi.dy.masa.tweakeroo.config.Configs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FogRenderer.class})
public class MixinFogRenderer {
    @Redirect(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IFZ)Lorg/joml/Vector4f;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel$ClientLevelData;voidDarknessOnsetRange()F"))
    private float tweakeroo_disableSkyDarkness(ClientLevel.ClientLevelData instance) {
        return Configs.Disable.DISABLE_SKY_DARKNESS.getBooleanValue() ? 1.0f : instance.voidDarknessOnsetRange();
    }

    @ModifyConstant(method={"setupFog(Lnet/minecraft/client/Camera;IZLnet/minecraft/client/DeltaTracker;FLnet/minecraft/client/multiplayer/ClientLevel;)Lorg/joml/Vector4f;"}, constant={@Constant(intValue=16)})
    private int tweakeroo_tweakRenderDistanceFog_DistanceMultiplier(int constant) {
        if (Configs.Disable.DISABLE_RENDER_DISTANCE_FOG.getBooleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            int viewDistance = mc.options.getEffectiveRenderDistance();
            float blocksDistance = Math.max(512.0f, mc.gameRenderer.getRenderDistance());
            return (int)(blocksDistance / (float)viewDistance);
        }
        return constant;
    }

    @Redirect(method={"setupFog(Lnet/minecraft/client/Camera;IZLnet/minecraft/client/DeltaTracker;FLnet/minecraft/client/multiplayer/ClientLevel;)Lorg/joml/Vector4f;"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"))
    private float tweakeroo_tweakRenderDistanceFog_StartDiff(float value, float min, float max) {
        if (Configs.Disable.DISABLE_RENDER_DISTANCE_FOG.getBooleanValue()) {
            return min;
        }
        return Mth.clamp((float)value, (float)min, (float)max);
    }
}

