/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.fog;

import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.WaterFogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaterFogEnvironment.class})
public class MixinWaterFogModifier {
    @Inject(method={"setupFog(Lnet/minecraft/client/renderer/fog/FogData;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/client/multiplayer/ClientLevel;FLnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_redirectWaterFog(FogData data, Entity cameraEntity, BlockPos cameraPos, ClientLevel world, float viewDistance, DeltaTracker tickCounter, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_WATER_VISIBILITY.getBooleanValue()) {
            float adjusted;
            if (data.environmentalStart > 0.0f) {
                data.environmentalStart = -8.0f;
            }
            if (data.environmentalEnd != (adjusted = RenderUtils.calculateLiquidFogDistance(cameraEntity, data.environmentalEnd, true))) {
                data.environmentalEnd = adjusted;
            }
        }
    }
}

