/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.render;

import fi.dy.masa.tweakeroo.config.Callbacks;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class}, priority=1001)
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private float realYaw;
    @Unique
    private float realPitch;

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_onRenderWorld(CallbackInfo ci) {
        if (Callbacks.skipWorldRendering) {
            ci.cancel();
        }
    }

    @Inject(method={"getFov(Lnet/minecraft/client/Camera;FZ)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_applyZoom(Camera camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Float> cir) {
        if (MiscUtils.isZoomActive()) {
            cir.setReturnValue((Object)Float.valueOf((float)Configs.Generic.ZOOM_FOV.getDoubleValue()));
        }
    }

    @ModifyArg(method={"pick(Lnet/minecraft/world/entity/Entity;DDF)Lnet/minecraft/world/phys/HitResult;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"))
    private Predicate<Entity> tweakeroo_overrideTargetedEntityCheck(Predicate<Entity> predicate) {
        if (Configs.Disable.DISABLE_DEAD_MOB_TARGETING.getBooleanValue()) {
            predicate = predicate.and(entityIn -> !(entityIn instanceof LivingEntity) || ((LivingEntity)entityIn).getHealth() > 0.0f);
        }
        if (FeatureToggle.TWEAK_HANGABLE_ENTITY_BYPASS.getBooleanValue() && this.minecraft.player != null && this.minecraft.player.isShiftKeyDown() == Configs.Generic.HANGABLE_ENTITY_BYPASS_INVERSE.getBooleanValue()) {
            predicate = predicate.and(entityIn -> !(entityIn instanceof HangingEntity));
        }
        return predicate;
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/renderer/GameRenderer;pick(F)V")})
    private void tweakeroo_overrideRenderViewEntityPre(CallbackInfo ci) {
        Entity entity;
        if (FeatureToggle.TWEAK_ELYTRA_CAMERA.getBooleanValue() && Hotkeys.ELYTRA_CAMERA.getKeybind().isKeybindHeld() && (entity = this.minecraft.getCameraEntity()) != null) {
            this.realYaw = entity.getYRot();
            this.realPitch = entity.getXRot();
            MiscUtils.setEntityRotations(entity, CameraUtils.getCameraYaw(), CameraUtils.getCameraPitch());
        }
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="RETURN")})
    private void tweakeroo_overrideRenderViewEntityPost(CallbackInfo ci) {
        Entity entity;
        if (FeatureToggle.TWEAK_ELYTRA_CAMERA.getBooleanValue() && Hotkeys.ELYTRA_CAMERA.getKeybind().isKeybindHeld() && (entity = this.minecraft.getCameraEntity()) != null) {
            MiscUtils.setEntityRotations(entity, this.realYaw, this.realPitch);
        }
    }
}

