/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.render;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class}, priority=1001)
public abstract class MixinWorldRenderer {
    @Inject(method={"tickParticles(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_cancelWeatherParticlesAndSounds(Camera camera, CallbackInfo ci) {
        if (Configs.Disable.DISABLE_RAIN_EFFECTS.getBooleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_spawnParticleInject(ParticleOptions parameters, boolean alwaysSpawn, boolean canSpawnOnMinimal, double x, double y, double z, double velocityX, double velocityY, double velocityZ, CallbackInfoReturnable<Particle> ci) {
        if (Configs.Generic.SELECTIVE_BLOCKS_HIDE_PARTICLES.getBooleanValue() && !RenderTweaks.isPositionValidForRendering(BlockPos.containing((double)x, (double)y, (double)z))) {
            ci.setReturnValue(null);
            ci.cancel();
        }
    }
}

