/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.InfestedBlock;

public class CreativeExtraItems {
    private static final ArrayListMultimap<CreativeModeTab, ItemStack> ADDED_ITEMS = ArrayListMultimap.create();
    private static final HashMap<Item, CreativeModeTab> OVERRIDDEN_GROUPS = new HashMap();

    @Nullable
    public static CreativeModeTab getGroupFor(Item item) {
        return OVERRIDDEN_GROUPS.get(item);
    }

    public static List<ItemStack> getExtraStacksForGroup(CreativeModeTab group) {
        return ADDED_ITEMS.get((Object)group);
    }

    public static void setCreativeExtraItems(List<String> items) {
        for (CreativeModeTab group : CreativeModeTabs.allTabs()) {
            TranslatableContents translatableTextContent;
            ComponentContents content = group.getDisplayName().getContents();
            if (!(content instanceof TranslatableContents) || !(translatableTextContent = (TranslatableContents)content).getKey().equals("itemGroup.op")) continue;
            CreativeExtraItems.setCreativeExtraItems(group, items);
            break;
        }
    }

    private static void setCreativeExtraItems(CreativeModeTab group, List<String> items) {
        ADDED_ITEMS.clear();
        OVERRIDDEN_GROUPS.clear();
        if (items.isEmpty()) {
            return;
        }
        Tweakeroo.LOGGER.info("Adding extra items to creative inventory group '{}'", (Object)group.getDisplayName().getString());
        for (String str : items) {
            ItemStack stack = InventoryUtils.getItemStackFromString((String)str);
            if (stack == null || stack.isEmpty()) continue;
            if (!stack.getComponents().isEmpty()) {
                ADDED_ITEMS.put((Object)group, (Object)stack);
                continue;
            }
            OVERRIDDEN_GROUPS.put(stack.getItem(), group);
        }
    }

    public static void removeInfestedBlocks(NonNullList<ItemStack> stacks) {
        stacks.removeIf(stack -> stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof InfestedBlock);
    }
}

