/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum EasyPlacementProtocol implements IConfigOptionListEntry
{
    AUTO("auto", "tweakeroo.gui.label.easy_place_protocol.auto"),
    V3("v3", "tweakeroo.gui.label.easy_place_protocol.v3"),
    V2("v2", "tweakeroo.gui.label.easy_place_protocol.v2"),
    SLAB_ONLY("slabs_only", "tweakeroo.gui.label.easy_place_protocol.slabs_only"),
    NONE("none", "tweakeroo.gui.label.easy_place_protocol.none");

    public static final ImmutableList<EasyPlacementProtocol> VALUES;
    private final String configString;
    private final String translationKey;

    private EasyPlacementProtocol(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    public String getStringValue() {
        return this.configString;
    }

    public String getDisplayName() {
        return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
    }

    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= EasyPlacementProtocol.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = EasyPlacementProtocol.values().length - 1;
        }
        return EasyPlacementProtocol.values()[id % EasyPlacementProtocol.values().length];
    }

    public EasyPlacementProtocol fromString(String name) {
        return EasyPlacementProtocol.fromStringStatic(name);
    }

    public static EasyPlacementProtocol fromStringStatic(String name) {
        for (EasyPlacementProtocol val : VALUES) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return val;
        }
        return AUTO;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])EasyPlacementProtocol.values());
    }
}

