/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class SnapAimUtils {
    private static double lastRealPitch;
    private static double lastRealYaw;
    private static double lastSnapYaw;
    private static double lastSnapPitch;

    public static double getLastRealPitch() {
        return lastRealPitch;
    }

    public static double getLastRealYaw() {
        return lastRealYaw;
    }

    public static void onUpdateVelocity(Entity entity, float yawIn, float speedIn, Vec3 motion, CallbackInfo ci) {
        double speed = motion.lengthSqr();
        if (speed >= 1.0E-7) {
            motion = (speed > 1.0 ? motion.normalize() : motion).scale((double)speedIn);
            double xFactor = Math.sin((double)yawIn * Math.PI / 180.0);
            double zFactor = Math.cos((double)yawIn * Math.PI / 180.0);
            Vec3 change = new Vec3(motion.x * zFactor - motion.z * xFactor, motion.y, motion.z * zFactor + motion.x * xFactor);
            entity.setDeltaMovement(entity.getDeltaMovement().add(change));
        }
        ci.cancel();
    }

    public static float getSnappedPitch(double realPitch) {
        if (Configs.Generic.SNAP_AIM_MODE.getOptionListValue() != SnapAimMode.YAW) {
            if (FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue()) {
                return (float)lastSnapPitch;
            }
            if (lastRealPitch != realPitch) {
                lastRealPitch = realPitch;
                RenderUtils.notifyRotationChanged();
            }
            double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
            int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
            double newSnapPitch = realPitch < 0.0 ? -SnapAimUtils.calculateSnappedAngle(-realPitch, step) : SnapAimUtils.calculateSnappedAngle(realPitch, step);
            double offset = Math.abs(Mth.wrapDegrees((float)((float)(newSnapPitch - realPitch))));
            if (!Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue() || offset <= Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue()) {
                if (lastSnapPitch != (newSnapPitch = Mth.clamp((double)Mth.wrapDegrees((double)newSnapPitch), (double)(-limit), (double)limit))) {
                    String g = GuiBase.TXT_GREEN;
                    String r = GuiBase.TXT_RST;
                    String str = String.format("%s%s%s (step %s%s%s)", g, Mth.wrapDegrees((double)newSnapPitch), r, g, step, r);
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.snapped_to_pitch", (Object[])new Object[]{str});
                    lastSnapPitch = newSnapPitch;
                }
                return Mth.wrapDegrees((float)((float)newSnapPitch));
            }
        }
        lastSnapPitch = realPitch;
        return (float)realPitch;
    }

    public static float getSnappedYaw(double realYaw) {
        if (Configs.Generic.SNAP_AIM_MODE.getOptionListValue() != SnapAimMode.PITCH) {
            if (FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue()) {
                return (float)lastSnapYaw;
            }
            if (lastRealYaw != realYaw) {
                lastRealYaw = realYaw;
                RenderUtils.notifyRotationChanged();
            }
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double newSnapYaw = SnapAimUtils.calculateSnappedAngle(realYaw, step);
            if (!Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue() || (double)Math.abs(Mth.wrapDegrees((float)((float)(newSnapYaw - realYaw)))) <= Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue()) {
                if (lastSnapYaw != newSnapYaw) {
                    String g = GuiBase.TXT_GREEN;
                    String r = GuiBase.TXT_RST;
                    String str = String.format("%s%s%s (step %s%s%s)", g, Mth.wrapDegrees((double)newSnapYaw), r, g, step, r);
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.snapped_to_yaw", (Object[])new Object[]{str});
                    lastSnapYaw = newSnapYaw;
                }
                return Mth.wrapDegrees((float)((float)newSnapYaw));
            }
        }
        lastSnapYaw = realYaw;
        return (float)realYaw;
    }

    public static double calculateSnappedAngle(double realRotation, double step) {
        double offsetRealRotation = Mth.positiveModulo((double)realRotation, (double)360.0) + step / 2.0;
        return Mth.positiveModulo((double)((double)((int)(offsetRealRotation / step)) * step), (double)360.0);
    }
}

