/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.block.entity.custom;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.dented.personalreader.block.custom.NarratorBlock;
import net.dented.personalreader.block.entity.ModBlockEntities;
import net.dented.personalreader.block.narrator.NarrationEntry;
import net.dented.personalreader.block.narrator.NarratorManager;
import net.dented.personalreader.config.Config;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1843;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8181;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class NarratorBlockEntity
extends class_2586
implements class_8181.class_9210 {
    public static final String BOOK_ITEM_NBT_KEY = "BookItem";
    private class_1799 bookStack = class_1799.field_8037;
    @Nullable
    private NarrationEntry narration;
    private final NarratorManager manager;
    private final Set<UUID> playersInRange = new HashSet<UUID>();
    private int persistedCurrentPhraseIndex = 0;
    private boolean pendingRestore = false;

    public NarratorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.NARRATOR_BE, pos, state);
        this.manager = new NarratorManager(pos);
    }

    public NarratorManager getManager() {
        return this.manager;
    }

    private void onBookStackChanged(boolean hasBook) {
        class_1937 class_19372;
        if (this.field_11863 != null && this.field_11863.method_8320(this.method_11016()) == this.method_11010()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)NarratorBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasBook)), 2);
            this.field_11863.method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8408(this.field_11867, this.method_11010().method_26204());
            serverWorld.method_8455(this.field_11867, this.method_11010().method_26204());
        }
    }

    public void dropBook() {
        class_1799 stack;
        if (this.field_11863 != null && !this.field_11863.method_8608() && !(stack = this.method_54079()).method_7960()) {
            this.method_54077(class_1799.field_8037);
            class_243 vec = class_243.method_24953((class_2382)this.field_11867).method_1031(this.field_11863.field_9229.method_43058() * 0.7 - 0.35, 1.0, this.field_11863.field_9229.method_43058() * 0.7 - 0.35);
            class_1542 entity = new class_1542(this.field_11863, vec.field_1352, vec.field_1351, vec.field_1350, stack.method_7972());
            entity.method_6988();
            this.field_11863.method_8649((class_1297)entity);
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, NarratorBlockEntity be) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (be.pendingRestore) {
            if (!be.bookStack.method_7960() && be.narration != null) {
                be.manager.restoreState(be.narration, be.persistedCurrentPhraseIndex, (class_1937)serverWorld);
            }
            be.pendingRestore = false;
        }
        HashSet<UUID> currentPlayers = new HashSet<UUID>();
        for (class_3222 player : serverWorld.method_18456()) {
            boolean inRange = player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= (double)(Config.narratorBlockNarrationRange * Config.narratorBlockNarrationRange);
            if (!inRange) continue;
            currentPlayers.add(player.method_5667());
            if (be.playersInRange.contains(player.method_5667())) continue;
            be.manager.addListener(player);
            if (be.playersInRange.contains(player.method_5667())) continue;
            be.manager.addListener(player);
        }
        for (UUID uuid : be.playersInRange) {
            class_1657 player;
            if (currentPlayers.contains(uuid) || !((player = serverWorld.method_18470(uuid)) instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            be.manager.removeListener(serverPlayer);
        }
        be.playersInRange.clear();
        be.playersInRange.addAll(currentPlayers);
        be.manager.tick(serverWorld);
        be.updatePersistedIndex();
    }

    public class_1799 method_54079() {
        return this.bookStack;
    }

    public class_1799 method_54078(int count) {
        class_1799 stack = this.bookStack;
        this.method_54077(class_1799.field_8037);
        return stack;
    }

    public void method_54077(class_1799 stack) {
        this.bookStack = stack;
        boolean hasBook = !stack.method_7960();
        this.onBookStackChanged(hasBook);
        this.narration = NarrationEntry.fromStack(stack);
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            class_3218 serverWorld = (class_3218)this.field_11863;
            if (hasBook && this.narration != null) {
                this.manager.startNarration(this.narration.lines(), serverWorld);
                serverWorld.method_8408(this.field_11867, this.method_11010().method_26204());
            } else {
                this.manager.stopNarration();
            }
            serverWorld.method_8455(this.field_11867, this.method_11010().method_26204());
            serverWorld.method_8408(this.field_11867, this.method_11010().method_26204());
        }
    }

    public int method_5444() {
        return 1;
    }

    public class_2586 method_54080() {
        return this;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return stack.method_7909() instanceof class_1843 && this.method_5438(slot).method_7960();
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        this.dropBook();
        if (!this.field_11863.method_8608()) {
            this.manager.stopNarration();
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_8455(pos, this.method_11010().method_26204());
                serverWorld.method_8408(pos, this.method_11010().method_26204());
            }
        }
        super.method_66473(pos, oldState);
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        return !this.manager.isPlaying();
    }

    public int getComparatorOutput() {
        if (this.bookStack.method_7960() || !(this.bookStack.method_7909() instanceof class_1843)) {
            return 0;
        }
        int pageCount = ((class_9302)this.bookStack.method_57353().method_58695(class_9334.field_49606, (Object)class_9302.field_49829)).comp_2422().size();
        return class_3532.method_15340((int)pageCount, (int)1, (int)15);
    }

    public int getRedstonePower() {
        return this.manager.isPlaying() ? 15 : 0;
    }

    public void onNarrationStarted() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8408(this.field_11867, this.method_11010().method_26204());
            serverWorld.method_8455(this.field_11867, this.method_11010().method_26204());
        }
    }

    public void onNarrationFinished() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8455(this.field_11867, this.method_11010().method_26204());
            serverWorld.method_8408(this.field_11867, this.method_11010().method_26204());
        }
    }

    private void updatePersistedIndex() {
        int currentIndex;
        if (this.manager.isPlaying() && this.manager.getInstance() != null && (currentIndex = this.manager.getInstance().getCurrentPhraseIndex()) != this.persistedCurrentPhraseIndex) {
            this.persistedCurrentPhraseIndex = currentIndex;
            this.method_5431();
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.bookStack.method_7960()) {
            view.method_71468(BOOK_ITEM_NBT_KEY, class_1799.field_24671, (Object)this.bookStack);
        }
        view.method_71465("CurrentPhraseIndex", this.persistedCurrentPhraseIndex);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.bookStack = view.method_71426(BOOK_ITEM_NBT_KEY, class_1799.field_24671).orElse(class_1799.field_8037);
        this.narration = NarrationEntry.fromStack(this.bookStack);
        this.persistedCurrentPhraseIndex = view.method_71424("CurrentPhraseIndex", 0);
        if (!this.bookStack.method_7960() && this.narration != null) {
            this.pendingRestore = true;
        }
    }
}

