/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.block.narrator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.dented.personalreader.network.NarratorBlockPhraseS2CPacket;
import net.dented.personalreader.network.NarratorBlockStopS2CPacket;
import net.dented.personalreader.sound.ClientNarratorBlockNarratorInstance;
import net.minecraft.class_2338;

public class ClientNarratorBlockManager {
    private static final Map<UUID, ClientNarratorBlockNarratorInstance> activeNarrators = new ConcurrentHashMap<UUID, ClientNarratorBlockNarratorInstance>();

    public static void handlePhrasePacket(NarratorBlockPhraseS2CPacket packet) {
        UUID uuid = packet.uuid();
        class_2338 pos = packet.pos();
        String phrase = packet.phrase();
        ClientNarratorBlockNarratorInstance narrator = activeNarrators.computeIfAbsent(uuid, id -> new ClientNarratorBlockNarratorInstance((UUID)id, pos));
        narrator.addPhrase(phrase);
    }

    public static void handleStopPacket(NarratorBlockStopS2CPacket packet) {
        UUID uuid = packet.uuid();
        ClientNarratorBlockNarratorInstance narrator = activeNarrators.remove(uuid);
        if (narrator != null) {
            narrator.stopImmediate();
        }
    }

    public static void stopAll() {
        for (ClientNarratorBlockNarratorInstance narrator : activeNarrators.values()) {
            narrator.stopImmediate();
        }
        activeNarrators.clear();
    }
}

