/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.block.narrator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.dented.personalreader.block.custom.NarratorBlock;
import net.dented.personalreader.block.entity.custom.NarratorBlockEntity;
import net.dented.personalreader.config.Config;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public record NarrationEntry(List<String> lines) {
    public static final Codec<NarrationEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("lines").forGetter(NarrationEntry::lines)).apply((Applicative)instance, NarrationEntry::new));
    public static final class_9139<class_9129, NarrationEntry> PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.field_48554.method_56433(class_9135.method_56363()), NarrationEntry::lines, NarrationEntry::new);

    @Nullable
    public static NarrationEntry fromStack(class_1799 stack) {
        class_9302 book = (class_9302)stack.method_58695(class_9334.field_49606, null);
        if (book == null || book.comp_2422().isEmpty()) {
            return null;
        }
        ArrayList<String> phrases = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int MAX_CHARS = Config.narrationPhraseMaxCharacterLength;
        for (class_9262 page : book.comp_2422()) {
            String pageText = NarrationEntry.stripFormatting(((class_2561)page.method_57140(false)).getString()).trim();
            if (pageText.isEmpty()) continue;
            String[] lines = pageText.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String[] parts;
                String line = lines[i].trim();
                if (line.isEmpty()) continue;
                for (String part : parts = line.split("(?<=[.!?;:])|(?<=,)")) {
                    String chunk = part.trim();
                    if (chunk.isEmpty()) continue;
                    if (current.length() + chunk.length() > MAX_CHARS) {
                        phrases.add(current.toString().trim());
                        current.setLength(0);
                    }
                    current.append(chunk).append(" ");
                    if (chunk.matches(".*[.!?;:]$")) {
                        phrases.add(current.toString().trim());
                        current.setLength(0);
                        continue;
                    }
                    if (!chunk.endsWith(",") || current.length() <= MAX_CHARS / 2) continue;
                    phrases.add(current.toString().trim());
                    current.setLength(0);
                }
                if (i >= lines.length - 1 || current.length() <= 0) continue;
                phrases.add(current.toString().trim());
                current.setLength(0);
            }
            current.append(" ");
        }
        if (current.length() > 0) {
            phrases.add(current.toString().trim());
        }
        return phrases.isEmpty() ? null : new NarrationEntry(phrases);
    }

    private static String stripFormatting(String text) {
        return text.replaceAll("\u00a7[0-9A-FK-ORa-fk-or]", "");
    }

    public static class_1269 tryReadStack(class_1937 world, class_2338 pos, class_1799 stack, class_1657 player) {
        Optional<NarrationEntry> entry = Optional.ofNullable(NarrationEntry.fromStack(stack));
        if (entry.isEmpty()) {
            return class_1269.field_52423;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof NarratorBlock && !((Boolean)state.method_11654((class_2769)NarratorBlock.HAS_RECORD)).booleanValue()) {
            if (!world.method_8608()) {
                class_1799 taken = stack.method_60504(1, (class_1309)player);
                class_2586 be = world.method_8321(pos);
                if (be instanceof NarratorBlockEntity) {
                    NarratorBlockEntity narrator = (NarratorBlockEntity)be;
                    narrator.method_54077(taken);
                    world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }
}

