/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.block.narrator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.dented.personalreader.block.entity.custom.NarratorBlockEntity;
import net.dented.personalreader.block.narrator.NarrationEntry;
import net.dented.personalreader.config.Config;
import net.dented.personalreader.network.NarratorBlockPhraseS2CPacket;
import net.dented.personalreader.network.NarratorBlockStopS2CPacket;
import net.dented.personalreader.sound.ServerNarratorBlockNarratorInstance;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class NarratorManager {
    private final UUID uuid;
    private final class_2338 pos;
    private final Set<class_3222> listeners = new HashSet<class_3222>();
    private ServerNarratorBlockNarratorInstance instance;

    public NarratorManager(class_2338 pos) {
        this.pos = pos;
        this.uuid = NarratorManager.getPersistentBlockUUID(pos);
    }

    public ServerNarratorBlockNarratorInstance getInstance() {
        return this.instance;
    }

    public void startNarration(List<String> phrases, class_3218 world) {
        this.stopNarration();
        for (class_3222 player : world.method_18456()) {
            if (!(player.method_5649((double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5) <= (double)(Config.narratorBlockNarrationRange * Config.narratorBlockNarrationRange))) continue;
            this.addListener(player);
        }
        this.instance = new ServerNarratorBlockNarratorInstance(this.uuid, this.pos, phrases, phrase -> this.sendPhraseToPlayers((String)phrase), this::sendStopToPlayers);
        this.instance.play();
    }

    public void stopNarration() {
        if (this.instance != null) {
            this.instance.stop();
            this.sendStopToPlayers();
            this.instance = null;
        }
    }

    public void addListener(class_3222 player) {
        this.listeners.add(player);
    }

    public void removeListener(class_3222 player) {
        this.listeners.remove(player);
        this.sendStopToPlayer(player);
    }

    public void restoreState(@Nullable NarrationEntry narration, int index, class_1937 world) {
        if (narration == null || narration.lines().isEmpty()) {
            return;
        }
        this.stopNarration();
        this.instance = new ServerNarratorBlockNarratorInstance(this.uuid, this.pos, narration.lines(), phrase -> this.sendPhraseToPlayers((String)phrase), this::sendStopToPlayers);
        this.instance.play(index);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (class_3222 player : serverWorld.method_18456()) {
                if (!(player.method_5649((double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5) <= (double)(Config.narratorBlockNarrationRange * Config.narratorBlockNarrationRange))) continue;
                this.addListener(player);
            }
        }
    }

    private void sendPhraseToPlayers(String phrase) {
        if (this.instance == null) {
            return;
        }
        int idx = this.instance.getCurrentPhraseIndex();
        NarratorBlockPhraseS2CPacket packet = new NarratorBlockPhraseS2CPacket(this.uuid, this.pos, idx, phrase);
        for (class_3222 player : this.listeners) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    private void sendStopToPlayers() {
        NarratorBlockStopS2CPacket packet = new NarratorBlockStopS2CPacket(this.uuid, this.pos);
        for (class_3222 player : this.listeners) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    private void sendStopToPlayer(class_3222 player) {
        NarratorBlockStopS2CPacket packet = new NarratorBlockStopS2CPacket(this.uuid, this.pos);
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    public void tick(class_3218 world) {
        if (this.instance != null && !this.instance.isPlaying()) {
            class_2586 be = world.method_8321(this.pos);
            if (be instanceof NarratorBlockEntity) {
                NarratorBlockEntity narrator = (NarratorBlockEntity)be;
                narrator.onNarrationFinished();
            }
            this.instance = null;
        } else if (this.instance != null && this.hasSecondPassed(world)) {
            NarratorManager.spawnNoteParticles((class_1936)world, this.pos);
        }
    }

    public boolean isPlaying() {
        return this.instance != null && this.instance.isPlaying();
    }

    private boolean hasSecondPassed(class_3218 world) {
        return world.method_8510() % 20L == 0L;
    }

    private static void spawnNoteParticles(class_1936 world, class_2338 pos) {
        class_243[] positions;
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_5819 random = world.method_8409();
        float note = random.method_43057();
        double spread = 0.05;
        double cx = (double)pos.method_10263() + 0.5;
        double cy = (double)pos.method_10264() + 0.5;
        double cz = (double)pos.method_10260() + 0.5;
        double offset = 0.65;
        for (class_243 p : positions = new class_243[]{new class_243(cx + offset, cy, cz), new class_243(cx - offset, cy, cz), new class_243(cx, cy, cz + offset), new class_243(cx, cy, cz - offset)}) {
            serverWorld.method_65096((class_2394)class_2398.field_11224, p.field_1352, p.field_1351, p.field_1350, 1, spread, spread, spread, (double)note);
        }
    }

    public static UUID getPersistentBlockUUID(class_2338 pos) {
        long least = ((long)pos.method_10263() & 0xFFFFFFFFL) << 32 | (long)pos.method_10260() & 0xFFFFFFFFL;
        long most = (long)pos.method_10264() & 0xFFFFFFFFL;
        return new UUID(most, least);
    }
}

