/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static int narratorBlockNarrationRange = 64;
    public static int narrationPhraseMaxCharacterLength = 200;
    public static int narrationPhraseMinimumDurationMilliseconds = 1500;
    public static int narrationPhraseSpaceDurationMilliseconds = 20;
    public static int narrationPhrasePausePunctuationDurationMilliseconds = 800;
    public static int narrationPhraseEndPunctuationDurationMilliseconds = 1000;
    public static int narrationPhraseOtherCharacterDurationMilliseconds = 80;
    public static int narrationPhraseNewLineDurationMilliseconds = 1000;
    public static String internalNarrationPhraseNewLineString = "\u00a7";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("personalreader.json");
    private static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static void load() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Config.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            narratorBlockNarrationRange = Config.getInt(json, "narratorBlockNarrationRange", 64);
            narrationPhraseMaxCharacterLength = Config.getInt(json, "narrationPhraseMaxCharacterLength", 200);
            narrationPhraseMinimumDurationMilliseconds = Config.getInt(json, "narrationPhraseMinimumDurationMilliseconds", 1500);
            narrationPhraseSpaceDurationMilliseconds = Config.getInt(json, "narrationPhraseSpaceDurationMilliseconds", 20);
            narrationPhrasePausePunctuationDurationMilliseconds = Config.getInt(json, "narrationPhrasePausePunctuationDurationMilliseconds", 800);
            narrationPhraseEndPunctuationDurationMilliseconds = Config.getInt(json, "narrationPhraseEndPunctuationDurationMilliseconds", 1000);
            narrationPhraseOtherCharacterDurationMilliseconds = Config.getInt(json, "narrationPhraseOtherCharacterDurationMilliseconds", 80);
            narrationPhraseNewLineDurationMilliseconds = Config.getInt(json, "narrationPhraseNewLineDurationMilliseconds", 1000);
            internalNarrationPhraseNewLineString = Config.getString(json, "internalNarrationPhraseNewLineString", "\u00a7");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        JsonObject json = new JsonObject();
        json.addProperty("narratorBlockNarrationRange", (Number)narratorBlockNarrationRange);
        json.addProperty("narrationPhraseMaxCharacterLength", (Number)narrationPhraseMaxCharacterLength);
        json.addProperty("narrationPhraseMinimumDurationMilliseconds", (Number)narrationPhraseMinimumDurationMilliseconds);
        json.addProperty("narrationPhraseSpaceDurationMilliseconds", (Number)narrationPhraseSpaceDurationMilliseconds);
        json.addProperty("narrationPhrasePausePunctuationDurationMilliseconds", (Number)narrationPhrasePausePunctuationDurationMilliseconds);
        json.addProperty("narrationPhraseEndPunctuationDurationMilliseconds", (Number)narrationPhraseEndPunctuationDurationMilliseconds);
        json.addProperty("narrationPhraseOtherCharacterDurationMilliseconds", (Number)narrationPhraseOtherCharacterDurationMilliseconds);
        json.addProperty("narrationPhraseNewLineDurationMilliseconds", (Number)narrationPhraseNewLineDurationMilliseconds);
        json.addProperty("internalNarrationPhraseNewLineString", internalNarrationPhraseNewLineString);
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int getInt(JsonObject obj, String key, int def) {
        return obj.has(key) ? obj.get(key).getAsInt() : def;
    }

    private static String getString(JsonObject obj, String key, String def) {
        return obj.has(key) ? obj.get(key).getAsString() : def;
    }
}

