/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.sound;

import com.mojang.text2speech.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3419;

public class ClientNarratorBlockNarratorInstance {
    private final UUID uuid;
    private final class_2338 pos;
    private final ExecutorService executor;
    private Process ttsProcess;
    private List<String> phrases = List.of();
    private int currentPhraseIndex = 0;
    private boolean playing = false;

    public ClientNarratorBlockNarratorInstance(UUID uuid, class_2338 pos) {
        this.uuid = uuid;
        this.pos = pos;
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "ClientNarrator-" + String.valueOf(uuid));
            t.setDaemon(true);
            return t;
        });
    }

    private float getEffectiveVolume() {
        return class_310.method_1551().field_1690.method_71978(class_3419.field_15246);
    }

    public void setPhrases(List<String> phrases) {
        this.stopImmediate();
        this.phrases = new ArrayList<String>(phrases);
        this.currentPhraseIndex = 0;
    }

    public void play() {
        if (this.phrases.isEmpty() || this.currentPhraseIndex >= this.phrases.size()) {
            return;
        }
        this.playing = true;
        this.speakNextPhrase();
    }

    public void stopImmediate() {
        this.playing = false;
        this.currentPhraseIndex = 0;
        this.stopProcess();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public synchronized void addPhrase(String phrase) {
        if (this.phrases.isEmpty()) {
            this.phrases = new ArrayList<String>();
        }
        this.phrases.add(phrase);
        if (!this.playing) {
            this.play();
        }
    }

    private void speakNextPhrase() {
        if (!this.playing || this.currentPhraseIndex >= this.phrases.size()) {
            this.playing = false;
            return;
        }
        String phrase = this.phrases.get(this.currentPhraseIndex);
        this.executor.submit(() -> {
            this.speak(phrase);
            ++this.currentPhraseIndex;
            this.speakNextPhrase();
        });
    }

    private void speak(String text) {
        ProcessBuilder builder;
        float volume = this.getEffectiveVolume();
        switch (OperatingSystem.get()) {
            case WINDOWS: {
                int vol = Math.round(volume * 100.0f);
                builder = new ProcessBuilder("powershell", "-Command", "Add-Type -AssemblyName System.Speech;$speak = New-Object System.Speech.Synthesis.SpeechSynthesizer;$speak.Volume = " + vol + ";$speak.Speak('" + ClientNarratorBlockNarratorInstance.escapePowerShell(text) + "');");
                break;
            }
            case MAC_OS: {
                builder = new ProcessBuilder("say", text);
                break;
            }
            case LINUX: {
                if (new File("/usr/bin/spd-say").exists()) {
                    builder = new ProcessBuilder("spd-say", text);
                    break;
                }
                int amp = Math.round(volume * 200.0f);
                builder = new ProcessBuilder("espeak", "-a", String.valueOf(amp), text);
                break;
            }
            default: {
                return;
            }
        }
        builder.redirectErrorStream(true);
        try {
            this.ttsProcess = builder.start();
            this.ttsProcess.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopProcess() {
        if (this.ttsProcess != null && this.ttsProcess.isAlive()) {
            this.ttsProcess.destroy();
            this.ttsProcess = null;
        }
    }

    private static String escapePowerShell(String input) {
        return input.replace("'", "''");
    }
}

