/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.sound;

import com.mojang.text2speech.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public class PersonalBookReaderNarratorInstance {
    private final UUID uuid;
    private final class_746 player;
    private final ExecutorService executor;
    private Process ttsProcess;

    public PersonalBookReaderNarratorInstance(class_746 player, UUID uuid) {
        this.uuid = uuid;
        this.player = player;
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "PersonalBookReaderNarrator-" + String.valueOf(uuid));
            t.setDaemon(true);
            return t;
        });
    }

    public UUID getUuid() {
        return this.uuid;
    }

    private float getEffectiveVolume() {
        return class_310.method_1551().field_1690.method_71978(class_3419.field_15246);
    }

    public void sayBook(class_1799 stack) {
        class_9302 book = (class_9302)stack.method_58694(class_9334.field_49606);
        if (book == null) {
            return;
        }
        this.executor.submit(() -> {
            StringBuilder buffer = new StringBuilder();
            for (class_9262 pagePair : book.comp_2422()) {
                String pageString = ((class_2561)pagePair.method_57140(false)).getString().trim();
                if (pageString.isEmpty()) continue;
                buffer.append(pageString);
                if (pageString.matches(".*[.!?\u2026]$")) {
                    this.speak(buffer.toString());
                    buffer.setLength(0);
                    continue;
                }
                buffer.append(" ");
            }
            if (buffer.length() > 0) {
                this.speak(buffer.toString());
            }
        });
    }

    private void speak(String text) {
        this.executor.submit(() -> {
            this.stopProcess();
            try {
                ProcessBuilder builder;
                float volume = this.getEffectiveVolume();
                switch (OperatingSystem.get()) {
                    case WINDOWS: {
                        int vol = Math.round(volume * 100.0f);
                        builder = new ProcessBuilder("powershell", "-Command", "Add-Type -AssemblyName System.Speech;$speak = New-Object System.Speech.Synthesis.SpeechSynthesizer;$speak.Volume = " + vol + ";$speak.Speak('" + PersonalBookReaderNarratorInstance.escapePowerShell(text) + "');");
                        break;
                    }
                    case MAC_OS: {
                        builder = new ProcessBuilder("say", text);
                        break;
                    }
                    case LINUX: {
                        if (new File("/usr/bin/spd-say").exists()) {
                            builder = new ProcessBuilder("spd-say", text);
                            break;
                        }
                        int amp = Math.round(volume * 200.0f);
                        builder = new ProcessBuilder("espeak", "-a", String.valueOf(amp), text);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                builder.redirectErrorStream(true);
                this.ttsProcess = builder.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void clear() {
        this.stopProcess();
        if (!this.executor.isShutdown()) {
            this.executor.submit(this::stopProcess);
        }
    }

    private void stopProcess() {
        if (this.ttsProcess != null && this.ttsProcess.isAlive()) {
            this.ttsProcess.destroy();
            this.ttsProcess = null;
        }
    }

    public void destroy() {
        this.stopProcess();
        ExecutorService ex = this.executor;
        if (ex != null && !ex.isShutdown()) {
            ex.shutdownNow();
        }
    }

    private static String escapePowerShell(String input) {
        return input.replace("'", "''");
    }

    public static void cancel(PersonalBookReaderNarratorInstance instance) {
        instance.clear();
    }

    public static void play(PersonalBookReaderNarratorInstance instance, class_1799 stack) {
        if (stack.method_58694(class_9334.field_49606) != null) {
            instance.sayBook(stack);
        }
    }
}

