/*
 * Decompiled with CFR 0.152.
 */
package net.dented.personalreader.sound;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.dented.personalreader.config.Config;
import net.minecraft.class_2338;

public class ServerNarratorBlockNarratorInstance {
    private final UUID uuid;
    private final class_2338 pos;
    private final List<String> phrases;
    private final Consumer<String> onPhraseStart;
    private final Runnable onFinish;
    private final ExecutorService executor;
    private volatile Process ttsProcess;
    private volatile int currentPhraseIndex = 0;
    private volatile boolean active = false;

    public ServerNarratorBlockNarratorInstance(UUID uuid, class_2338 pos, List<String> phrases, Consumer<String> onPhraseStart, Runnable onFinish) {
        this.uuid = uuid;
        this.pos = pos;
        this.phrases = new ArrayList<String>(phrases);
        this.onPhraseStart = onPhraseStart;
        this.onFinish = onFinish;
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "ServerNarrator-" + String.valueOf(uuid));
            t.setDaemon(true);
            return t;
        });
    }

    public void play() {
        this.play(this.currentPhraseIndex);
    }

    public void play(int startIndex) {
        if (this.phrases.isEmpty() || startIndex >= this.phrases.size()) {
            return;
        }
        this.currentPhraseIndex = startIndex;
        this.active = true;
        this.executor.submit(this::loop);
    }

    public void stop() {
        this.active = false;
        try {
            if (this.ttsProcess != null && this.ttsProcess.isAlive()) {
                this.ttsProcess.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }

    public boolean isPlaying() {
        return this.active;
    }

    public int getCurrentPhraseIndex() {
        return this.currentPhraseIndex;
    }

    public List<String> phrases() {
        return this.phrases;
    }

    public void restoreIndex(int index) {
        if (index < 0 || index >= this.phrases.size()) {
            return;
        }
        this.currentPhraseIndex = index;
    }

    private void loop() {
        while (this.active && this.currentPhraseIndex < this.phrases.size()) {
            String phrase = this.phrases.get(this.currentPhraseIndex);
            this.onPhraseStart.accept(phrase);
            this.runMutedTTS(phrase);
            ++this.currentPhraseIndex;
        }
        this.active = false;
        if (this.onFinish != null) {
            this.onFinish.run();
        }
    }

    private long calculatePhraseDurationMillis(String phrase) {
        long durationMs = 0L;
        String normalized = phrase.replace("\n", Config.internalNarrationPhraseNewLineString);
        for (char c : normalized.toCharArray()) {
            if (c == '.' || c == '?' || c == '!') {
                durationMs += (long)Config.narrationPhraseEndPunctuationDurationMilliseconds;
            }
            if (c == '\u00a7') {
                durationMs += (long)Config.narrationPhraseNewLineDurationMilliseconds;
            }
            if (c == ',' || c == ':' || c == ';') {
                durationMs += (long)Config.narrationPhrasePausePunctuationDurationMilliseconds;
            }
            if (c == ' ') {
                durationMs += (long)Config.narrationPhraseSpaceDurationMilliseconds;
                continue;
            }
            durationMs += (long)Config.narrationPhraseOtherCharacterDurationMilliseconds;
        }
        return Math.max((long)Config.narrationPhraseMinimumDurationMilliseconds, durationMs);
    }

    private void runMutedTTS(String phrase) {
        long duration = this.calculatePhraseDurationMillis(phrase);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static String escapePowerShell(String input) {
        return input.replace("'", "''");
    }
}

