/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISWorlds;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TARDISConfiguration {
    private final TARDIS plugin;
    private final FileConfiguration config;
    private final HashMap<String, List<String>> comments = new HashMap();
    private final HashMap<String, Double> doubleOptions = new HashMap();
    private final HashMap<String, String> stringOptions = new HashMap();
    private final HashMap<String, Integer> integerOptions = new HashMap();
    private final HashMap<String, Boolean> booleanOptions = new HashMap();

    public TARDISConfiguration(TARDIS plugin) {
        this.plugin = plugin;
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        this.booleanOptions.put("abandon.enabled", true);
        this.booleanOptions.put("abandon.reduce_count", true);
        this.booleanOptions.put("allow.3d_doors", false);
        this.booleanOptions.put("allow.achievements", true);
        this.booleanOptions.put("allow.add_lights", false);
        this.booleanOptions.put("allow.admin_bypass", false);
        this.booleanOptions.put("allow.all_blocks", false);
        this.booleanOptions.put("allow.animal_spawners", true);
        this.booleanOptions.put("allow.autonomous", true);
        this.booleanOptions.put("allow.emergency_npc", true);
        this.booleanOptions.put("allow.dynamic_lamps", false);
        this.booleanOptions.put("allow.external_gravity", false);
        this.booleanOptions.put("allow.guardians", false);
        this.booleanOptions.put("allow.hads", true);
        this.booleanOptions.put("allow.invisibility", true);
        this.booleanOptions.put("allow.mob_farming", true);
        this.booleanOptions.put("allow.perception_filter", true);
        this.booleanOptions.put("allow.power_down", true);
        this.booleanOptions.put("allow.power_down_on_quit", false);
        this.booleanOptions.put("allow.repair", true);
        this.booleanOptions.put("allow.sfx", true);
        this.booleanOptions.put("allow.spawn_eggs", true);
        this.booleanOptions.put("allow.village_travel", false);
        this.booleanOptions.put("allow.weather_set", false);
        this.booleanOptions.put("allow.wg_flag_set", true);
        this.booleanOptions.put("allow.zero_room", false);
        this.booleanOptions.put("arch.clear_inv_on_death", false);
        this.booleanOptions.put("arch.enabled", true);
        this.booleanOptions.put("arch.switch_inventory", true);
        this.booleanOptions.put("archive.enabled", true);
        this.booleanOptions.put("circuits.damage", false);
        this.booleanOptions.put("conversions.all_in_one.helper", false);
        this.booleanOptions.put("conversions.all_in_one.shop", false);
        this.booleanOptions.put("conversions.all_in_one.sonic_blaster", false);
        this.booleanOptions.put("conversions.all_in_one.vortex_manipulator", false);
        this.booleanOptions.put("conversions.all_in_one.weeping_angels", false);
        this.booleanOptions.put("conversions.archive_wall_data", false);
        this.booleanOptions.put("conversions.ars_materials", false);
        this.booleanOptions.put("conversions.bind", false);
        this.booleanOptions.put("conversions.block_materials", false);
        this.booleanOptions.put("conversions.block_wall_signs", false);
        this.booleanOptions.put("conversions.condenser_materials", false);
        this.booleanOptions.put("conversions.constructs", false);
        this.booleanOptions.put("conversions.controls", false);
        this.booleanOptions.put("conversions.custom_preset", false);
        this.booleanOptions.put("conversions.eyes", false);
        this.booleanOptions.put("conversions.icons", false);
        this.booleanOptions.put("conversions.interior_door_id", false);
        this.booleanOptions.put("conversions.legacy_budget", false);
        this.booleanOptions.put("conversions.paintings", false);
        this.booleanOptions.put("conversions.exploding", false);
        this.booleanOptions.put("conversions.player_prefs_materials", false);
        this.booleanOptions.put("conversions.short_grass", false);
        this.booleanOptions.put("creation.add_perms", true);
        this.booleanOptions.put("creation.check_for_home", true);
        this.booleanOptions.put("creation.create_worlds", false);
        this.booleanOptions.put("creation.create_worlds_with_perms", false);
        this.booleanOptions.put("creation.default_world", true);
        this.booleanOptions.put("creation.enable_legacy", true);
        this.booleanOptions.put("creation.keep_night", true);
        this.booleanOptions.put("creation.seed_block.crafting", true);
        this.booleanOptions.put("creation.seed_block.legacy", true);
        this.booleanOptions.put("debug", false);
        this.booleanOptions.put("desktop.check_blocks_before_upgrade", false);
        this.booleanOptions.put("desktop.previews", false);
        this.booleanOptions.put("difficulty.circuits", false);
        this.booleanOptions.put("difficulty.disks", false);
        this.booleanOptions.put("difficulty.disk_in_hand_for_write", true);
        this.booleanOptions.put("difficulty.biome_reader", true);
        this.booleanOptions.put("difficulty.stattenheim_remote", false);
        this.booleanOptions.put("difficulty.tardis_locator", false);
        this.booleanOptions.put("eye_of_harmony.player_damage", true);
        this.booleanOptions.put("eye_of_harmony.ossified", true);
        this.booleanOptions.put("eye_of_harmony.particles", true);
        this.booleanOptions.put("growth.return_room_seed", true);
        this.booleanOptions.put("growth.rooms_require_blocks", false);
        this.booleanOptions.put("junk.enabled", true);
        this.booleanOptions.put("junk.particles", true);
        this.booleanOptions.put("modules.blueprints", false);
        this.booleanOptions.put("modules.mapping", false);
        this.booleanOptions.put("modules.weeping_angels", false);
        this.booleanOptions.put("modules.vortex_manipulator", false);
        this.booleanOptions.put("modules.shop", false);
        this.booleanOptions.put("modules.regeneration", false);
        this.booleanOptions.put("modules.sonic_blaster", false);
        this.booleanOptions.put("police_box.animated_door", true);
        this.booleanOptions.put("police_box.load_shells", false);
        this.booleanOptions.put("police_box.keep_chunk_force_loaded", true);
        this.booleanOptions.put("police_box.use_nick", false);
        this.booleanOptions.put("police_box.view_interior", false);
        this.booleanOptions.put("police_box.view_interior_uses_console_size", false);
        this.booleanOptions.put("preferences.add_server_link", true);
        this.booleanOptions.put("preferences.any_key", false);
        this.booleanOptions.put("preferences.clean", true);
        this.booleanOptions.put("preferences.nerf_pistons.enabled", false);
        this.booleanOptions.put("preferences.nerf_pistons.only_tardis_worlds", true);
        this.booleanOptions.put("preferences.no_coords", false);
        this.booleanOptions.put("preferences.no_creative_condense", false);
        this.booleanOptions.put("preferences.no_enchanted_condense", true);
        this.booleanOptions.put("preferences.update.notify", true);
        this.booleanOptions.put("preferences.update.auto_download", false);
        this.booleanOptions.put("preferences.open_door_policy", false);
        this.booleanOptions.put("preferences.render_entities", false);
        this.booleanOptions.put("preferences.respect_chunky_border", true);
        this.booleanOptions.put("preferences.respect_grief_prevention", true);
        this.booleanOptions.put("preferences.respect_worldborder", true);
        this.booleanOptions.put("preferences.spawn_random_monsters", true);
        this.booleanOptions.put("preferences.strike_lightning", true);
        this.booleanOptions.put("preferences.use_default_condensables", true);
        this.booleanOptions.put("preferences.use_worldguard", true);
        this.booleanOptions.put("siege.butcher", false);
        this.booleanOptions.put("siege.creeper", false);
        this.booleanOptions.put("siege.enabled", true);
        this.booleanOptions.put("siege.healing", false);
        this.booleanOptions.put("siege.texture", false);
        this.booleanOptions.put("sonic.charge", false);
        this.booleanOptions.put("storage.mysql.useSSL", false);
        this.booleanOptions.put("travel.exile", false);
        this.booleanOptions.put("travel.give_key", false);
        this.booleanOptions.put("travel.include_default_world", false);
        this.booleanOptions.put("travel.land_on_water", true);
        this.booleanOptions.put("travel.nether", false);
        this.booleanOptions.put("travel.no_destination_malfunctions", true);
        this.booleanOptions.put("travel.per_world_perms", false);
        this.booleanOptions.put("travel.terminal.redefine", false);
        this.booleanOptions.put("travel.the_end", false);
        this.integerOptions.put("allow.force_field", 8);
        this.integerOptions.put("arch.min_time", 20);
        this.integerOptions.put("archive.limit", 3);
        this.integerOptions.put("circuits.uses.ars", 20);
        this.integerOptions.put("circuits.uses.chameleon", 25);
        this.integerOptions.put("circuits.uses.input", 50);
        this.integerOptions.put("circuits.uses.invisibility", 5);
        this.integerOptions.put("circuits.uses.materialisation", 50);
        this.integerOptions.put("circuits.uses.memory", 20);
        this.integerOptions.put("circuits.uses.randomiser", 50);
        this.integerOptions.put("circuits.uses.scanner", 20);
        this.integerOptions.put("circuits.uses.telepathic", 20);
        this.integerOptions.put("circuits.uses.temporal", 20);
        this.integerOptions.put("circuits.uses.stattenheim", 15);
        this.integerOptions.put("creation.border_radius", 256);
        this.integerOptions.put("creation.count", 0);
        this.integerOptions.put("creation.inventory_group", 0);
        this.integerOptions.put("creation.tips_limit", 400);
        this.integerOptions.put("desktop.block_change_percent", 25);
        this.integerOptions.put("eye_of_harmony.damage_period", 20);
        this.integerOptions.put("growth.ars_limit", 1);
        this.integerOptions.put("growth.delay_factor", 1);
        this.integerOptions.put("growth.gravity_max_distance", 15);
        this.integerOptions.put("growth.gravity_max_velocity", 5);
        this.integerOptions.put("growth.room_speed", 4);
        this.integerOptions.put("growth.rooms_condenser_percent", 100);
        this.integerOptions.put("junk.return", -1);
        this.integerOptions.put("mapping.update_period", 30);
        this.integerOptions.put("mapping.updates_per_tick", 10);
        this.integerOptions.put("police_box.rebuild_cooldown", 10000);
        this.integerOptions.put("preferences.hads_damage", 10);
        this.integerOptions.put("preferences.hads_distance", 10);
        this.integerOptions.put("preferences.heal_speed", 200);
        this.integerOptions.put("preferences.malfunction", 3);
        this.integerOptions.put("preferences.malfunction_end", 3);
        this.integerOptions.put("preferences.malfunction_nether", 3);
        this.integerOptions.put("preferences.sfx_volume", 10);
        this.integerOptions.put("preferences.spawn_limit", 10);
        this.integerOptions.put("siege.breeding", 0);
        this.integerOptions.put("siege.growth", 0);
        this.integerOptions.put("sonic.charge_interval", 60);
        this.integerOptions.put("sonic.charge_level", 1000);
        this.integerOptions.put("sonic.conversion_radius", 1);
        this.integerOptions.put("sonic.freeze_cooldown", 60);
        this.integerOptions.put("sonic.usage", 10);
        this.integerOptions.put("travel.grace_period", 10);
        this.integerOptions.put("travel.manual_flight_delay", 60);
        this.integerOptions.put("travel.max_distance", 29999983);
        this.integerOptions.put("travel.random_attempts", 30);
        this.integerOptions.put("travel.random_circuit.x", 5000);
        this.integerOptions.put("travel.random_circuit.z", 5000);
        this.integerOptions.put("travel.terminal_step", 1);
        this.integerOptions.put("travel.timeout", 5);
        this.integerOptions.put("travel.timeout_height", 135);
        this.integerOptions.put("travel.tp_radius", 500);
        this.stringOptions.put("creation.area", "none");
        this.stringOptions.put("creation.default_world_name", "TARDIS_TimeVortex");
        this.stringOptions.put("creation.use_clay", "WOOL");
        this.stringOptions.put("creation.seed_block.easy", "REDSTONE_TORCH");
        this.stringOptions.put("creation.seed_block.normal", "SOUL_LANTERN");
        this.stringOptions.put("creation.seed_block.hard", "DRAGON_BREATH");
        this.stringOptions.put("creation.tips_next", "HIGHEST");
        this.stringOptions.put("difficulty.crafting", "easy");
        this.stringOptions.put("display.all", "&6X&7%X% &6Y&7%Y% &6Z&7%Z% &6F&7%FACING% (%FACING_XZ%) %TARGET_BLOCK%");
        this.stringOptions.put("police_box.default_preset", "FACTORY");
        this.stringOptions.put("police_box.sign_colour", "WHITE");
        this.stringOptions.put("preferences.default_key", "eleventh");
        this.stringOptions.put("preferences.key", "GOLD_NUGGET");
        this.stringOptions.put("preferences.language", "en");
        this.stringOptions.put("preferences.respect_towny", "nation");
        this.stringOptions.put("preferences.respect_worldguard", "build");
        this.stringOptions.put("preferences.vortex_fall", "kill");
        this.stringOptions.put("sonic.default_model", "eleventh");
        this.stringOptions.put("storage.database", "sqlite");
        this.stringOptions.put("storage.mysql.database", "TARDIS");
        this.stringOptions.put("storage.mysql.host", "localhost");
        this.stringOptions.put("storage.mysql.password", "mysecurepassword");
        this.stringOptions.put("storage.mysql.port", "3306");
        this.stringOptions.put("storage.mysql.prefix", "");
        this.stringOptions.put("storage.mysql.user", "bukkit");
        this.stringOptions.put("travel.terminal.nether", "world");
        this.stringOptions.put("travel.terminal.the_end", "world");
        this.doubleOptions.put("eye_of_harmony.damage_amount", 0.5);
        this.comments.put("abandon", List.of("abandoned TARDISes", "https://tardis.pages.dev/abandon#config-options"));
        this.comments.put("allow", List.of("restrictions", "https://tardis.pages.dev/configuration/allow"));
        this.comments.put("arch", List.of("chameleon arch", "https://tardis.pages.dev/chameleon-arch#chameleon-arch-configuration"));
        this.comments.put("archive", List.of("console archives", "https://tardis.pages.dev/archive#config-options"));
        this.comments.put("circuits", List.of("circuits", "https://tardis.pages.dev/circuit-use#configuration-options"));
        this.comments.put("creation", List.of("inner TARDIS", "https://tardis.pages.dev/configuration/creation"));
        this.comments.put("desktop", List.of("desktop theme", "https://tardis.pages.dev/desktop-theme#config-options"));
        this.comments.put("display", List.of("HUD display", "https://tardis.pages.dev/display"));
        this.comments.put("eye_of_harmony", List.of("eye of harmony preferences", "https://tardis.pages.dev/eye-of-harmony"));
        this.comments.put("growth", List.of("room related", "https://tardis.pages.dev/configuration/growth"));
        this.comments.put("junk", List.of("junk TARDIS", "https://tardis.pages.dev/junk-tardis#configuration-options"));
        this.comments.put("mapping", List.of("mapping", "https://tardis.pages.dev/modules/mapping#configuration-options"));
        this.comments.put("modules", List.of("modules are disabled by default", "https://tardis.pages.dev/modules"));
        this.comments.put("police_box", List.of("outer TARDIS", "https://tardis.pages.dev/configuration/preset"));
        this.comments.put("preferences", List.of("general preferences", "https://tardis.pages.dev/configuration/prefs"));
        this.comments.put("siege", List.of("siege mode", "https://tardis.pages.dev/siege-mode#configuration"));
        this.comments.put("sonic", List.of("sonic screwdriver preferences", "https://tardis.pages.dev/sonic-dock#configuration"));
        this.comments.put("storage", List.of("how the plugin persists data", "https://tardis.pages.dev/configuration/storage"));
        this.comments.put("travel", List.of("travel settings", "https://tardis.pages.dev/configuration/travel"));
        this.comments.put("conversions", List.of("don't touch!"));
    }

    /*
     * WARNING - void declaration
     */
    public void checkConfig() {
        Object firstSplit;
        int i = 0;
        if (this.config.getString("creation.default_world_name").equals("tardis_time_vortex")) {
            this.plugin.getConfig().set("creation.default_world_name", (Object)"TARDIS_TimeVortex");
            ++i;
        }
        if (!this.config.contains("rechargers")) {
            this.plugin.getConfig().createSection("rechargers");
            ++i;
        }
        if (this.config.contains("creation.previews")) {
            this.plugin.getConfig().set("desktop.previews", (Object)this.config.getBoolean("creation.previews"));
            this.plugin.getConfig().set("creation.previews", null);
            ++i;
        }
        if (this.config.contains("damage_amount")) {
            this.plugin.getConfig().set("eye_of_harmony.damage_amount", (Object)this.config.getDouble("damage_amount"));
            this.plugin.getConfig().set("damage_amount", null);
            ++i;
        }
        if (this.config.contains("travel.chameleon")) {
            this.plugin.getConfig().set("travel.chameleon", null);
        }
        if (this.config.contains("creation.custom_schematic")) {
            this.plugin.getConfig().set("creation.custom_schematic", null);
            this.plugin.getConfig().set("creation.custom_schematic_seed", null);
        }
        if (this.config.contains("conversions.lowercase_world_names")) {
            this.plugin.getConfig().set("conversions.lowercase_world_names", null);
        }
        if (this.config.contains("preferences.respect_factions")) {
            this.plugin.getConfig().set("preferences.respect_factions", null);
            this.plugin.getConfig().set("preferences.respect_red_protect", null);
        }
        if (this.config.contains("switch_resource_packs")) {
            this.plugin.getConfig().set("switch_resource_packs", null);
        }
        if (this.config.contains("preferences.wake_bees")) {
            this.plugin.getConfig().set("preferences.wake_bees", null);
        }
        if (this.config.contains("preferences.wand")) {
            this.plugin.getConfig().set("preferences.wand", null);
        }
        if (this.config.contains("police_box.set_biome")) {
            this.plugin.getConfig().set("police_box.set_biome", null);
        }
        if (this.config.contains("creation.sky_biome")) {
            this.plugin.getConfig().set("creation.sky_biome", null);
        }
        if (this.config.contains("creation.use_block_stack")) {
            this.plugin.getConfig().set("creation.use_block_stack", null);
        }
        for (Map.Entry<String, Boolean> entry : this.booleanOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.debug("Missing entry: " + entry.getKey());
            this.plugin.getConfig().set(entry.getKey(), (Object)entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.integerOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.debug("Missing entry: " + entry.getKey());
            this.plugin.getConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.doubleOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.debug("Missing entry: " + entry.getKey());
            this.plugin.getConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Object> entry : this.stringOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.debug("Missing entry: " + entry.getKey());
            this.plugin.getConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        if (this.config.contains("storage.mysql.url")) {
            firstSplit = this.config.getString("storage.mysql.url").split(":");
            String string = firstSplit[1].substring(2);
            String[] secondSplit = firstSplit[2].split("/");
            String port = secondSplit[0];
            String database = secondSplit[1];
            this.plugin.getConfig().set("storage.mysql.host", (Object)string);
            this.plugin.getConfig().set("storage.mysql.port", (Object)port);
            this.plugin.getConfig().set("storage.mysql.database", (Object)database);
            this.plugin.getConfig().set("storage.mysql.url", null);
            ++i;
        }
        if (this.config.contains("preferences.difficulty")) {
            void var3_17;
            firstSplit = this.config.getString("preferences.difficulty", "easy").toLowerCase(Locale.ROOT);
            int n = -1;
            switch (((String)firstSplit).hashCode()) {
                case -1078030475: {
                    if (!((String)firstSplit).equals("medium")) break;
                    boolean bl = false;
                    break;
                }
                case 3195115: {
                    if (!((String)firstSplit).equals("hard")) break;
                    boolean bl = true;
                }
            }
            switch (var3_17) {
                case 0: {
                    this.plugin.getConfig().set("difficulty.crafting", (Object)"easy");
                    this.plugin.getConfig().set("difficulty.circuits", (Object)false);
                    this.plugin.getConfig().set("difficulty.disks", (Object)false);
                    this.plugin.getConfig().set("difficulty.biome_reader", (Object)true);
                    this.plugin.getConfig().set("difficulty.stattenheim_remote", (Object)true);
                    this.plugin.getConfig().set("difficulty.tardis_locator", (Object)true);
                    break;
                }
                case 1: {
                    this.plugin.getConfig().set("difficulty.crafting", (Object)"hard");
                    this.plugin.getConfig().set("difficulty.circuits", (Object)true);
                    this.plugin.getConfig().set("difficulty.disks", (Object)true);
                    this.plugin.getConfig().set("difficulty.biome_reader", (Object)false);
                    this.plugin.getConfig().set("difficulty.stattenheim_remote", (Object)true);
                    this.plugin.getConfig().set("difficulty.tardis_locator", (Object)true);
                    break;
                }
                default: {
                    this.plugin.getConfig().set("difficulty.crafting", (Object)"easy");
                    this.plugin.getConfig().set("difficulty.circuits", (Object)false);
                    this.plugin.getConfig().set("difficulty.disks", (Object)false);
                    this.plugin.getConfig().set("difficulty.biome_reader", (Object)true);
                    this.plugin.getConfig().set("difficulty.stattenheim_remote", (Object)false);
                    this.plugin.getConfig().set("difficulty.tardis_locator", (Object)false);
                }
            }
            this.plugin.getConfig().set("difficulty.disk_in_hand_for_write", (Object)true);
            this.plugin.getConfig().set("difficulty.system_upgrades", (Object)true);
            this.plugin.getConfig().set("preferences.difficulty", null);
            ++i;
        }
        if (this.config.contains("preferences.enable_dynmap")) {
            this.plugin.getConfig().set("modules.mapping", (Object)this.config.getBoolean("preferences.enable_dynmap"));
            this.plugin.getConfig().set("mapping.provider", (Object)"dynmap");
            this.plugin.getConfig().set("preferences.enable_dynmap", null);
            ++i;
        }
        if (this.config.contains("preferences.notify_update")) {
            this.plugin.getConfig().set("preferences.update.notify", (Object)this.config.getBoolean("preferences.notify_update"));
            this.plugin.getConfig().set("preferences.notify_update", null);
            ++i;
        }
        if (this.config.contains("preferences.freeze_cooldown")) {
            this.plugin.getConfig().set("sonic.freeze_cooldown", (Object)this.config.getInt("preferences.freeze_cooldown"));
            this.plugin.getConfig().set("sonic.default_model", (Object)this.config.getString("preferences.default_sonic"));
            this.plugin.getConfig().set("sonic.conversion_radius", this.config.get("preferences.sonic_radius") != null ? this.config.get("preferences.sonic_radius") : Integer.valueOf(1));
            this.plugin.getConfig().set("preferences.freeze_cooldown", null);
            this.plugin.getConfig().set("preferences.default_sonic", null);
            this.plugin.getConfig().set("preferences.sonic_radius", null);
            ++i;
        }
        if (this.config.contains("dynmap.update_period")) {
            this.plugin.getConfig().set("mapping.provider", (Object)"dynmap");
            this.plugin.getConfig().set("mapping.update_period", (Object)this.plugin.getConfig().getInt("dynmap.update_period"));
            this.plugin.getConfig().set("mapping.updates_per_tick", (Object)this.plugin.getConfig().getInt("dynmap.updates_per_tick"));
            this.plugin.getConfig().set("dynmap.update_period", null);
            this.plugin.getConfig().set("dynmap.updates_per_tick", null);
            ++i;
        }
        if (this.config.contains("dynmap.enabled")) {
            this.plugin.getConfig().set("modules.mapping", (Object)this.config.getBoolean("dynmap.enabled"));
            this.plugin.getConfig().set("mapping.provider", (Object)"dynmap");
            this.plugin.getConfig().set("mapping.update_period", (Object)this.plugin.getConfig().getInt("dynmap.update_period"));
            this.plugin.getConfig().set("mapping.updates_per_tick", (Object)this.plugin.getConfig().getInt("dynmap.updates_per_tick"));
            this.plugin.getConfig().set("dynmap.enabled", null);
            this.plugin.getConfig().set("dynmap.update_period", null);
            this.plugin.getConfig().set("dynmap.updates_per_tick", null);
            ++i;
        }
        if (this.config.contains("blueprints.enabled")) {
            this.plugin.getConfig().set("modules.blueprints", (Object)this.config.getBoolean("blueprints.enabled"));
            this.plugin.getConfig().set("blueprints.enabled", null);
            this.plugin.getConfig().set("blueprints", null);
        }
        if (this.config.contains("handles")) {
            this.plugin.getConfig().set("allow.handles", null);
            this.plugin.getConfig().set("handles", null);
            ++i;
        }
        if (this.config.contains("creation.seed_block_crafting")) {
            this.plugin.getConfig().set("creation.seed_block_crafting", null);
            ++i;
        }
        if (this.config.contains("preferences.walk_in_tardis")) {
            this.plugin.getConfig().set("preferences.walk_in_tardis", null);
            ++i;
        }
        if (this.config.contains("allow.chemistry")) {
            boolean tf = this.config.getBoolean("allow.chemistry");
            if (!this.config.contains("modules.chemistry") || this.config.getBoolean("modules.chemistry") != tf) {
                this.plugin.getConfig().set("modules.chemistry", (Object)tf);
            }
            this.plugin.getConfig().set("allow.chemistry", null);
            ++i;
        }
        if (this.config.contains("preferences.chat_width")) {
            this.plugin.getConfig().set("preferences.chat_width", null);
            ++i;
        }
        for (Map.Entry<String, List<String>> entry : this.comments.entrySet()) {
            this.plugin.getConfig().setComments(entry.getKey(), entry.getValue());
        }
        if (i > 0) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " new items to config");
        }
        new TARDISWorlds(this.plugin).doWorlds();
        this.plugin.saveConfig();
    }
}

