/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.monsters.daleks.DalekEquipment;
import org.bukkit.Location;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class TARDISSpawnListener
implements Listener {
    private final TARDIS plugin;
    private final List<CreatureSpawnEvent.SpawnReason> good_spawns = new ArrayList<CreatureSpawnEvent.SpawnReason>();

    public TARDISSpawnListener(TARDIS plugin) {
        this.plugin = plugin;
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.BEEHIVE);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.BREEDING);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.BUILD_WITHER);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.CURED);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.CUSTOM);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.DISPENSE_EGG);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.DROWNED);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.EGG);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.ENDER_PEARL);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.INFECTION);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.JOCKEY);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.LIGHTNING);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.MOUNT);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.NETHER_PORTAL);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.OCELOT_BABY);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.PATROL);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.RAID);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.SHEARED);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE);
        this.good_spawns.add(CreatureSpawnEvent.SpawnReason.VILLAGE_INVASION);
        if (plugin.getConfig().getBoolean("allow.animal_spawners")) {
            this.good_spawns.add(CreatureSpawnEvent.SpawnReason.SPAWNER);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        CreatureSpawnEvent.SpawnReason spawnReason = event.getSpawnReason();
        Location l = event.getLocation();
        if (l.getWorld().getName().contains("TARDIS")) {
            if (event.getEntityType().equals((Object)EntityType.ARMOR_STAND)) {
                return;
            }
            if (this.plugin.isTardisSpawn()) {
                this.plugin.setTardisSpawn(false);
                return;
            }
            if (!this.good_spawns.contains(spawnReason)) {
                event.setCancelled(true);
            }
            if (this.plugin.getConfig().getBoolean("allow.animal_spawners") && spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                event.setCancelled(event.getEntity() instanceof Enemy);
            }
            if (spawnReason.equals((Object)CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN) && this.plugin.getConfig().getBoolean("modules.weeping_angels") && TARDISConstants.RANDOM.nextInt(100) < 3) {
                LivingEntity le = (LivingEntity)l.getWorld().spawnEntity(l, EntityType.SKELETON);
                DalekEquipment.set(le, false);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> event.getEntity().remove(), 2L);
            }
        }
    }
}

