/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.boss.BarFlag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class TARDISConstants {
    public static final AxisAngle4f AXIS_ANGLE_ZERO = new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector3f VECTOR_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f VECTOR_QUARTER = new Vector3f(0.25f, 0.25f, 0.25f);
    public static final Set<String> COLOURS = Set.of("console_rustic", "console_brown", "console_pink", "console_magenta", "console_purple", "console_blue", "console_light_blue", "console_cyan", "console_green", "console_lime", "console_yellow", "console_orange", "console_red", "console_white", "console_black", "console_gray", "console_light_gray");
    public static final List<Material> GUI_IDS = List.of(Material.STONE, Material.GRANITE, Material.DIORITE, Material.ANDESITE, Material.GRASS_BLOCK, Material.DIRT, Material.PODZOL, Material.CRIMSON_NYLIUM, Material.WARPED_NYLIUM, Material.COBBLESTONE, Material.OAK_PLANKS, Material.CRIMSON_PLANKS, Material.WARPED_PLANKS, Material.BEDROCK, Material.SAND, Material.RED_SAND, Material.GRAVEL, Material.GOLD_ORE, Material.IRON_ORE, Material.COAL_ORE, Material.NETHER_GOLD_ORE, Material.ACACIA_LOG, Material.CRIMSON_STEM, Material.WARPED_STEM, Material.SPRUCE_WOOD, Material.BIRCH_LEAVES, Material.SPONGE, Material.GLASS, Material.LAPIS_ORE, Material.LAPIS_BLOCK, Material.DISPENSER, Material.SANDSTONE, Material.NOTE_BLOCK, Material.STICKY_PISTON, Material.COBWEB, Material.GOLD_BLOCK, Material.BRICKS, Material.TNT, Material.BOOKSHELF, Material.MOSSY_COBBLESTONE, Material.OBSIDIAN, Material.PURPUR_BLOCK, Material.SPAWNER, Material.CHEST, Material.DIAMOND_ORE, Material.DIAMOND_BLOCK, Material.CRAFTING_TABLE, Material.FURNACE, Material.REDSTONE_ORE, Material.ICE, Material.SNOW_BLOCK, Material.CACTUS, Material.CLAY, Material.JUKEBOX, Material.PUMPKIN, Material.NETHERRACK, Material.SOUL_SAND, Material.SOUL_SOIL, Material.BASALT, Material.GLOWSTONE, Material.JACK_O_LANTERN, Material.STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.BROWN_MUSHROOM_BLOCK, Material.RED_MUSHROOM_BLOCK, Material.MUSHROOM_STEM, Material.MELON, Material.MYCELIUM, Material.NETHER_BRICKS, Material.ENCHANTING_TABLE, Material.END_PORTAL_FRAME, Material.END_STONE, Material.END_STONE_BRICKS, Material.REDSTONE_LAMP, Material.EMERALD_ORE, Material.ENDER_CHEST, Material.EMERALD_BLOCK, Material.COMMAND_BLOCK, Material.BEACON, Material.TRAPPED_CHEST, Material.REDSTONE_BLOCK, Material.NETHER_QUARTZ_ORE, Material.HOPPER, Material.QUARTZ_BLOCK, Material.QUARTZ_BRICKS, Material.DROPPER, Material.PINK_TERRACOTTA, Material.CYAN_TERRACOTTA, Material.RED_TERRACOTTA, Material.HAY_BLOCK, Material.TERRACOTTA, Material.COAL_BLOCK, Material.SLIME_BLOCK, Material.YELLOW_STAINED_GLASS, Material.BLACK_STAINED_GLASS, Material.PRISMARINE, Material.DARK_PRISMARINE, Material.SEA_LANTERN, Material.RED_SANDSTONE, Material.MAGMA_BLOCK, Material.NETHER_WART_BLOCK, Material.RED_NETHER_BRICKS, Material.BONE_BLOCK, Material.OBSERVER, Material.WHITE_GLAZED_TERRACOTTA, Material.ORANGE_GLAZED_TERRACOTTA, Material.BLUE_GLAZED_TERRACOTTA, Material.MAGENTA_CONCRETE, Material.LIGHT_BLUE_CONCRETE, Material.TUBE_CORAL_BLOCK, Material.BRAIN_CORAL_BLOCK, Material.BUBBLE_CORAL_BLOCK, Material.FIRE_CORAL_BLOCK, Material.HORN_CORAL_BLOCK, Material.BLUE_ICE);
    public static final Set<Material> CHAMELEON_BLOCKS_VALID = TARDISConstants.getValidMaterials();
    public static final Set<Material> CHAMELEON_BLOCKS_BAD = TARDISConstants.getBadMaterials();
    public static final List<Tag> CHAMELEON_TAGS_CHANGE = List.of(Tag.SLABS, Tag.STAIRS, Tag.TRAPDOORS, Tag.CLIMBABLE, Tag.WALLS, Tag.FLOWER_POTS);
    public static final Set<Material> CHAMELEON_BLOCKS_CHANGE = TARDISConstants.getChangeBlocks();
    public static final Set<Material> CHAMELEON_BLOCKS_NEXT = TARDISConstants.makeNextMaterials();
    public static final List<Material> CHAMELEON_BLOCKS_PRECIOUS = List.of(Material.GOLD_BLOCK, Material.IRON_BLOCK, Material.TNT, Material.DIAMOND_BLOCK, Material.EMERALD_BLOCK, Material.REDSTONE_BLOCK, Material.COAL_BLOCK, Material.NETHERITE_BLOCK);
    public static final List<String> VOWELS = List.of("A", "E", "I", "O", "U");
    public static final List<EntityType> ENTITY_TYPES = List.of(EntityType.ALLAY, EntityType.ARMOR_STAND, EntityType.AXOLOTL, EntityType.BAT, EntityType.BEE, EntityType.BLAZE, EntityType.BOGGED, EntityType.BREEZE, EntityType.CAMEL, EntityType.CAT, EntityType.CREAKING, EntityType.CAVE_SPIDER, EntityType.CHICKEN, EntityType.ARMADILLO, EntityType.ENDER_DRAGON, EntityType.COD, EntityType.COW, EntityType.CREEPER, EntityType.DOLPHIN, EntityType.DONKEY, EntityType.DROWNED, EntityType.ELDER_GUARDIAN, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.EVOKER, EntityType.FOX, EntityType.FROG, EntityType.GHAST, EntityType.GIANT, EntityType.GLOW_SQUID, EntityType.GOAT, EntityType.GUARDIAN, EntityType.HAPPY_GHAST, EntityType.HOGLIN, EntityType.HORSE, EntityType.HUSK, EntityType.ILLUSIONER, EntityType.IRON_GOLEM, EntityType.LLAMA, EntityType.MAGMA_CUBE, EntityType.MULE, EntityType.MOOSHROOM, EntityType.OCELOT, EntityType.PANDA, EntityType.PARROT, EntityType.PHANTOM, EntityType.PIG, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.PILLAGER, EntityType.PLAYER, EntityType.POLAR_BEAR, EntityType.PUFFERFISH, EntityType.RABBIT, EntityType.RAVAGER, EntityType.SALMON, EntityType.SHEEP, EntityType.SHULKER, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.SKELETON_HORSE, EntityType.SLIME, EntityType.SNIFFER, EntityType.SNOW_GOLEM, EntityType.SPIDER, EntityType.SQUID, EntityType.STRAY, EntityType.STRIDER, EntityType.TADPOLE, EntityType.TRADER_LLAMA, EntityType.TROPICAL_FISH, EntityType.TURTLE, EntityType.VEX, EntityType.VILLAGER, EntityType.VINDICATOR, EntityType.WANDERING_TRADER, EntityType.WARDEN, EntityType.WITCH, EntityType.WITHER, EntityType.WITHER_SKELETON, EntityType.WOLF, EntityType.ZOGLIN, EntityType.ZOMBIE, EntityType.ZOMBIE_HORSE, EntityType.ZOMBIE_VILLAGER, EntityType.ZOMBIFIED_PIGLIN);
    public static final Set<Material> GOOD_MATERIALS = TARDISConstants.getReplaceableMaterials();
    public static final List<Material> GOOD_WATER = List.of(Material.AIR, Material.CAVE_AIR, Material.VOID_AIR, Material.WATER, Material.SEAGRASS, Material.TALL_SEAGRASS, Material.KELP_PLANT, Material.SEA_PICKLE);
    public static final List<String> GROWTH_STATES = List.of("Initiating block transfer mathematics", "Distributing cluster algebra", "Determining quantum probability/uncertainty", "Multiplying universal base code numerals", "Building artron mainframe module", "Assembling hyper-loom null-zone", "Complicating space-time events", "Forming extra-dimensional metastructure framework", "Finding dimensionally transcendental cradle", "Formatting organic protyon units", "Engineering warp matrix", "Inducting transducer power cells", "Implanting exitonic circuitry", "Kick-starting dynomorphic generator", "Regenerating molecular stabilizers", "Imprinting symbiotic nuclei", "Constructing temporal drive systems", "Choosing gender circuits", "Acquiring extra internal dimensions", "Stabilising Eye of Harmony", "Catalyzing huon particles", "Crystalising morphic fields", "Sterilizing life-support systems", "Zeroing transdimensional flux relay indicators", "Contrafibulating trachoidal crystals", "Overriding Vespian transmogrifier ratchet", "Installing time-warp anchorage unit", "Magnetising pseudo-timeline narrow focus coils", "Inserting translevel communications system", "Linking absolute tesseractulator", "Polishing telepathic induction circuits", "Preparing TARDIS factory exterior");
    public static final BlockData AIR = Material.AIR.createBlockData();
    public static final BlockData VOID_AIR = Material.VOID_AIR.createBlockData();
    public static final BlockData FIRE = Material.FIRE.createBlockData();
    public static final BlockData LAMP = Bukkit.createBlockData((String)"minecraft:redstone_lamp[lit=true]");
    public static final BlockData SNOW = Material.SNOW.createBlockData();
    public static final BlockData SNOW_BLOCK = Material.SNOW_BLOCK.createBlockData();
    public static final BlockData GLASS = Material.GLASS.createBlockData();
    public static final BlockData POWER = Material.REDSTONE_BLOCK.createBlockData();
    public static final BlockData LANTERN = Material.SEA_LANTERN.createBlockData();
    public static final BlockData BLACK = Material.BLACK_WOOL.createBlockData();
    public static final BlockData DAYLIGHT = Material.DAYLIGHT_DETECTOR.createBlockData();
    public static final BlockData ICE = Material.ICE.createBlockData();
    public static final BlockData WATER = Material.WATER.createBlockData();
    public static final BlockData LAVA = Material.LAVA.createBlockData();
    public static final Levelled LIGHT = (Levelled)Material.LIGHT.createBlockData();
    public static final Levelled LIGHT_DIV = TARDISConstants.setLight(15);
    public static final BlockData BARRIER = Material.BARRIER.createBlockData();
    public static final Random RANDOM = new Random();
    public static final List<Particle.DustOptions> DUSTOPTIONS = List.of(new Particle.DustOptions(Color.fromRGB((int)0, (int)102, (int)255), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)153, (int)255), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)204, (int)255), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)255), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)204), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)153), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)102), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)153), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)204), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)255), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)204, (int)255), 1.0f), new Particle.DustOptions(Color.fromRGB((int)0, (int)153, (int)255), 1.0f));
    public static final BarFlag[] EMPTY_ARRAY = new BarFlag[0];
    public static final List<Material> DYES = List.of(Material.CYAN_STAINED_GLASS_PANE, Material.GRAY_STAINED_GLASS_PANE, Material.WHITE_DYE, Material.ORANGE_DYE, Material.MAGENTA_DYE, Material.LIGHT_BLUE_DYE, Material.YELLOW_DYE, Material.LIME_DYE, Material.PINK_DYE, Material.GRAY_DYE, Material.LIGHT_GRAY_DYE, Material.CYAN_DYE, Material.PURPLE_DYE, Material.BLUE_DYE, Material.BROWN_DYE, Material.GREEN_DYE, Material.RED_DYE, Material.BLACK_DYE, Material.LEATHER_HORSE_ARMOR, Material.ENDER_PEARL);
    public static final UUID UUID_ZERO = new UUID(0L, 0L);

    private static Set<Material> getValidMaterials() {
        HashSet<Material> set = new HashSet<Material>();
        set.add(Material.BOOKSHELF);
        set.add(Material.BROWN_MUSHROOM);
        set.add(Material.COAL_BLOCK);
        set.add(Material.COBBLESTONE);
        set.add(Material.CRAFTING_TABLE);
        set.add(Material.DIAMOND_BLOCK);
        set.add(Material.EMERALD_BLOCK);
        set.add(Material.END_STONE);
        set.add(Material.GLOWSTONE);
        set.add(Material.GOLD_BLOCK);
        set.add(Material.IRON_BLOCK);
        set.add(Material.JUKEBOX);
        set.add(Material.LAPIS_BLOCK);
        set.add(Material.MELON);
        set.add(Material.MOSSY_COBBLESTONE);
        set.add(Material.NETHERRACK);
        set.add(Material.NETHER_BRICKS);
        set.add(Material.NOTE_BLOCK);
        set.add(Material.OBSIDIAN);
        set.add(Material.PUMPKIN);
        set.add(Material.QUARTZ_BLOCK);
        set.add(Material.REDSTONE_LAMP);
        set.add(Material.RED_MUSHROOM);
        set.add(Material.TNT);
        set.addAll(Tag.BEACON_BASE_BLOCKS.getValues());
        set.addAll(Tag.COAL_ORES.getValues());
        set.addAll(Tag.DIAMOND_ORES.getValues());
        set.addAll(Tag.EMERALD_ORES.getValues());
        set.addAll(Tag.GOLD_ORES.getValues());
        set.addAll(Tag.ICE.getValues());
        set.addAll(Tag.IMPERMEABLE.getValues());
        set.addAll(Tag.INFINIBURN_END.getValues());
        set.addAll(Tag.LAPIS_ORES.getValues());
        set.addAll(Tag.LEAVES.getValues());
        set.addAll(Tag.LOGS.getValues());
        set.addAll(Tag.MINEABLE_HOE.getValues());
        set.addAll(Tag.MINEABLE_SHOVEL.getValues());
        set.addAll(Tag.NETHER_CARVER_REPLACEABLES.getValues());
        set.addAll(Tag.OVERWORLD_CARVER_REPLACEABLES.getValues());
        set.addAll(Tag.PLANKS.getValues());
        set.addAll(Tag.REDSTONE_ORES.getValues());
        set.addAll(Tag.STONE_BRICKS.getValues());
        set.addAll(Tag.WOOL.getValues());
        set.remove(Material.SNOW);
        set.remove(Material.WATER);
        set.remove(Material.MOSS_CARPET);
        set.remove(Material.SCULK_SENSOR);
        set.remove(Material.SCULK_VEIN);
        set.remove(Material.SCULK_SHRIEKER);
        set.remove(Material.PINK_PETALS);
        set.removeAll(Tag.SAND.getValues());
        return set;
    }

    private static Set<Material> getBadMaterials() {
        HashSet<Material> set = new HashSet<Material>();
        set.add(Material.BREWING_STAND);
        set.add(Material.CAKE);
        set.add(Material.COCOA);
        set.add(Material.DISPENSER);
        set.add(Material.DRAGON_EGG);
        set.add(Material.ENCHANTING_TABLE);
        set.add(Material.END_PORTAL);
        set.add(Material.FIRE);
        set.add(Material.FURNACE);
        set.add(Material.IRON_BARS);
        set.add(Material.LAVA);
        set.add(Material.LILY_PAD);
        set.add(Material.NETHER_PORTAL);
        set.add(Material.NETHER_WART);
        set.add(Material.PISTON);
        set.add(Material.PISTON_HEAD);
        set.add(Material.REDSTONE_TORCH);
        set.add(Material.REDSTONE_WIRE);
        set.add(Material.REPEATER);
        set.add(Material.SPAWNER);
        set.add(Material.STICKY_PISTON);
        set.add(Material.SUGAR_CANE);
        set.add(Material.TRIPWIRE);
        set.add(Material.TRIPWIRE_HOOK);
        set.add(Material.WATER);
        set.addAll(Tag.ALL_SIGNS.getValues());
        set.addAll(Tag.BEDS.getValues());
        set.addAll(Tag.BUTTONS.getValues());
        set.addAll(Tag.CANDLE_CAKES.getValues());
        set.addAll(Tag.CAULDRONS.getValues());
        set.addAll(Tag.CLIMBABLE.getValues());
        set.addAll(Tag.CROPS.getValues());
        set.addAll(Tag.DOORS.getValues());
        set.addAll(Tag.FEATURES_CANNOT_REPLACE.getValues());
        set.addAll(Tag.FENCES.getValues());
        set.addAll(Tag.FENCE_GATES.getValues());
        set.addAll(Tag.PIGLIN_REPELLENTS.getValues());
        set.addAll(Tag.SAPLINGS.getValues());
        set.addAll(Tag.WALL_POST_OVERRIDE.getValues());
        return set;
    }

    private static Set<Material> getChangeBlocks() {
        HashSet<Material> set = new HashSet<Material>();
        set.add(Material.ATTACHED_MELON_STEM);
        set.add(Material.ATTACHED_PUMPKIN_STEM);
        set.add(Material.BLACK_CONCRETE_POWDER);
        set.add(Material.BLUE_CONCRETE_POWDER);
        set.add(Material.BROWN_CONCRETE_POWDER);
        set.add(Material.CYAN_CONCRETE_POWDER);
        set.add(Material.END_PORTAL_FRAME);
        set.add(Material.FARMLAND);
        set.add(Material.GRASS_BLOCK);
        set.add(Material.GRAVEL);
        set.add(Material.GRAY_CONCRETE_POWDER);
        set.add(Material.GREEN_CONCRETE_POWDER);
        set.add(Material.INFESTED_CHISELED_STONE_BRICKS);
        set.add(Material.INFESTED_COBBLESTONE);
        set.add(Material.INFESTED_CRACKED_STONE_BRICKS);
        set.add(Material.INFESTED_MOSSY_STONE_BRICKS);
        set.add(Material.INFESTED_STONE);
        set.add(Material.INFESTED_STONE_BRICKS);
        set.add(Material.IRON_BARS);
        set.add(Material.LIGHT_BLUE_CONCRETE_POWDER);
        set.add(Material.LIGHT_GRAY_CONCRETE_POWDER);
        set.add(Material.LIME_CONCRETE_POWDER);
        set.add(Material.MAGENTA_CONCRETE_POWDER);
        set.add(Material.MELON_STEM);
        set.add(Material.ORANGE_CONCRETE_POWDER);
        set.add(Material.PINK_CONCRETE_POWDER);
        set.add(Material.PUMPKIN_STEM);
        set.add(Material.PURPLE_CONCRETE_POWDER);
        set.add(Material.RED_CONCRETE_POWDER);
        set.add(Material.RED_SAND);
        set.add(Material.SAND);
        set.add(Material.SNOW);
        set.add(Material.WHITE_CONCRETE_POWDER);
        set.add(Material.YELLOW_CONCRETE_POWDER);
        set.addAll(Tag.CLIMBABLE.getValues());
        set.addAll(Tag.SLABS.getValues());
        set.addAll(Tag.STAIRS.getValues());
        set.addAll(Tag.TRAPDOORS.getValues());
        set.addAll(Tag.WALLS.getValues());
        return set;
    }

    public static Material changeToMaterial(Material material) {
        String original = material.toString();
        String[] split = original.split("_");
        Object changed = "";
        block19 : switch (split[0]) {
            case "CACTUS": {
                changed = "SANDSTONE";
                break;
            }
            case "CAVE": 
            case "TWISTING": 
            case "WEEPING": {
                changed = "MOSS_BLOCK";
                break;
            }
            case "END": {
                changed = "END_STONE";
                break;
            }
            case "FARMLAND": 
            case "GRASS": 
            case "SHORT_GRASS": {
                changed = "DIRT";
                break;
            }
            case "GRAVEL": {
                changed = "COARSE_DIRT";
                break;
            }
            case "IRON": {
                changed = "STONE";
                break;
            }
            case "LADDER": {
                changed = "BIRCH_PLANKS";
                break;
            }
            case "PETRIFIED": {
                changed = "OAK_PLANKS";
                break;
            }
            case "SCAFFOLDING": {
                changed = "BAMBOO_BLOCK";
                break;
            }
            case "SNOW": {
                changed = "SNOW_BLOCK";
                break;
            }
            case "VINE": {
                changed = "OAK_LEAVES";
                break;
            }
            case "INFESTED": {
                changed = original.replace("INFESTED_", "");
                break;
            }
            default: {
                String end;
                switch (end = split[split.length - 1]) {
                    case "GATE": {
                        String tmp = original.replace("_FENCE_GATE", "");
                        if (tmp.endsWith("BRICK")) {
                            changed = tmp + "S";
                            break block19;
                        }
                        if (tmp.endsWith("STONE")) {
                            changed = tmp;
                            break block19;
                        }
                        if (TARDISConstants.isWood(tmp)) {
                            changed = tmp + "_PLANKS";
                            break block19;
                        }
                        changed = tmp + "_BLOCK";
                        break block19;
                    }
                    case "FENCE": 
                    case "SLAB": 
                    case "STAIRS": 
                    case "WALL": {
                        String tmp = original.replace("_" + end, "");
                        if (tmp.endsWith("BRICK") || tmp.endsWith("TILE")) {
                            changed = tmp + "S";
                            break block19;
                        }
                        if (tmp.startsWith("POLISHED") || tmp.endsWith("ANDESITE") || tmp.endsWith("COPPER") || tmp.endsWith("DEEPSLATE") || tmp.endsWith("DIORITE") || tmp.endsWith("GRANITE") || tmp.endsWith("PRISMARINE") || tmp.endsWith("QUARTZ") || tmp.endsWith("STONE")) {
                            changed = tmp;
                            break block19;
                        }
                        if (TARDISConstants.isWood(tmp)) {
                            changed = tmp + "_PLANKS";
                            break block19;
                        }
                        changed = tmp + "_BLOCK";
                        break block19;
                    }
                    case "TRAPDOOR": {
                        changed = original.replace("TRAPDOOR", "PLANKS");
                        break block19;
                    }
                    case "POWDER": {
                        changed = original.replace("_POWDER", "");
                        break block19;
                    }
                    case "SAND": {
                        changed = original + "STONE";
                        break block19;
                    }
                    case "STEM": {
                        changed = split[0].equals("ATTACHED") ? split[1] : split[0];
                    }
                }
            }
        }
        try {
            return Material.valueOf((String)changed);
        }
        catch (IllegalArgumentException e) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "changeToMaterial() failed with the string: " + (String)changed + " from " + original);
            return Material.BLUE_WOOL;
        }
    }

    private static boolean isWood(String tmp) {
        for (Material plank : Tag.PLANKS.getValues()) {
            if (!plank.toString().startsWith(tmp)) continue;
            return true;
        }
        return false;
    }

    private static Set<Material> makeNextMaterials() {
        HashSet<Material> set = new HashSet<Material>();
        set.add(Material.AIR);
        set.add(Material.CAVE_AIR);
        set.add(Material.COBWEB);
        set.add(Material.DAYLIGHT_DETECTOR);
        set.add(Material.VOID_AIR);
        set.addAll(Tag.CROPS.getValues());
        set.addAll(Tag.FLOWERS.getValues());
        set.addAll(Tag.RAILS.getValues());
        set.addAll(Tag.REPLACEABLE.getValues());
        return set;
    }

    private static Set<Material> getReplaceableMaterials() {
        HashSet<Material> set = new HashSet<Material>();
        set.add(Material.AIR);
        set.add(Material.BROWN_MUSHROOM);
        set.add(Material.CAVE_AIR);
        set.add(Material.RED_MUSHROOM);
        set.add(Material.SNOW);
        set.add(Material.VOID_AIR);
        set.addAll(Tag.FLOWERS.getValues());
        set.addAll(Tag.LEAVES.getValues());
        set.addAll(Tag.REPLACEABLE.getValues());
        set.addAll(Tag.REPLACEABLE_BY_TREES.getValues());
        set.addAll(Tag.REPLACEABLE_BY_MUSHROOMS.getValues());
        set.addAll(Tag.SAPLINGS.getValues());
        return set;
    }

    public static boolean isTARDISPlanet(String world) {
        String w = world.toLowerCase(Locale.ROOT);
        return w.endsWith("gallifrey") || w.endsWith("siluria") || w.endsWith("skaro");
    }

    public static boolean isTARDISPlanetExact(String world) {
        String w = world.toLowerCase(Locale.ROOT);
        return w.equals("gallifrey") || w.equals("siluria") || w.equals("skaro") || w.equals("telos") || w.equals("rooms");
    }

    private static Levelled setLight(int level) {
        Levelled levelled = (Levelled)Material.LIGHT.createBlockData();
        levelled.setLevel(level);
        return levelled;
    }
}

