/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.IOException;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISSerializeInventory;
import me.eccentric_nz.TARDIS.advanced.TARDISStorageConverter;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class TARDISAdvancedConsoleInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final String uuid;
    private final int id;
    private final Inventory inventory;

    public TARDISAdvancedConsoleInventory(TARDIS plugin, String uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 18, (Component)Component.text((String)"TARDIS Console", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getContents());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getContents() {
        ItemStack[] stacks;
        block7: {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", this.uuid);
            ResultSetDiskStorage storage = new ResultSetDiskStorage(this.plugin, where);
            if (storage.resultSet()) {
                String console = storage.getConsole();
                if (!console.isEmpty()) {
                    String[] versions = storage.getVersions().split(",");
                    int version = TARDISNumberParsers.parseInt(versions[3]);
                    try {
                        if (version < 2) {
                            stacks = TARDISStorageConverter.updateCircuits(console);
                            versions[3] = version == 0 ? "1" : "2";
                            this.updateVersions(versions, this.uuid);
                            break block7;
                        }
                        stacks = TARDISSerializeInventory.itemStacksFromString(console);
                    }
                    catch (IOException ex) {
                        this.plugin.debug("Could not read console from database!");
                        stacks = new ItemStack[18];
                    }
                } else {
                    stacks = new ItemStack[18];
                }
            } else {
                stacks = this.create(this.id);
            }
        }
        return stacks;
    }

    private ItemStack[] create(int id) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("uuid", this.uuid);
        set.put("tardis_id", id);
        set.put("console", "rO0ABXcEAAAAEnBwcHBwcHBwcHBwcHBwcHBwcA==");
        this.plugin.getQueryFactory().doInsert("storage", set);
        return new ItemStack[18];
    }

    private void updateVersions(String[] versions, String uuid) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("versions", String.join((CharSequence)",", versions));
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        this.plugin.getQueryFactory().doSyncUpdate("storage", set, where);
    }
}

