/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.api;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.TARDISRandomLocation;
import me.eccentric_nz.TARDIS.api.WorldAndRange;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TARDISRandomNether
extends TARDISRandomLocation {
    private final TARDIS plugin;
    private final Parameters param;
    private final List<World> worlds;

    TARDISRandomNether(TARDIS plugin, List<String> list, Parameters param) {
        super(plugin);
        this.worlds = this.getWorlds(list);
        this.plugin = plugin;
        this.param = param;
    }

    public Location getlocation() {
        WorldAndRange war = this.getWorldandRange(this.worlds);
        for (int n = 0; n < this.plugin.getConfig().getInt("travel.random_attempts"); ++n) {
            int randX = TARDISConstants.RANDOM.nextInt(war.getRangeX());
            int randZ = TARDISConstants.RANDOM.nextInt(war.getRangeZ());
            int x = war.getMinX() + randX;
            int z = war.getMinZ() + randZ;
            int wherey = 100;
            Block startBlock = war.getWorld().getBlockAt(x, wherey, z);
            while (!startBlock.getChunk().isLoaded()) {
                startBlock.getChunk().load();
            }
            while (!startBlock.getType().isAir()) {
                startBlock = startBlock.getRelative(BlockFace.DOWN);
            }
            int air = 0;
            while (startBlock.getType().isAir() && startBlock.getLocation().getBlockY() > 30) {
                startBlock = startBlock.getRelative(BlockFace.DOWN);
                ++air;
            }
            Material mat = startBlock.getType();
            if (!this.plugin.getGeneralKeeper().getGoodNether().contains(mat) || air < 4) continue;
            Location dest = startBlock.getLocation();
            int netherLocY = dest.getBlockY();
            dest.setY((double)(netherLocY + 1));
            if (this.param.spaceTardis()) {
                int count;
                if (this.plugin.getPluginRespect().getRespect(dest, this.param)) {
                    int[] gsl = TARDISTimeTravel.getStartLocation(dest, this.param.getCompass());
                    int startx = gsl[0];
                    int resetx = gsl[1];
                    int starty = dest.getBlockY();
                    int startz = gsl[2];
                    int resetz = gsl[3];
                    count = TARDISTimeTravel.safeLocation(startx, starty, startz, resetx, resetz, war.getWorld(), this.param.getCompass());
                } else {
                    count = 1;
                }
                if (count != 0) continue;
                return dest;
            }
            if (!this.plugin.getPluginRespect().getRespect(dest, this.param)) continue;
            return dest;
        }
        return null;
    }
}

