/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.autonomous;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.autonomous.TARDISAutonomousInventory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAutonomousSave;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISAutonomousGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final ItemStack on;
    private final ItemStack off;

    public TARDISAutonomousGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.on = ItemStack.of((Material)Material.LIME_WOOL, (int)1);
        ItemMeta onMeta = this.on.getItemMeta();
        onMeta.displayName((Component)Component.text((String)plugin.getLanguage().getString("SET_ON", "ON"), (TextColor)NamedTextColor.GREEN));
        this.on.setItemMeta(onMeta);
        this.off = ItemStack.of((Material)Material.LIGHT_GRAY_CARPET, (int)1);
        ItemMeta offMeta = this.off.getItemMeta();
        offMeta.displayName((Component)Component.text((String)plugin.getLanguage().getString("SET_OFF", "OFF"), (TextColor)NamedTextColor.RED));
        this.off.setItemMeta(offMeta);
    }

    @EventHandler(ignoreCancelled=true)
    public void onChameleonMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISAutonomousInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot < 0 || slot > 35) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack is = view.getItem(slot);
        if (is == null) {
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        switch (slot) {
            case 3: {
                set.put("auto_type", "HOME");
                this.setTypeSlots(view, 12);
                break;
            }
            case 4: {
                if (this.hasAreas()) {
                    set.put("auto_type", "AREAS");
                    this.setTypeSlots(view, 13);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_CONFIGURED_AREAS");
                break;
            }
            case 5: {
                if (!this.plugin.getConfig().getStringList("autonomous_areas").isEmpty()) {
                    set.put("auto_type", "CONFIGURED_AREAS");
                    this.setTypeSlots(view, 14);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_CONFIGURED_AREAS");
                break;
            }
            case 6: {
                set.put("auto_type", "CLOSEST");
                this.setTypeSlots(view, 15);
                break;
            }
            case 7: {
                set.put("auto_type", "SAVE");
                this.setTypeSlots(view, 16);
                break;
            }
            case 21: {
                set.put("auto_default", "HOME");
                this.setDefaultSlots(view, 30);
                break;
            }
            case 22: {
                set.put("auto_default", "STAY");
                this.setDefaultSlots(view, 31);
                break;
            }
            case 25: {
                ResultSetAutonomousSave rsa;
                ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                if (!rst.fromUUID(player.getUniqueId().toString()) || !(rsa = new ResultSetAutonomousSave(this.plugin)).fromID(rst.getTardisId())) break;
                String autonomous = rsa.getAutonomous();
                int i = 0;
                int did = -1;
                for (Pair<String, Integer> pair : rsa.getData()) {
                    ++i;
                    if (!((String)pair.getFirst()).equals(autonomous)) continue;
                    did = (Integer)pair.getSecond();
                    break;
                }
                if (i >= rsa.getData().size()) {
                    i = 0;
                }
                Pair<String, Integer> next = rsa.getData().get(i);
                ItemMeta im = is.getItemMeta();
                List lore = im.lore();
                if (lore != null && lore.size() > 3) {
                    lore.set(3, Component.text((String)((String)next.getFirst()), (TextColor)NamedTextColor.GREEN));
                    im.lore(lore);
                    is.setItemMeta(im);
                    view.setItem(25, is);
                }
                this.plugin.getQueryFactory().doAutonomousSaveUpdate(did, (Integer)next.getSecond());
                break;
            }
            case 35: {
                this.close(player);
                break;
            }
        }
        if (!set.isEmpty()) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            this.plugin.getQueryFactory().doUpdate("player_prefs", set, where);
        }
    }

    private boolean hasAreas() {
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, false, true);
        return rsa.resultSet();
    }

    private void setTypeSlots(InventoryView view, int slot) {
        for (int i = 12; i < 17; ++i) {
            ItemStack is = i == slot ? this.on : this.off;
            view.setItem(i, is);
        }
    }

    private void setDefaultSlots(InventoryView view, int slot) {
        view.setItem(30, slot == 30 ? this.on : this.off);
        view.setItem(31, slot == 31 ? this.on : this.off);
    }
}

