/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISBuilderUtility;
import me.eccentric_nz.TARDIS.chameleon.construct.TARDISConstructColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISStainedGlassLookup;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.data.ReplacedBlock;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConstructSign;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.particles.Emitter;
import me.eccentric_nz.TARDIS.particles.TARDISParticles;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISSponge;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.tardischunkgenerator.worldgen.TARDISChunkGenerator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISMaterialisePreset
implements Runnable {
    private final TARDIS plugin;
    private final BuildData bd;
    private final int loops;
    private final ChameleonPreset preset;
    private final BlockData data;
    private final Adaption adapt;
    private final TARDISChameleonColumn column;
    private final TARDISChameleonColumn stained_column;
    private final TARDISChameleonColumn glass_column;
    private final Material random_colour;
    private final Material random_glass;
    private final NamedTextColor sign_colour;
    private int task;
    private int i;
    private Block handbrake;
    private BlockData h_data;
    private Block swampDoorBottom;
    private BlockData sdb_data;
    private Block swampDoorTop;
    private BlockData sdt_data;
    private Block swampSlab;
    private BlockData slab_data;

    public TARDISMaterialisePreset(TARDIS plugin, BuildData bd, ChameleonPreset preset, BlockData data, Adaption adapt) {
        this.plugin = plugin;
        this.bd = bd;
        this.loops = this.bd.getThrottle().getLoops();
        this.i = 0;
        this.preset = preset;
        this.data = data;
        this.adapt = adapt;
        if (preset.equals((Object)ChameleonPreset.ANGEL)) {
            plugin.getPresets().setR(TARDISConstants.RANDOM.nextInt(2));
        }
        if (this.preset.equals((Object)ChameleonPreset.CONSTRUCT)) {
            this.column = new TARDISConstructColumn(plugin, bd.getTardisID(), "blueprintData", bd.getDirection().forPreset()).getColumn();
            this.stained_column = new TARDISConstructColumn(plugin, bd.getTardisID(), "stainData", bd.getDirection().forPreset()).getColumn();
            this.glass_column = new TARDISConstructColumn(plugin, bd.getTardisID(), "glassData", bd.getDirection().forPreset()).getColumn();
        } else {
            this.column = plugin.getPresets().getColumn(preset, bd.getDirection().forPreset());
            this.stained_column = plugin.getPresets().getStained(preset, bd.getDirection().forPreset());
            this.glass_column = plugin.getPresets().getGlass(preset, bd.getDirection().forPreset());
        }
        Material[] colours = new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL};
        Material[] glassColours = new Material[]{Material.WHITE_STAINED_GLASS, Material.ORANGE_STAINED_GLASS, Material.MAGENTA_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS, Material.YELLOW_STAINED_GLASS, Material.LIME_STAINED_GLASS, Material.PINK_STAINED_GLASS, Material.CYAN_STAINED_GLASS, Material.PURPLE_STAINED_GLASS, Material.BLUE_STAINED_GLASS, Material.BROWN_STAINED_GLASS, Material.GREEN_STAINED_GLASS, Material.RED_STAINED_GLASS};
        int r = TARDISConstants.RANDOM.nextInt(13);
        this.random_colour = colours[r];
        this.random_glass = glassColours[r];
        this.sign_colour = plugin.getUtils().getSignColour();
    }

    public static void saveJunkControl(String location, String field, int id) {
        HashMap<String, Object> wherej = new HashMap<String, Object>();
        wherej.put("tardis_id", id);
        HashMap<String, Object> setj = new HashMap<String, Object>();
        setj.put(field, location);
        TARDIS.plugin.getQueryFactory().doUpdate("junk", setj, wherej);
    }

    @Override
    public void run() {
        if (!this.plugin.getTrackerKeeper().getDematerialising().contains(this.bd.getTardisID())) {
            boolean isJunkOrToilet;
            if (this.column == null || this.stained_column == null || this.glass_column == null) {
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = 0;
                this.plugin.getMessenger().sendColouredCommand((CommandSender)this.bd.getPlayer().getPlayer(), "INVALID_CONSTRUCT", "/tardistravel stop", this.plugin);
                this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getDematerialising().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getDestinationVortex().remove(this.bd.getTardisID());
                return;
            }
            int x = this.bd.getLocation().getBlockX();
            int plusx = this.bd.getLocation().getBlockX() + 1;
            int minusx = this.bd.getLocation().getBlockX() - 1;
            int y = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.bd.getLocation().getBlockY() - 1 : this.bd.getLocation().getBlockY();
            int z = this.bd.getLocation().getBlockZ();
            int plusz = this.bd.getLocation().getBlockZ() + 1;
            int minusz = this.bd.getLocation().getBlockZ() - 1;
            World world = this.bd.getLocation().getWorld();
            int signx = 0;
            int signz = 0;
            boolean hasDodgyDoor = this.preset.equals((Object)ChameleonPreset.SWAMP) || this.preset.equals((Object)ChameleonPreset.TOPSYTURVEY) || this.preset.equals((Object)ChameleonPreset.JAIL);
            boolean bl = isJunkOrToilet = this.preset.equals((Object)ChameleonPreset.JUNK_MODE) || this.preset.equals((Object)ChameleonPreset.TOILET);
            if (this.i < this.loops) {
                int yy;
                int n;
                boolean isJunk;
                BlockData[][] datas = this.preset.equals((Object)ChameleonPreset.JUNK_MODE) ? this.column.blockData() : (this.i % 2 == 0 ? this.stained_column.blockData() : (this.i % 4 == 1 ? this.glass_column.blockData() : this.column.blockData()));
                ++this.i;
                if (this.i == this.bd.getThrottle().getRescue() && this.plugin.getTrackerKeeper().getRescue().containsKey(this.bd.getTardisID())) {
                    UUID playerUUID = this.plugin.getTrackerKeeper().getRescue().get(this.bd.getTardisID());
                    Player saved = this.plugin.getServer().getPlayer(playerUUID);
                    if (saved != null) {
                        TARDISDoorLocation idl = TARDISDoorListener.getDoor(1, this.bd.getTardisID());
                        Location l = idl.getL();
                        this.plugin.getGeneralKeeper().getDoorListener().movePlayer(saved, l, false, world, false, 0, this.bd.useMinecartSounds(), false);
                        TARDISSounds.playTARDISSound(saved, "tardis_land_fast", 5L);
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("tardis_id", this.bd.getTardisID());
                        set.put("uuid", playerUUID.toString());
                        this.plugin.getQueryFactory().doInsert("travellers", set);
                    }
                    this.plugin.getTrackerKeeper().getRescue().remove(this.bd.getTardisID());
                }
                boolean isAdaptive = this.preset.equals((Object)ChameleonPreset.ADAPTIVE);
                boolean isAdaptiveFactory = this.preset.equals((Object)ChameleonPreset.FACTORY) && this.adapt.equals((Object)Adaption.BIOME);
                boolean bl2 = isJunk = this.preset.equals((Object)ChameleonPreset.JUNK_MODE) || this.preset.equals((Object)ChameleonPreset.JUNK);
                if (this.i == 1) {
                    UUID uuid;
                    ResultSetParticlePrefs rspp;
                    if (this.bd.isOutside()) {
                        if (!this.bd.useMinecartSounds()) {
                            String sound;
                            if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                                sound = "junk_land";
                            } else {
                                sound = switch (this.bd.getThrottle()) {
                                    case SpaceTimeThrottle.WARP, SpaceTimeThrottle.RAPID, SpaceTimeThrottle.FASTER -> "tardis_land_" + this.bd.getThrottle().toString().toLowerCase(Locale.ROOT);
                                    default -> "tardis_land";
                                };
                            }
                            TARDISSounds.playTARDISSound(this.bd.getLocation(), sound);
                        } else {
                            world.playSound(this.bd.getLocation(), Sound.ENTITY_MINECART_INSIDE, 1.0f, 0.0f);
                        }
                    }
                    if (this.bd.hasParticles() && this.preset != ChameleonPreset.JUNK_MODE && (rspp = new ResultSetParticlePrefs(this.plugin)).fromUUID((uuid = this.bd.getPlayer().getUniqueId()).toString())) {
                        ParticleData data = rspp.getData();
                        Emitter emitter = new Emitter(this.plugin, uuid, this.bd.getLocation(), data, this.bd.getThrottle().getFlightTime());
                        int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, data.getShape().getPeriod());
                        emitter.setTaskID(task);
                    }
                    switch (this.bd.getDirection().forPreset()) {
                        case SOUTH: {
                            signx = x;
                            signz = minusz - 1;
                            break;
                        }
                        case EAST: {
                            signx = minusx - 1;
                            signz = z;
                            break;
                        }
                        case NORTH: {
                            signx = x;
                            signz = plusz + 1;
                            break;
                        }
                        default: {
                            signx = plusx + 1;
                            signz = z;
                        }
                    }
                    for (n = 0; n < 10; ++n) {
                        int xx;
                        BlockData[] colData = datas[n];
                        int zz = switch (n) {
                            case 0 -> {
                                xx = minusx;
                                yield minusz;
                            }
                            case 1 -> {
                                xx = x;
                                yield minusz;
                            }
                            case 2 -> {
                                xx = plusx;
                                yield minusz;
                            }
                            case 3 -> {
                                xx = plusx;
                                yield z;
                            }
                            case 4 -> {
                                xx = plusx;
                                yield plusz;
                            }
                            case 5 -> {
                                xx = x;
                                yield plusz;
                            }
                            case 6 -> {
                                xx = minusx;
                                yield plusz;
                            }
                            case 7 -> {
                                xx = minusx;
                                yield z;
                            }
                            case 8 -> {
                                xx = x;
                                yield z;
                            }
                            default -> {
                                xx = signx;
                                yield signz;
                            }
                        };
                        block71: for (yy = 0; yy < 4; ++yy) {
                            Material mat;
                            boolean change = true;
                            if (yy == 0 && n == 9) {
                                Block rail = world.getBlockAt(xx, y, zz);
                                if (rail.getType().equals((Object)Material.RAIL) || rail.getType().equals((Object)Material.POWERED_RAIL)) {
                                    change = false;
                                    if (this.loops == 3) {
                                        TARDISBlockSetters.setBlock(world, xx, y, zz, rail.getBlockData());
                                    } else {
                                        TARDISBlockSetters.setBlockAndRemember(world, xx, y, zz, rail.getBlockData(), this.bd.getTardisID());
                                    }
                                } else if (this.preset.equals((Object)ChameleonPreset.SWAMP)) {
                                    this.swampSlab = rail;
                                    this.slab_data = this.column.blockData()[n][yy];
                                    change = false;
                                } else if (this.preset.equals((Object)ChameleonPreset.SUBMERGED)) {
                                    change = false;
                                }
                                if (world.getEnvironment().equals((Object)World.Environment.NETHER) || world.getEnvironment().equals((Object)World.Environment.THE_END) || world.getGenerator() instanceof TARDISChunkGenerator) {
                                    TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), false);
                                }
                            }
                            if (yy == 0 && n == 8 && !this.plugin.getPresetBuilder().no_block_under_door.contains((Object)this.preset)) {
                                TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), true);
                            }
                            if (this.preset.equals((Object)ChameleonPreset.DUCK) && yy == 2 && n == 9) {
                                this.swampDoorBottom = world.getBlockAt(xx, y + yy, zz);
                            }
                            if (Tag.STANDING_SIGNS.isTagged((Keyed)(mat = colData[yy].getMaterial())) && this.preset.equals((Object)ChameleonPreset.APPERTURE)) {
                                TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), false);
                                continue;
                            }
                            if (Tag.WALL_SIGNS.isTagged((Keyed)mat)) {
                                String line2;
                                String line1;
                                if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                                    String location = new Location(world, (double)xx, (double)(y + yy), (double)zz).toString();
                                    this.plugin.getGeneralKeeper().getProtectBlockMap().put(location, this.bd.getTardisID());
                                    TARDISMaterialisePreset.saveJunkControl(location, "save_sign", this.bd.getTardisID());
                                    Block sign = world.getBlockAt(xx, y + yy, zz);
                                    if (!Tag.WALL_SIGNS.isTagged((Keyed)sign.getType())) continue;
                                    Sign s2 = (Sign)sign.getState();
                                    SignSide front = s2.getSide(Side.FRONT);
                                    SignSide back = s2.getSide(Side.BACK);
                                    front.line(0, (Component)Component.text((String)"TARDIS"));
                                    front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").getFirst())));
                                    front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").get(1))));
                                    front.line(3, (Component)Component.empty());
                                    back.line(0, (Component)Component.text((String)"TARDIS"));
                                    back.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").getFirst())));
                                    back.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").get(1))));
                                    back.line(3, (Component)Component.empty());
                                    s2.setWaxed(true);
                                    s2.update();
                                    continue;
                                }
                                if (!this.bd.shouldAddSign()) continue;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                                Block sign = world.getBlockAt(xx, y + yy, zz);
                                if (!Tag.SIGNS.isTagged((Keyed)sign.getType())) continue;
                                Sign s3 = (Sign)sign.getState();
                                SignSide front = s3.getSide(Side.FRONT);
                                this.plugin.getGeneralKeeper().getProtectBlockMap().put(sign.getLocation().toString(), this.bd.getTardisID());
                                if (this.plugin.getConfig().getBoolean("police_box.name_tardis")) {
                                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                                    wheret.put("tardis_id", this.bd.getTardisID());
                                    ResultSetTardis rst = new ResultSetTardis(this.plugin, wheret, "", false);
                                    if (rst.resultSet()) {
                                        Tardis tardis = rst.getTardis();
                                        String player_name = TARDISStaticUtils.getNick(tardis.getUuid());
                                        if (player_name == null) {
                                            player_name = tardis.getOwner();
                                        }
                                        Object owner = this.preset.equals((Object)ChameleonPreset.GRAVESTONE) || this.preset.equals((Object)ChameleonPreset.PUNKED) || this.preset.equals((Object)ChameleonPreset.ROBOT) ? (player_name.length() > 14 ? player_name.substring(0, 14) : player_name) : (player_name.length() > 14 ? player_name.substring(0, 12) + "'s" : player_name + "'s");
                                        switch (this.preset) {
                                            case GRAVESTONE: {
                                                front.line(3, (Component)Component.text((String)owner));
                                                break;
                                            }
                                            case ANGEL: 
                                            case JAIL: {
                                                front.line(2, (Component)Component.text((String)owner));
                                                break;
                                            }
                                            default: {
                                                front.line(0, (Component)Component.text((String)owner));
                                            }
                                        }
                                    }
                                }
                                if (this.preset.equals((Object)ChameleonPreset.CUSTOM)) {
                                    line1 = this.plugin.getPresets().custom.getFirstLine();
                                    line2 = this.plugin.getPresets().custom.getSecondLine();
                                } else {
                                    line1 = this.preset.getFirstLine();
                                    line2 = this.preset.getSecondLine();
                                }
                                switch (this.preset) {
                                    case ANGEL: {
                                        front.line(0, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                        front.line(1, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                        front.line(3, (Component)Component.text((String)"TARDIS", (TextColor)this.sign_colour));
                                        break;
                                    }
                                    case APPERTURE: {
                                        front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                        front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                        front.line(3, (Component)Component.text((String)"LAB", (TextColor)this.sign_colour));
                                        break;
                                    }
                                    case JAIL: {
                                        front.line(0, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                        front.line(1, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                        front.line(3, (Component)Component.text((String)"CAPTURE", (TextColor)this.sign_colour));
                                        break;
                                    }
                                    case THEEND: {
                                        front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                        front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                        front.line(3, (Component)Component.text((String)"HOT ROD", (TextColor)this.sign_colour));
                                        break;
                                    }
                                    case CONSTRUCT: {
                                        ResultSetConstructSign rscs = new ResultSetConstructSign(this.plugin, this.bd.getTardisID());
                                        if (!rscs.resultSet()) break;
                                        if (rscs.getLine1().isEmpty() && rscs.getLine2().isEmpty() && rscs.getLine3().isEmpty() && rscs.getLine4().isEmpty()) {
                                            front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                            front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                            break;
                                        }
                                        front.line(0, (Component)Component.text((String)rscs.getLine1()));
                                        front.line(1, (Component)Component.text((String)rscs.getLine2()));
                                        front.line(2, (Component)Component.text((String)rscs.getLine3()));
                                        front.line(3, (Component)Component.text((String)rscs.getLine4()));
                                        break;
                                    }
                                    default: {
                                        front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                        front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                    }
                                }
                                s3.setWaxed(true);
                                s3.update();
                                continue;
                            }
                            if (Tag.DOORS.isTagged((Keyed)mat) || Tag.TRAPDOORS.isTagged((Keyed)mat) || mat == Material.RAIL || Tag.BUTTONS.isTagged((Keyed)mat) && this.preset.equals((Object)ChameleonPreset.CONSTRUCT)) {
                                boolean door = false;
                                if (Tag.DOORS.isTagged((Keyed)mat)) {
                                    Bisected bisected = (Bisected)colData[yy];
                                    door = bisected.getHalf().equals((Object)Bisected.Half.BOTTOM);
                                }
                                if (Tag.TRAPDOORS.isTagged((Keyed)mat) || Tag.BUTTONS.isTagged((Keyed)mat)) {
                                    door = true;
                                }
                                Block doorBlock = world.getBlockAt(xx, y + yy, zz);
                                if (door) {
                                    this.saveDoorLocation(world, xx, y, yy, zz);
                                    if (!Tag.BUTTONS.isTagged((Keyed)mat)) {
                                        String under = doorBlock.getRelative(BlockFace.DOWN).getLocation().toString();
                                        this.plugin.getGeneralKeeper().getProtectBlockMap().put(under, this.bd.getTardisID());
                                        TARDISBlockSetters.rememberBlock(world, xx, y - 1, zz, this.bd.getTardisID());
                                    }
                                } else {
                                    String doorStr = doorBlock.getLocation().toString();
                                    this.plugin.getGeneralKeeper().getProtectBlockMap().put(doorStr, this.bd.getTardisID());
                                }
                                if (yy == 0) {
                                    if (this.bd.isSubmarine() && this.plugin.isWorldGuardOnServer()) {
                                        int sy = y - 1;
                                        TARDISBlockSetters.setBlockAndRemember(world, xx, sy, zz, Material.SPONGE, this.bd.getTardisID());
                                        Block sponge = world.getBlockAt(xx, sy, zz);
                                        TARDISSponge.removeWater(sponge);
                                    } else if (!this.plugin.getPresetBuilder().no_block_under_door.contains((Object)this.preset)) {
                                        TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), false);
                                    }
                                }
                                if (hasDodgyDoor) {
                                    if (door) {
                                        this.swampDoorBottom = world.getBlockAt(xx, y + yy, zz);
                                        this.sdb_data = colData[yy];
                                        continue;
                                    }
                                    this.swampDoorTop = world.getBlockAt(xx, y + yy, zz);
                                    this.sdt_data = colData[yy];
                                    continue;
                                }
                                TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                                continue;
                            }
                            switch (mat) {
                                case DIRT: 
                                case GRASS_BLOCK: {
                                    BlockData subi = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.data : colData[yy];
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, subi, this.bd.getTardisID());
                                    continue block71;
                                }
                                case WHITE_WOOL: {
                                    Material flower = this.preset.equals((Object)ChameleonPreset.FLOWER) ? this.random_colour : mat;
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, flower, this.bd.getTardisID());
                                    continue block71;
                                }
                                case LIME_WOOL: {
                                    Material party = this.preset.equals((Object)ChameleonPreset.PARTY) ? this.random_colour : mat;
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, party, this.bd.getTardisID());
                                    continue block71;
                                }
                                case BLUE_WOOL: {
                                    BlockData old = isAdaptive && this.adapt.equals((Object)Adaption.BLOCK) ? this.data : colData[yy];
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, old, this.bd.getTardisID());
                                    continue block71;
                                }
                                case TORCH: 
                                case GLOWSTONE: 
                                case REDSTONE_LAMP: {
                                    BlockData light = this.bd.isSubmarine() && mat.equals((Object)Material.TORCH) ? Material.GLOWSTONE.createBlockData() : colData[yy];
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, light, this.bd.getTardisID());
                                    continue block71;
                                }
                                case LEVER: {
                                    if (!this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) continue block71;
                                    this.handbrake = world.getBlockAt(xx, y + yy, zz);
                                    this.plugin.getGeneralKeeper().getProtectBlockMap().put(this.handbrake.getLocation().toString(), this.bd.getTardisID());
                                    this.h_data = colData[yy];
                                    continue block71;
                                }
                                case SKELETON_SKULL: {
                                    if (this.bd.isSubmarine()) {
                                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, Material.GLOWSTONE);
                                        continue block71;
                                    }
                                    Rotatable rotatable = (Rotatable)colData[yy];
                                    rotatable.setRotation(this.plugin.getPresetBuilder().getSkullDirection(this.bd.getDirection().forPreset()));
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, (BlockData)rotatable, this.bd.getTardisID());
                                    continue block71;
                                }
                                case LIGHT_GRAY_TERRACOTTA: {
                                    BlockData chai = isAdaptiveFactory ? this.data : colData[yy];
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, chai, this.bd.getTardisID());
                                    continue block71;
                                }
                                default: {
                                    if (!change) continue block71;
                                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                                }
                            }
                        }
                    }
                }
                if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE) && this.plugin.getConfig().getBoolean("junk.particles")) {
                    this.plugin.getUtils().getJunkTravellers(this.bd.getLocation()).forEach(e -> {
                        if (e instanceof Player) {
                            Player p = (Player)e;
                            Location effectsLoc = this.bd.getLocation().clone().add(0.5, 0.0, 0.5);
                            TARDISParticles.sendVortexParticles(effectsLoc, p);
                        }
                    });
                }
                for (n = 0; n < 9; ++n) {
                    int xx;
                    BlockData[] coldatas = datas[n];
                    int zz = switch (n) {
                        case 0 -> {
                            xx = minusx;
                            yield minusz;
                        }
                        case 1 -> {
                            xx = x;
                            yield minusz;
                        }
                        case 2 -> {
                            xx = plusx;
                            yield minusz;
                        }
                        case 3 -> {
                            xx = plusx;
                            yield z;
                        }
                        case 4 -> {
                            xx = plusx;
                            yield plusz;
                        }
                        case 5 -> {
                            xx = x;
                            yield plusz;
                        }
                        case 6 -> {
                            xx = minusx;
                            yield plusz;
                        }
                        case 7 -> {
                            xx = minusx;
                            yield z;
                        }
                        case 8 -> {
                            xx = x;
                            yield z;
                        }
                        default -> {
                            xx = signx;
                            yield signz;
                        }
                    };
                    block73: for (yy = 0; yy < 4; ++yy) {
                        Material mat = coldatas[yy].getMaterial();
                        switch (mat) {
                            case DIRT: 
                            case GRASS_BLOCK: {
                                BlockData subi = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.data : coldatas[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, subi);
                                continue block73;
                            }
                            case BEDROCK: {
                                if (this.preset.equals((Object)ChameleonPreset.THEEND) && this.i == this.loops) {
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, coldatas[yy]);
                                    world.getBlockAt(xx, y + yy + 1, zz).setBlockData(TARDISConstants.FIRE);
                                    continue block73;
                                }
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, coldatas[yy]);
                                continue block73;
                            }
                            case ACACIA_SAPLING: 
                            case ALLIUM: 
                            case AZURE_BLUET: 
                            case BAMBOO_SAPLING: 
                            case BEETROOTS: 
                            case BIRCH_SAPLING: 
                            case BLUE_ORCHID: 
                            case CARROTS: 
                            case CORNFLOWER: 
                            case CRIMSON_FUNGUS: 
                            case CRIMSON_ROOTS: 
                            case DANDELION: 
                            case DARK_OAK_SAPLING: 
                            case DEAD_BUSH: 
                            case FERN: 
                            case SHORT_GRASS: 
                            case JUNGLE_SAPLING: 
                            case LARGE_FERN: 
                            case LILAC: 
                            case LILY_OF_THE_VALLEY: 
                            case OAK_SAPLING: 
                            case ORANGE_TULIP: 
                            case OXEYE_DAISY: 
                            case PEONY: 
                            case PINK_TULIP: 
                            case POPPY: 
                            case POTATOES: 
                            case RED_TULIP: 
                            case ROSE_BUSH: 
                            case SPRUCE_SAPLING: 
                            case SUGAR_CANE: 
                            case SUNFLOWER: 
                            case SWEET_BERRY_BUSH: 
                            case TALL_GRASS: 
                            case WARPED_FUNGUS: 
                            case WARPED_ROOTS: 
                            case WHEAT: 
                            case WHITE_TULIP: 
                            case WITHER_ROSE: {
                                if (this.i == this.loops && (this.preset.equals((Object)ChameleonPreset.GRAVESTONE) || this.preset.equals((Object)ChameleonPreset.MESA) || this.preset.equals((Object)ChameleonPreset.PLAINS) || this.preset.equals((Object)ChameleonPreset.TAIGA) || this.preset.equals((Object)ChameleonPreset.CONSTRUCT) || this.preset.equals((Object)ChameleonPreset.CUSTOM))) {
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, coldatas[yy]);
                                    continue block73;
                                }
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, Material.AIR);
                                continue block73;
                            }
                            case WHITE_WOOL: {
                                Material flower = this.preset.equals((Object)ChameleonPreset.FLOWER) ? this.random_colour : mat;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, flower);
                                continue block73;
                            }
                            case LIME_WOOL: {
                                Material party = this.preset.equals((Object)ChameleonPreset.PARTY) ? this.random_colour : mat;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, party);
                                continue block73;
                            }
                            case BLUE_WOOL: {
                                if (this.adapt.equals((Object)Adaption.BLOCK) && (this.preset.equals((Object)ChameleonPreset.ADAPTIVE) || this.preset.equals((Object)ChameleonPreset.SUBMERGED))) {
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, this.data);
                                    continue block73;
                                }
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, mat);
                                continue block73;
                            }
                            case TORCH: 
                            case GLOWSTONE: 
                            case REDSTONE_LAMP: {
                                Material light = this.bd.isSubmarine() && mat.equals((Object)Material.TORCH) ? Material.GLOWSTONE : mat;
                                BlockData lamp = light.createBlockData();
                                if (lamp instanceof Lightable) {
                                    Lightable lightable = (Lightable)lamp;
                                    lightable.setLit(true);
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, (BlockData)lightable);
                                    continue block73;
                                }
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, lamp);
                                continue block73;
                            }
                            case IRON_DOOR: 
                            case ACACIA_DOOR: 
                            case ACACIA_TRAPDOOR: 
                            case BAMBOO_DOOR: 
                            case BAMBOO_TRAPDOOR: 
                            case BIRCH_DOOR: 
                            case BIRCH_TRAPDOOR: 
                            case CHERRY_DOOR: 
                            case CHERRY_TRAPDOOR: 
                            case CRIMSON_DOOR: 
                            case CRIMSON_TRAPDOOR: 
                            case DARK_OAK_DOOR: 
                            case DARK_OAK_TRAPDOOR: 
                            case JUNGLE_DOOR: 
                            case JUNGLE_TRAPDOOR: 
                            case MANGROVE_DOOR: 
                            case MANGROVE_TRAPDOOR: 
                            case OAK_DOOR: 
                            case OAK_TRAPDOOR: 
                            case SPRUCE_DOOR: 
                            case SPRUCE_TRAPDOOR: 
                            case WARPED_DOOR: 
                            case WARPED_TRAPDOOR: {
                                continue block73;
                            }
                            case LEVER: {
                                if (!isJunkOrToilet) continue block73;
                                this.handbrake = world.getBlockAt(xx, y + yy, zz);
                                this.h_data = coldatas[yy];
                                continue block73;
                            }
                            case NETHERRACK: {
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, coldatas[yy]);
                                if (!this.preset.equals((Object)ChameleonPreset.TORCH) || this.i != this.loops) continue block73;
                                world.getBlockAt(xx, y + yy + 1, zz).setBlockData(TARDISConstants.FIRE);
                                continue block73;
                            }
                            case NETHER_PORTAL: {
                                TARDISBlockSetters.setBlock(world, xx, y + yy + 1, zz, Material.OBSIDIAN);
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, coldatas[yy]);
                                continue block73;
                            }
                            case LIGHT_GRAY_STAINED_GLASS: {
                                Material chag = isAdaptiveFactory ? TARDISStainedGlassLookup.stainedGlassFromMaterial(world, this.data.getMaterial()) : mat;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chag);
                                continue block73;
                            }
                            case WHITE_STAINED_GLASS: {
                                Material chaw = this.preset.equals((Object)ChameleonPreset.FLOWER) ? this.random_glass : mat;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chaw);
                                continue block73;
                            }
                            case LIME_STAINED_GLASS: {
                                Material chal = this.preset.equals((Object)ChameleonPreset.PARTY) ? this.random_glass : mat;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chal);
                                continue block73;
                            }
                            case BLUE_STAINED_GLASS: {
                                Material chad = this.preset.equals((Object)ChameleonPreset.ADAPTIVE) && this.adapt.equals((Object)Adaption.BLOCK) || this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? TARDISStainedGlassLookup.stainedGlassFromMaterial(world, this.data.getMaterial()) : mat;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chad);
                                continue block73;
                            }
                            case SKELETON_SKULL: {
                                if (this.bd.isSubmarine()) {
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, Material.GLOWSTONE);
                                    continue block73;
                                }
                                Rotatable rotatable = (Rotatable)coldatas[yy];
                                rotatable.setRotation(this.plugin.getPresetBuilder().getSkullDirection(this.bd.getDirection().forPreset()));
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, (BlockData)rotatable);
                                continue block73;
                            }
                            case LIGHT_GRAY_TERRACOTTA: {
                                BlockData chai = this.preset.equals((Object)ChameleonPreset.FACTORY) ? this.data : coldatas[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chai);
                                continue block73;
                            }
                            default: {
                                if (isJunk && mat.equals((Object)Material.ORANGE_WOOL) && this.i == this.loops) {
                                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, TARDISConstants.BARRIER);
                                    TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.HEXAGON, world, xx, y + yy, zz);
                                    continue block73;
                                }
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, coldatas[yy]);
                            }
                        }
                    }
                }
            } else {
                if (this.preset.equals((Object)ChameleonPreset.DUCK) && this.swampDoorBottom != null) {
                    this.swampDoorBottom.setBlockData(this.column.blockData()[9][2]);
                }
                if (hasDodgyDoor && this.swampDoorBottom != null) {
                    TARDISBlockSetters.setBlockAndRemember(world, this.swampDoorBottom.getX(), this.swampDoorBottom.getY(), this.swampDoorBottom.getZ(), this.sdb_data, this.bd.getTardisID());
                    TARDISBlockSetters.setBlockAndRemember(world, this.swampDoorTop.getX(), this.swampDoorTop.getY(), this.swampDoorTop.getZ(), this.sdt_data, this.bd.getTardisID());
                    if (this.preset.equals((Object)ChameleonPreset.SWAMP)) {
                        TARDISBlockSetters.setBlockAndRemember(world, this.swampSlab.getX(), this.swampSlab.getY(), this.swampSlab.getZ(), this.slab_data, this.bd.getTardisID());
                    }
                }
                if (isJunkOrToilet) {
                    this.handbrake.setBlockData(this.h_data);
                    String location = this.handbrake.getLocation().toString();
                    TARDISMaterialisePreset.saveJunkControl(location, "handbrake", this.bd.getTardisID());
                }
                this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = 0;
                this.plugin.getTrackerKeeper().getMalfunction().remove(this.bd.getTardisID());
                if (this.plugin.getTrackerKeeper().getDidDematToVortex().contains(this.bd.getTardisID())) {
                    this.plugin.getTrackerKeeper().getDidDematToVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
                }
                if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.bd.getTardisID())) {
                    int taskID = this.plugin.getTrackerKeeper().getDestinationVortex().get(this.bd.getTardisID());
                    this.plugin.getServer().getScheduler().cancelTask(taskID);
                    this.plugin.getTrackerKeeper().getDestinationVortex().remove(this.bd.getTardisID());
                }
                if (!this.bd.isRebuild() && this.bd.getPlayer() != null) {
                    this.plugin.getTrackerKeeper().getActiveForceFields().remove(this.bd.getPlayer().getPlayer().getUniqueId());
                }
                if (this.loops > 3) {
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("tardis_id", this.bd.getTardisID());
                    ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, true);
                    if (rst.resultSet()) {
                        List<UUID> travellers = rst.getData();
                        travellers.forEach(s -> {
                            Player p = this.plugin.getServer().getPlayer(s);
                            if (p != null) {
                                String message = this.bd.isMalfunction() ? "MALFUNCTION" : "HANDBRAKE_LEFT_CLICK";
                                this.plugin.getMessenger().sendStatus(p, message);
                                this.plugin.getTrackerKeeper().getHasTravelled().add((UUID)s);
                            }
                        });
                    } else if (this.plugin.getTrackerKeeper().getJunkPlayers().containsKey(this.bd.getPlayer().getUniqueId())) {
                        this.plugin.getMessenger().send((CommandSender)this.bd.getPlayer().getPlayer(), TardisModule.TARDIS, "JUNK_HANDBRAKE_LEFT_CLICK");
                    }
                    HashMap<String, Object> whereb = new HashMap<String, Object>();
                    whereb.put("tardis_id", this.bd.getTardisID());
                    whereb.put("police_box", 2);
                    ResultSetBlocks rs = new ResultSetBlocks(this.plugin, whereb, false);
                    rs.resultSetAsync((hasResult, resultSetBlocks) -> {
                        if (hasResult) {
                            ReplacedBlock rb = resultSetBlocks.getReplacedBlock();
                            TARDISBlockSetters.setBlock(rb.getLocation(), rb.getBlockData());
                            HashMap<String, Object> whered = new HashMap<String, Object>();
                            whered.put("tardis_id", this.bd.getTardisID());
                            whered.put("police_box", 2);
                            this.plugin.getQueryFactory().doDelete("blocks", whered);
                        }
                    });
                    this.plugin.getTrackerKeeper().getHadsDamage().remove(this.bd.getTardisID());
                    TARDISBuilderUtility.updateChameleonDemat(this.preset.toString(), this.bd.getTardisID());
                }
            }
        }
    }

    private void saveDoorLocation(World world, int xx, int y, int yy, int zz) {
        String doorloc = world.getName() + ":" + xx + ":" + (y + yy) + ":" + zz;
        String doorStr = world.getBlockAt(xx, y + yy, zz).getLocation().toString();
        this.plugin.getGeneralKeeper().getProtectBlockMap().put(doorStr, this.bd.getTardisID());
        HashMap<String, Object> whered = new HashMap<String, Object>();
        whered.put("door_type", 0);
        whered.put("tardis_id", this.bd.getTardisID());
        ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
        HashMap<String, Object> setd = new HashMap<String, Object>();
        setd.put("door_location", doorloc);
        setd.put("door_direction", this.bd.getDirection().forPreset().toString());
        if (rsd.resultSet()) {
            HashMap<String, Object> whereid = new HashMap<String, Object>();
            whereid.put("door_id", rsd.getDoor_id());
            this.plugin.getQueryFactory().doUpdate("doors", setd, whereid);
        } else {
            setd.put("tardis_id", this.bd.getTardisID());
            setd.put("door_type", 0);
            this.plugin.getQueryFactory().doInsert("doors", setd);
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

