/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.utility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDISConstants;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class FractalFence {
    public static void grow(Block start, int i) {
        Material material = start.getType();
        for (Location location : FractalFence.getPoints(start.getLocation(), i)) {
            Block block = location.getBlock();
            if (!block.getType().isAir()) continue;
            block.setType(material, true);
        }
    }

    private static Set<Location> getPoints(Location location, int i) {
        ArrayList<Vector> points = new ArrayList<Vector>();
        points.add(location.toVector());
        HashSet<Location> adjacent = new HashSet<Location>();
        World world = location.getWorld();
        int minx = location.getBlockX();
        int miny = location.getBlockY() + 1;
        int minz = location.getBlockZ();
        switch (i) {
            case 1: {
                minx -= 4;
                minz -= 4;
                break;
            }
            case 2: {
                minx -= 4;
                --minz;
                break;
            }
            case 3: {
                --minx;
                minz -= 4;
                break;
            }
            default: {
                --minx;
                --minz;
            }
        }
        for (int n = 0; n < 60; ++n) {
            int rx = minx + TARDISConstants.RANDOM.nextInt(6);
            int ry = miny + TARDISConstants.RANDOM.nextInt(5);
            int rz = minz + TARDISConstants.RANDOM.nextInt(6);
            points.add(new Vector(rx, ry, rz));
        }
        for (int j = 0; j < points.size() - 1; ++j) {
            for (int k = 1; k < points.size(); ++k) {
                Vector a = (Vector)points.get(j);
                Vector b = (Vector)points.get(k);
                int diff = Math.abs(a.getBlockX() - b.getBlockX()) + Math.abs(a.getBlockY() - b.getBlockY()) + Math.abs(a.getBlockZ() - b.getBlockZ());
                if (diff != 1) continue;
                adjacent.add(new Location(world, (double)a.getBlockX(), (double)a.getBlockY(), (double)a.getBlockZ()));
            }
        }
        return adjacent;
    }
}

