/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISDestructionEvent;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.destroyers.TARDISExterminator;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.files.TARDISBlockLoader;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISDeleteCommand {
    private final TARDIS plugin;

    TARDISDeleteCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static void cleanDatabase(int id) {
        TARDISBlockLoader bl = new TARDISBlockLoader(TARDIS.plugin);
        bl.unloadProtectedBlocks(id);
        List<String> tables = List.of("ars", "back", "chunks", "controls", "current", "destinations", "doors", "gravity_well", "homes", "junk", "lamps", "next", "tardis", "thevoid", "travellers", "vaults");
        tables.forEach(table -> {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            TARDIS.plugin.getQueryFactory().doDelete((String)table, where);
        });
    }

    boolean deleteTARDIS(CommandSender sender, String[] args) {
        World cw;
        String wname;
        Schematic schm;
        int tips;
        int id;
        boolean junk = args[1].toLowerCase(Locale.ROOT).equals("junk");
        int tmp = -1;
        int abandoned = args.length > 2 && args[2].equals("abandoned") ? 1 : 0;
        try {
            tmp = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        OfflinePlayer player = null;
        if (tmp == -1) {
            UUID uuid;
            if (junk) {
                uuid = UUID.fromString("00000000-aaaa-bbbb-cccc-000000000000");
            } else {
                player = this.plugin.getServer().getOfflinePlayer(args[1]);
                uuid = player.getUniqueId();
            }
            where.put("uuid", uuid.toString());
        } else {
            where.put("tardis_id", tmp);
        }
        where.put("abandoned", abandoned);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            if (player == null) {
                player = this.plugin.getServer().getOfflinePlayer(tardis.getUuid());
            }
            id = tardis.getTardisId();
            tips = tardis.getTIPS();
            schm = tardis.getSchematic();
            String chunkLoc = tardis.getChunk();
            boolean hidden = tardis.isHidden();
            String[] cdata = chunkLoc.split(":");
            wname = junk ? this.plugin.getConfig().getString("creation.default_world_name") : cdata[0];
            cw = TARDISAliasResolver.getWorldFromAlias(wname);
            if (cw == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_DELETED");
                return true;
            }
            Location bb_loc = null;
            COMPASS d = COMPASS.EAST;
            boolean sub = false;
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (rsc.resultSet()) {
                Current current = rsc.getCurrent();
                bb_loc = current.location();
                d = current.direction();
                sub = current.submarine();
            }
            if (bb_loc == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            this.plugin.getPM().callEvent((Event)new TARDISDestructionEvent(player.getPlayer(), bb_loc, tardis.getOwner()));
            if (!hidden) {
                UUID u = rs.getTardis().getUuid();
                DestroyData dd = new DestroyData();
                dd.setDirection(d);
                dd.setLocation(bb_loc);
                dd.setPlayer(this.plugin.getServer().getOfflinePlayer(u));
                dd.setHide(true);
                dd.setOutside(false);
                dd.setSubmarine(sub);
                dd.setTardisID(id);
                dd.setThrottle(SpaceTimeThrottle.REBUILD);
                this.plugin.getPresetDestroyer().destroyPreset(dd);
            }
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PLAYER_NOT_FOUND_DB", args[1]);
            return true;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (this.plugin.getConfig().getBoolean("creation.create_worlds") && !this.plugin.getConfig().getBoolean("creation.default_world") || wname.contains("TARDIS_WORLD_")) {
                List players = cw.getPlayers();
                players.forEach(p -> p.kick((Component)Component.text((String)"World scheduled for deletion!")));
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + String.valueOf(cw) + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE)) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "mv remove " + wname);
                }
                this.plugin.getServer().unloadWorld(cw, true);
                File world_folder = new File(String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + wname + File.separator);
                if (!TARDISExterminator.deleteFolder(world_folder)) {
                    this.plugin.debug("Could not delete world <" + wname + ">");
                }
            } else {
                this.plugin.getInteriorDestroyer().destroyInner(schm, id, cw, tips);
            }
            TARDISDeleteCommand.cleanDatabase(id);
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_EXTERMINATED");
        }, 40L);
        return true;
    }
}

