/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.admin.TARDISAbandonLister;
import me.eccentric_nz.TARDIS.commands.admin.TARDISBlueprintLister;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISListCommand {
    private final TARDIS plugin;

    TARDISListCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean listStuff(CommandSender sender, String[] args) {
        if (args.length > 1 && (args[1].equalsIgnoreCase("save") || args[1].equalsIgnoreCase("portals") || args[1].equalsIgnoreCase("abandoned"))) {
            if (args[1].equalsIgnoreCase("save")) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("abandoned", 1);
                ResultSetTardis rsl = new ResultSetTardis(this.plugin, where, "", true);
                if (rsl.resultSet()) {
                    String file = String.valueOf(this.plugin.getDataFolder()) + File.separator + "TARDIS_list.txt";
                    try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
                        for (Tardis tardis : rsl.getData()) {
                            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, tardis.getTardisId());
                            if (!rsc.resultSet()) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                                boolean bl = true;
                                return bl;
                            }
                            Current current = rsc.getCurrent();
                            String line = "ID: " + tardis.getTardisId() + ", Time Lord: " + tardis.getOwner() + ", Location: " + current.location().getWorld().getName() + ":" + current.location().getBlockX() + ":" + current.location().getBlockY() + ":" + current.location().getBlockZ();
                            bw.write(line);
                            bw.newLine();
                        }
                    }
                    catch (IOException e) {
                        this.plugin.debug("Could not create and write to TARDIS_list.txt! " + e.getMessage());
                    }
                }
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "FILE_SAVED");
                return true;
            }
            if (args[1].equalsIgnoreCase("portals")) {
                this.plugin.getTrackerKeeper().getPortals().forEach((key, value) -> sender.sendMessage("TARDIS id: " + value.getTardisId() + " has a portal open at: " + key.toString()));
                return true;
            }
            if (!args[1].equalsIgnoreCase("abandoned")) return false;
            new TARDISAbandonLister(this.plugin).list(sender);
            return true;
        }
        if (args.length > 2 && args[1].equalsIgnoreCase("blueprints")) {
            new TARDISBlueprintLister(this.plugin).list(sender, args[2]);
            return true;
        }
        int start = 0;
        int end = 18;
        if (args.length > 1) {
            int tmp = TARDISNumberParsers.parseInt(args[1]);
            start = tmp * 18 - 18;
            end = tmp * 18;
        }
        String limit = start + ", " + end;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("abandoned", 0);
        ResultSetTardis rsl = new ResultSetTardis(this.plugin, where, limit, true);
        if (!rsl.resultSet()) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_LOCS_NONE");
            return true;
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_LOCS");
        if (sender instanceof Player) {
            this.plugin.getMessenger().message(sender, "Hover to see location (world x, y, z)");
            this.plugin.getMessenger().message(sender, "Click to enter the TARDIS");
        }
        this.plugin.getMessenger().message(sender, "");
        Iterator<Tardis> iterator = rsl.getData().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (rsl.getData().size() <= 18) return true;
                this.plugin.getMessenger().sendColouredCommand(sender, "TARDIS_LOCS_INFO", "/tardisadmin list 2", this.plugin);
                return true;
            }
            Tardis tardis = iterator.next();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, tardis.getTardisId());
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().message(sender, TardisModule.TARDIS, Component.text((String)(tardis.getTardisId() + " "), (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)(tardis.getOwner() + " TARDIS is in an unloaded world!"), (TextColor)NamedTextColor.WHITE)));
                continue;
            }
            Current current = rsc.getCurrent();
            String world = !this.plugin.getPlanetsConfig().getBoolean("planets." + current.location().getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(current.location().getWorld()) : TARDISAliasResolver.getWorldAlias(current.location().getWorld());
            this.plugin.getMessenger().sendTARDISForList(sender, tardis, world, current.location().getBlockX(), current.location().getBlockY(), current.location().getBlockZ());
        }
    }
}

