/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

class TARDISConfigOptionsCommand {
    private final TARDIS plugin;
    private final List<String> sections = new ArrayList<String>();

    TARDISConfigOptionsCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.sections.addAll(this.plugin.getConfig().getDefaultSection().getKeys(false));
        this.sections.remove("debug");
    }

    boolean showConfigOptions(CommandSender sender, String[] args) {
        String section = args[1].toLowerCase(Locale.ROOT);
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG");
        if (this.sections.contains(section)) {
            this.plugin.getMessenger().messageWithColour(sender, section + ":", "#55FFFF");
            Set options = this.plugin.getConfig().getConfigurationSection(section).getKeys(false);
            options.forEach(o -> {
                if (this.plugin.getConfig().isConfigurationSection(section + "." + o)) {
                    this.plugin.getMessenger().messageWithColour(sender, "    " + o + ":", "#55FF55");
                    for (String indent : this.plugin.getConfig().getConfigurationSection(section + "." + o).getKeys(false)) {
                        this.plugin.getMessenger().messageWithColour(sender, "        " + indent + ": " + this.plugin.getConfig().getString(section + "." + o + "." + indent), "#55FF55");
                    }
                } else {
                    this.plugin.getMessenger().messageWithColour(sender, "    " + o + ": " + this.plugin.getConfig().getString(section + "." + o), "#55FF55");
                }
            });
            return true;
        }
        switch (section) {
            case "worlds": {
                this.plugin.getMessenger().messageWithColour(sender, section + ":", "#55FFFF");
                Set worldNames = this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false);
                worldNames.forEach(wname -> {
                    String enabled = this.plugin.getPlanetsConfig().getString("planets." + wname + ".time_travel");
                    this.plugin.getMessenger().sendWithColours(sender, "    " + wname + ": ", "#55FF55", enabled, "#FFFFFF");
                });
                return true;
            }
            case "rechargers": {
                this.plugin.getMessenger().messageWithColour(sender, section + ":", "#55FFFF");
                Set chargerNames = this.plugin.getConfig().getConfigurationSection("rechargers").getKeys(false);
                chargerNames.forEach(charname -> {
                    this.plugin.getMessenger().messageWithColour(sender, "    " + charname + ":", "#55FF55");
                    sender.sendMessage("        world: " + this.plugin.getConfig().getString("rechargers." + charname + ".world"));
                    sender.sendMessage("        x: " + this.plugin.getConfig().getString("rechargers." + charname + ".x"));
                    sender.sendMessage("        y: " + this.plugin.getConfig().getString("rechargers." + charname + ".y"));
                    sender.sendMessage("        z: " + this.plugin.getConfig().getString("rechargers." + charname + ".z"));
                });
                return true;
            }
            case "rooms": {
                this.plugin.getMessenger().messageWithColour(sender, section + ":", "#55FFFF");
                Set roomNames = this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false);
                roomNames.forEach(r -> {
                    this.plugin.getMessenger().messageWithColour(sender, "    " + r + ":", "#55FF55");
                    sender.sendMessage("        enabled: " + this.plugin.getRoomsConfig().getString("rooms." + r + ".enabled"));
                    sender.sendMessage("        cost: " + this.plugin.getRoomsConfig().getString("rooms." + r + ".cost"));
                    sender.sendMessage("        offset: " + this.plugin.getRoomsConfig().getString("rooms." + r + ".offset"));
                    sender.sendMessage("        seed: " + this.plugin.getRoomsConfig().getString("rooms." + r + ".seed"));
                });
                return true;
            }
        }
        return false;
    }
}

