/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.remote;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitDamager;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.commands.remote.TARDISRemoteBackCommand;
import me.eccentric_nz.TARDIS.commands.remote.TARDISRemoteComehereCommand;
import me.eccentric_nz.TARDIS.commands.remote.TARDISRemoteHideCommand;
import me.eccentric_nz.TARDIS.commands.remote.TARDISRemoteRebuildCommand;
import me.eccentric_nz.TARDIS.commands.remote.TARDISRemoteTravelCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISHideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRebuildCommand;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.Remote;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISRemoteCommands
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"travel", (Object)"comehere", (Object)"hide", (Object)"rebuild", (Object)"back");
    private final ImmutableList<String> TRAVEL_SUBS = ImmutableList.of((Object)"home", (Object)"area");
    private final List<String> AREA_SUBS = new ArrayList<String>();

    public TARDISRemoteCommands(TARDIS plugin) {
        this.plugin = plugin;
        ResultSetAreas rsa = new ResultSetAreas(plugin, null, false, true);
        if (rsa.resultSet()) {
            this.AREA_SUBS.addAll(rsa.getNames());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisremote") && TARDISPermission.hasPermission(sender, "tardis.remote")) {
            if (args.length < 2) {
                new TARDISCommandHelper(this.plugin).getCommand("tardisremote", sender);
                return true;
            }
            UUID uuid = this.plugin.getServer().getOfflinePlayer(args[0]).getUniqueId();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(tardis.getTardisId())) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SIEGE_NO_CMD");
                    return true;
                }
                int id = tardis.getTardisId();
                boolean hidden = tardis.isHidden();
                boolean handbrake = tardis.isHandbrakeOn();
                int level = tardis.getArtronLevel();
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!sender.hasPermission("tardis.admin")) {
                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                        wheret.put("uuid", player.getUniqueId().toString());
                        ResultSetTardis rst = new ResultSetTardis(this.plugin, wheret, "", false);
                        if (!rst.resultSet()) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_A_TIMELORD");
                            return true;
                        }
                        Object t = rst.getTardis();
                        int tardis_id = ((Tardis)t).getTardisId();
                        if (tardis_id != id) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ONLY_TL_REMOTE");
                            return true;
                        }
                        if (this.plugin.getConfig().getBoolean("allow.power_down") && !((Tardis)t).isPoweredOn()) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "POWER_DOWN");
                            return true;
                        }
                        TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
                        tcc.getCircuits();
                        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !tcc.hasMaterialisation()) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                            return true;
                        }
                        if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                            int uses_left = tcc.getMaterialisationUses();
                            new TARDISCircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player).damage();
                        }
                    }
                }
                try {
                    int travel;
                    Remote remote = Remote.valueOf(args[1].toUpperCase(Locale.ROOT));
                    OfflinePlayer p = this.plugin.getServer().getOfflinePlayer(uuid);
                    if (sender instanceof BlockCommandSender && p.getPlayer() == null) {
                        return true;
                    }
                    switch (remote) {
                        case HIDE: {
                            if (sender instanceof Player && !sender.hasPermission("tardis.admin") || sender instanceof BlockCommandSender) {
                                return new TARDISHideCommand(this.plugin).hide(p);
                            }
                            return new TARDISRemoteHideCommand(this.plugin).doRemoteHide(sender, id);
                        }
                        case REBUILD: {
                            if (sender instanceof Player && !sender.hasPermission("tardis.admin") || sender instanceof BlockCommandSender) {
                                return new TARDISRebuildCommand(this.plugin).rebuildPreset(p);
                            }
                            return new TARDISRemoteRebuildCommand(this.plugin).doRemoteRebuild(sender, id, p, hidden);
                        }
                        case COMEHERE: {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                if (sender.hasPermission("tardis.admin")) {
                                    return new TARDISRemoteComehereCommand(this.plugin).doRemoteComeHere(player, uuid);
                                }
                            }
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                            return true;
                        }
                        case BACK: {
                            if (sender instanceof Player && sender.hasPermission("tardis.admin") || sender instanceof ConsoleCommandSender) {
                                if (!handbrake) {
                                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                                    return true;
                                }
                                return new TARDISRemoteBackCommand(this.plugin).sendBack(sender, id, p);
                            }
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                            return true;
                        }
                    }
                    if (args.length < 3) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_REMOTE");
                        return false;
                    }
                    if (!handbrake) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                        return true;
                    }
                    if ((sender instanceof Player && !sender.hasPermission("tardis.admin") || sender instanceof BlockCommandSender) && level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                        return true;
                    }
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    switch (args[2].toLowerCase(Locale.ROOT)) {
                        case "home": {
                            HashMap<String, Object> wherehl = new HashMap<String, Object>();
                            wherehl.put("tardis_id", id);
                            ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, wherehl);
                            if (!rsh.resultSet()) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "HOME_NOT_FOUND");
                                return true;
                            }
                            set.put("world", rsh.getWorld().getName());
                            set.put("x", rsh.getX());
                            set.put("y", rsh.getY());
                            set.put("z", rsh.getZ());
                            set.put("direction", rsh.getDirection().toString());
                            set.put("submarine", rsh.isSubmarine() ? 1 : 0);
                            if (rsh.getPreset().isEmpty()) break;
                            HashMap<String, Object> wherep = new HashMap<String, Object>();
                            wherep.put("tardis_id", id);
                            HashMap<String, Object> setp = new HashMap<String, Object>();
                            setp.put("chameleon_preset", rsh.getPreset());
                            setp.put("adapti_on", 0);
                            this.plugin.getQueryFactory().doSyncUpdate("tardis", setp, wherep);
                            break;
                        }
                        case "area": {
                            Location l;
                            String invisibility;
                            if (args.length < 4) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                                return true;
                            }
                            HashMap<String, Object> wherea = new HashMap<String, Object>();
                            wherea.put("area_name", args[3]);
                            ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
                            if (!rsa.resultSet()) {
                                this.plugin.getMessenger().sendColouredCommand(sender, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                                return true;
                            }
                            if (sender instanceof Player && !sender.hasPermission("tardis.admin") || sender instanceof BlockCommandSender) {
                                if (this.plugin.getConfig().getBoolean("difficulty.disks")) {
                                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ADV_AREA");
                                    return true;
                                }
                                String perm = "tardis.area." + args[3];
                                if (!TARDISPermission.hasPermission(p, perm) && !TARDISPermission.hasPermission(p, "tardis.area.*")) {
                                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TRAVEL_NO_AREA_PERM", args[3]);
                                    return true;
                                }
                            }
                            if ((invisibility = rsa.getArea().invisibility()).equals("DENY") && tardis.getPreset().equals((Object)ChameleonPreset.INVISIBLE)) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "AREA_NO_INVISIBLE");
                                return true;
                            }
                            if (!invisibility.equals("ALLOW")) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "AREA_FORCE_PRESET", invisibility);
                                HashMap<String, Object> wherei = new HashMap<String, Object>();
                                wherei.put("tardis_id", id);
                                HashMap<String, Object> seti = new HashMap<String, Object>();
                                seti.put("chameleon_preset", invisibility);
                                seti.put("adapti_on", 0);
                                this.plugin.getQueryFactory().doSyncUpdate("tardis", seti, wherei);
                            }
                            if ((l = rsa.getArea().grid() ? this.plugin.getTardisArea().getNextSpot(rsa.getArea().areaName()) : this.plugin.getTardisArea().getSemiRandomLocation(rsa.getArea().areaId())) == null) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_MORE_SPOTS");
                                return true;
                            }
                            set.put("world", l.getWorld().getName());
                            set.put("x", l.getBlockX());
                            set.put("y", l.getBlockY());
                            set.put("z", l.getBlockZ());
                            if (!rsa.getArea().direction().isEmpty()) {
                                set.put("direction", rsa.getArea().direction());
                            } else {
                                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                                if (!rsc.resultSet()) {
                                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                                    return true;
                                }
                                set.put("direction", rsc.getCurrent().direction().toString());
                            }
                            set.put("submarine", 0);
                            break;
                        }
                        default: {
                            if (args.length < 6) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_COORDS");
                                return true;
                            }
                            if ((sender instanceof Player && !sender.hasPermission("tardis.admin") || sender instanceof BlockCommandSender) && !TARDISPermission.hasPermission(p, "tardis.timetravel.location")) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                                return true;
                            }
                            World w = TARDISAliasResolver.getWorldFromAlias(args[2]);
                            if (w == null) {
                                this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld", this.plugin);
                                return true;
                            }
                            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + w.getName() + ".time_travel")) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                                return true;
                            }
                            if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && args[2].equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                                return true;
                            }
                            int x = TARDISNumberParsers.parseInt(args[args.length - 3]);
                            int y = TARDISNumberParsers.parseInt(args[args.length - 2]);
                            if (y < -64 || w.getEnvironment().equals((Object)World.Environment.NORMAL) && y > 310 || !w.getEnvironment().equals((Object)World.Environment.NORMAL) && y > 240) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "Y_NOT_VALID");
                                return true;
                            }
                            int z = TARDISNumberParsers.parseInt(args[args.length - 1]);
                            Location location = new Location(w, (double)x, (double)y, (double)z);
                            if (this.plugin.getTardisArea().isInExistingArea(location)) {
                                this.plugin.getMessenger().sendColouredCommand(sender, "TRAVEL_IN_AREA", "/tardisremote [player] travel area [area name]", this.plugin);
                                return true;
                            }
                            if ((sender instanceof Player && !sender.hasPermission("tardis.admin") || sender instanceof BlockCommandSender) && !this.plugin.getPluginRespect().getRespect(location, new Parameters(p.getPlayer(), Flag.getDefaultFlags()))) {
                                return true;
                            }
                            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                            if (!rsc.resultSet()) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                                return true;
                            }
                            int[] start_loc = TARDISTimeTravel.getStartLocation(location, rsc.getCurrent().direction());
                            int count = TARDISTimeTravel.safeLocation(start_loc[0], location.getBlockY(), start_loc[2], start_loc[1], start_loc[3], location.getWorld(), rsc.getCurrent().direction());
                            if (count > 0) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_SAFE");
                                return true;
                            }
                            set.put("world", location.getWorld().getName());
                            set.put("x", location.getBlockX());
                            set.put("y", location.getBlockY());
                            set.put("z", location.getBlockZ());
                            set.put("submarine", 0);
                        }
                    }
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    this.plugin.getQueryFactory().doUpdate("next", set, wheret);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(uuid);
                        String success = new TARDISRemoteTravelCommand(this.plugin).doTravel(id, offlinePlayer, sender) ? this.plugin.getLanguage().getString("SUCCESS_Y") : this.plugin.getLanguage().getString("SUCCESS_N");
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "REMOTE_SUCCESS", success);
                    }, 5L);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_NOT_VALID");
                    return false;
                }
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2) {
            return this.partial(args[1], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("travel")) {
            return this.partial(args[2], (Collection<String>)this.TRAVEL_SUBS);
        }
        if (args.length == 4 && args[2].equalsIgnoreCase("area")) {
            return this.partial(args[3], this.AREA_SUBS);
        }
        return ImmutableList.of();
    }
}

