/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISEmergencyRelocation;
import me.eccentric_nz.TARDIS.console.ConsoleInteraction;
import me.eccentric_nz.TARDIS.console.models.ButtonModel;
import me.eccentric_nz.TARDIS.control.actions.ExileAction;
import me.eccentric_nz.TARDIS.control.actions.RandomDestinationAction;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRandomInteractions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class RandomiserInteraction {
    private final TARDIS plugin;

    public RandomiserInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void generateDestination(int id, Player player, Interaction interaction) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
            return;
        }
        TARDISCircuitChecker tcc = null;
        if (this.plugin.getConfig().getBoolean("difficulty.circuits")) {
            tcc = new TARDISCircuitChecker(this.plugin, id);
            tcc.getCircuits();
        }
        if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        int cost = this.plugin.getArtronConfig().getInt("random");
        if (tardis.getArtronLevel() < cost) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
            return;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            new TARDISEmergencyRelocation(this.plugin).relocate(id, player);
            return;
        }
        UUID uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
        if (uuid != null) {
            ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(uuid);
            new ButtonModel().setState(display, this.plugin, ConsoleInteraction.RANDOMISER);
        }
        Current current = rsc.getCurrent();
        COMPASS direction = current.direction();
        if (TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
            new ExileAction(this.plugin).getExile(player, id, direction);
        } else {
            ResultSetRandomInteractions rsri = new ResultSetRandomInteractions(this.plugin, id);
            if (rsri.resultSet()) {
                if (rsri.getStates()[4] != 0) {
                    World world = this.getWorldFromState(rsri.getStates()[4]);
                    if (world != null) {
                        Location rand = new TARDISTimeTravel(this.plugin).getDestination(world, rsri.getStates()[1], rsri.getStates()[2], rsri.getStates()[3], direction, world.getEnvironment().toString(), current.location(), player);
                        RandomDestinationAction.setDestination(this.plugin, player, id, direction, cost, tardis.getCompanions(), tardis.getUuid(), rand);
                    }
                } else {
                    new RandomDestinationAction(this.plugin).getRandomDestination(player, id, rsri.getStates(), current, direction, tardis.getArtronLevel(), cost, tardis.getCompanions(), tardis.getUuid());
                }
            }
        }
    }

    private World getWorldFromState(int state) {
        for (String w : this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false)) {
            if (this.plugin.getPlanetsConfig().getInt("planets." + w + ".helmic_regulator_order") != state) continue;
            return this.plugin.getServer().getWorld(w);
        }
        return null;
    }
}

